/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TlvPortId extends LldpUnit implements Message {

  // Accessors for discriminator values.
  public TlvType getTlvId() {
    return TlvType.PORT_ID;
  }

  // Properties.
  protected final short portIdSubType;
  protected final String portId;

  public TlvPortId(short tlvIdLength, short portIdSubType, String portId) {
    super(tlvIdLength);
    this.portIdSubType = portIdSubType;
    this.portId = portId;
  }

  public short getPortIdSubType() {
    return portIdSubType;
  }

  public String getPortId() {
    return portId;
  }

  @Override
  protected void serializeLldpUnitChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TlvPortId");

    // Simple Field (portIdSubType)
    writeSimpleField("portIdSubType", portIdSubType, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (portId)
    writeSimpleField("portId", portId, writeString(writeBuffer, (((tlvIdLength) - (1))) * (8)));

    writeBuffer.popContext("TlvPortId");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TlvPortId _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (portIdSubType)
    lengthInBits += 8;

    // Simple field (portId)
    lengthInBits += (((tlvIdLength) - (1))) * (8);

    return lengthInBits;
  }

  public static LldpUnitBuilder staticParseLldpUnitBuilder(ReadBuffer readBuffer, Short tlvIdLength)
      throws ParseException {
    readBuffer.pullContext("TlvPortId");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short portIdSubType = readSimpleField("portIdSubType", readUnsignedShort(readBuffer, 8));

    String portId =
        readSimpleField("portId", readString(readBuffer, (((tlvIdLength) - (1))) * (8)));

    readBuffer.closeContext("TlvPortId");
    // Create the instance
    return new TlvPortIdBuilderImpl(portIdSubType, portId);
  }

  public static class TlvPortIdBuilderImpl implements LldpUnit.LldpUnitBuilder {
    private final short portIdSubType;
    private final String portId;

    public TlvPortIdBuilderImpl(short portIdSubType, String portId) {
      this.portIdSubType = portIdSubType;
      this.portId = portId;
    }

    public TlvPortId build(short tlvIdLength) {
      TlvPortId tlvPortId = new TlvPortId(tlvIdLength, portIdSubType, portId);
      return tlvPortId;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TlvPortId)) {
      return false;
    }
    TlvPortId that = (TlvPortId) o;
    return (getPortIdSubType() == that.getPortIdSubType())
        && (getPortId() == that.getPortId())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPortIdSubType(), getPortId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
