/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SubscriptionAcknowledgement is the corresponding interface of SubscriptionAcknowledgement
type SubscriptionAcknowledgement interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSubscriptionId returns SubscriptionId (property field)
	GetSubscriptionId() uint32
	// GetSequenceNumber returns SequenceNumber (property field)
	GetSequenceNumber() uint32
	// IsSubscriptionAcknowledgement is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSubscriptionAcknowledgement()
	// CreateBuilder creates a SubscriptionAcknowledgementBuilder
	CreateSubscriptionAcknowledgementBuilder() SubscriptionAcknowledgementBuilder
}

// _SubscriptionAcknowledgement is the data-structure of this message
type _SubscriptionAcknowledgement struct {
	ExtensionObjectDefinitionContract
	SubscriptionId uint32
	SequenceNumber uint32
}

var _ SubscriptionAcknowledgement = (*_SubscriptionAcknowledgement)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_SubscriptionAcknowledgement)(nil)

// NewSubscriptionAcknowledgement factory function for _SubscriptionAcknowledgement
func NewSubscriptionAcknowledgement(subscriptionId uint32, sequenceNumber uint32) *_SubscriptionAcknowledgement {
	_result := &_SubscriptionAcknowledgement{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SubscriptionId:                    subscriptionId,
		SequenceNumber:                    sequenceNumber,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SubscriptionAcknowledgementBuilder is a builder for SubscriptionAcknowledgement
type SubscriptionAcknowledgementBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(subscriptionId uint32, sequenceNumber uint32) SubscriptionAcknowledgementBuilder
	// WithSubscriptionId adds SubscriptionId (property field)
	WithSubscriptionId(uint32) SubscriptionAcknowledgementBuilder
	// WithSequenceNumber adds SequenceNumber (property field)
	WithSequenceNumber(uint32) SubscriptionAcknowledgementBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the SubscriptionAcknowledgement or returns an error if something is wrong
	Build() (SubscriptionAcknowledgement, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SubscriptionAcknowledgement
}

// NewSubscriptionAcknowledgementBuilder() creates a SubscriptionAcknowledgementBuilder
func NewSubscriptionAcknowledgementBuilder() SubscriptionAcknowledgementBuilder {
	return &_SubscriptionAcknowledgementBuilder{_SubscriptionAcknowledgement: new(_SubscriptionAcknowledgement)}
}

type _SubscriptionAcknowledgementBuilder struct {
	*_SubscriptionAcknowledgement

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (SubscriptionAcknowledgementBuilder) = (*_SubscriptionAcknowledgementBuilder)(nil)

func (b *_SubscriptionAcknowledgementBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._SubscriptionAcknowledgement
}

func (b *_SubscriptionAcknowledgementBuilder) WithMandatoryFields(subscriptionId uint32, sequenceNumber uint32) SubscriptionAcknowledgementBuilder {
	return b.WithSubscriptionId(subscriptionId).WithSequenceNumber(sequenceNumber)
}

func (b *_SubscriptionAcknowledgementBuilder) WithSubscriptionId(subscriptionId uint32) SubscriptionAcknowledgementBuilder {
	b.SubscriptionId = subscriptionId
	return b
}

func (b *_SubscriptionAcknowledgementBuilder) WithSequenceNumber(sequenceNumber uint32) SubscriptionAcknowledgementBuilder {
	b.SequenceNumber = sequenceNumber
	return b
}

func (b *_SubscriptionAcknowledgementBuilder) Build() (SubscriptionAcknowledgement, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SubscriptionAcknowledgement.deepCopy(), nil
}

func (b *_SubscriptionAcknowledgementBuilder) MustBuild() SubscriptionAcknowledgement {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SubscriptionAcknowledgementBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_SubscriptionAcknowledgementBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_SubscriptionAcknowledgementBuilder) DeepCopy() any {
	_copy := b.CreateSubscriptionAcknowledgementBuilder().(*_SubscriptionAcknowledgementBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSubscriptionAcknowledgementBuilder creates a SubscriptionAcknowledgementBuilder
func (b *_SubscriptionAcknowledgement) CreateSubscriptionAcknowledgementBuilder() SubscriptionAcknowledgementBuilder {
	if b == nil {
		return NewSubscriptionAcknowledgementBuilder()
	}
	return &_SubscriptionAcknowledgementBuilder{_SubscriptionAcknowledgement: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SubscriptionAcknowledgement) GetExtensionId() int32 {
	return int32(823)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SubscriptionAcknowledgement) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SubscriptionAcknowledgement) GetSubscriptionId() uint32 {
	return m.SubscriptionId
}

func (m *_SubscriptionAcknowledgement) GetSequenceNumber() uint32 {
	return m.SequenceNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSubscriptionAcknowledgement(structType any) SubscriptionAcknowledgement {
	if casted, ok := structType.(SubscriptionAcknowledgement); ok {
		return casted
	}
	if casted, ok := structType.(*SubscriptionAcknowledgement); ok {
		return *casted
	}
	return nil
}

func (m *_SubscriptionAcknowledgement) GetTypeName() string {
	return "SubscriptionAcknowledgement"
}

func (m *_SubscriptionAcknowledgement) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (subscriptionId)
	lengthInBits += 32

	// Simple field (sequenceNumber)
	lengthInBits += 32

	return lengthInBits
}

func (m *_SubscriptionAcknowledgement) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SubscriptionAcknowledgement) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__subscriptionAcknowledgement SubscriptionAcknowledgement, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SubscriptionAcknowledgement"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SubscriptionAcknowledgement")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	subscriptionId, err := ReadSimpleField(ctx, "subscriptionId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'subscriptionId' field"))
	}
	m.SubscriptionId = subscriptionId

	sequenceNumber, err := ReadSimpleField(ctx, "sequenceNumber", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sequenceNumber' field"))
	}
	m.SequenceNumber = sequenceNumber

	if closeErr := readBuffer.CloseContext("SubscriptionAcknowledgement"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SubscriptionAcknowledgement")
	}

	return m, nil
}

func (m *_SubscriptionAcknowledgement) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SubscriptionAcknowledgement) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SubscriptionAcknowledgement"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SubscriptionAcknowledgement")
		}

		if err := WriteSimpleField[uint32](ctx, "subscriptionId", m.GetSubscriptionId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'subscriptionId' field")
		}

		if err := WriteSimpleField[uint32](ctx, "sequenceNumber", m.GetSequenceNumber(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'sequenceNumber' field")
		}

		if popErr := writeBuffer.PopContext("SubscriptionAcknowledgement"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SubscriptionAcknowledgement")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SubscriptionAcknowledgement) IsSubscriptionAcknowledgement() {}

func (m *_SubscriptionAcknowledgement) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SubscriptionAcknowledgement) deepCopy() *_SubscriptionAcknowledgement {
	if m == nil {
		return nil
	}
	_SubscriptionAcknowledgementCopy := &_SubscriptionAcknowledgement{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SubscriptionId,
		m.SequenceNumber,
	}
	_SubscriptionAcknowledgementCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _SubscriptionAcknowledgementCopy
}

func (m *_SubscriptionAcknowledgement) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
