/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.EntityUtils;
import org.archive.util.binsearch.impl.HTTPSeekableLineReader;
import org.archive.util.zip.GZIPMembersInputStream;

public class ApacheHttp43SLR
extends HTTPSeekableLineReader {
    private String urlString;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private Socket socket = null;
    private DefaultBHttpClientConnection activeConn = null;
    private HttpResponse response = null;
    private static final int BUFF_SIZE = 8192;

    public ApacheHttp43SLR(String url) {
        this.urlString = url;
    }

    public ApacheHttp43SLR(String url, int connectTimeout, int readTimeout) {
        this.urlString = url;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public String getUrl() {
        return this.urlString;
    }

    @Override
    public long getSize() throws IOException {
        if (this.response == null) {
            return 0L;
        }
        return this.response.getEntity().getContentLength();
    }

    @Override
    public String getHeaderValue(String headerName) {
        if (this.response == null) {
            return null;
        }
        Header header = this.response.getFirstHeader(headerName);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    protected static int getPort(URL url) {
        int port = url.getPort();
        if (port > 0) {
            return port;
        }
        return url.getDefaultPort();
    }

    protected InputStream doSeekLoad(long offset, int maxLength, URL url) throws IOException {
        try {
            InetSocketAddress endpoint = new InetSocketAddress(url.getHost(), ApacheHttp43SLR.getPort(url));
            this.socket = new Socket();
            this.socket.connect(endpoint, this.connectTimeout);
            this.activeConn = new DefaultBHttpClientConnection(8192);
            this.activeConn.bind(this.socket);
            this.activeConn.setSocketTimeout(this.readTimeout);
            BasicHttpRequest request = new BasicHttpRequest("GET", url.getFile(), (ProtocolVersion)HttpVersion.HTTP_1_1);
            String rangeHeader = ApacheHttp43SLR.makeRangeHeader(offset, maxLength);
            if (rangeHeader != null) {
                request.setHeader("Range", rangeHeader);
            }
            if (this.isNoKeepAlive()) {
                request.setHeader("Connection", "close");
            } else {
                request.setHeader("Connection", "keep-alive");
            }
            if (this.getCookie() != null) {
                request.setHeader("Cookie", this.getCookie());
            }
            request.setHeader("Accept", "*/*");
            request.setHeader("Host", url.getHost());
            this.activeConn.sendRequestHeader((HttpRequest)request);
            this.activeConn.flush();
            this.response = this.activeConn.receiveResponseHeader();
            int code = this.response.getStatusLine().getStatusCode();
            this.connectedUrl = url.toString();
            if (code > 300 && code < 400) {
                Header header = this.response.getFirstHeader("Location");
                this.doClose();
                if (header != null) {
                    URL redirectURL = new URL(header.getValue());
                    return this.doSeekLoad(offset, maxLength, redirectURL);
                }
            }
            if (code != 200 && code != 206) {
                throw new HTTPSeekableLineReader.BadHttpStatusException(code, this.connectedUrl + " " + rangeHeader);
            }
            this.activeConn.receiveResponseEntity(this.response);
            return this.response.getEntity().getContent();
        }
        catch (HttpException e) {
            this.doClose();
            throw new IOException(e);
        }
        catch (IOException io) {
            if (this.saveErrHeader != null) {
                this.errHeader = this.getHeaderValue(this.saveErrHeader);
            }
            this.connectedUrl = url.toString();
            this.doClose();
            throw io;
        }
    }

    @Override
    public void seekWithMaxRead(long offset, boolean gzip, int maxLength) throws IOException {
        if (this.closed) {
            throw new IOException("Seek after close()");
        }
        this.br = null;
        try {
            this.doSeekLoad(offset, maxLength);
            if (this.bufferFully && maxLength > 0) {
                byte[] buffer = EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
                this.doClose();
                this.is = new ByteArrayInputStream(buffer);
            }
            if (gzip) {
                this.is = new GZIPMembersInputStream(this.is, this.blockSize);
            }
        }
        catch (IOException io) {
            this.doClose();
            throw io;
        }
    }

    @Override
    protected void doClose() throws IOException {
        if (this.activeConn != null) {
            this.activeConn.close();
            this.activeConn = null;
            this.socket = null;
        } else if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.response = null;
    }

    @Override
    protected InputStream doSeekLoad(long offset, int maxLength) throws IOException {
        return this.doSeekLoad(offset, maxLength, new URL(this.urlString));
    }
}

