/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.anvl;

import org.archive.util.anvl.ANVLRecord;
import org.archive.util.anvl.SubElement;

class Value
extends SubElement {
    private StringBuilder sb;
    private boolean folding = false;

    private Value() {
        this(null);
    }

    public Value(String s) {
        super(s);
    }

    @Override
    protected String baseCheck(String s) {
        this.sb = new StringBuilder(s.length() * 2);
        super.baseCheck(s);
        return this.sb.toString();
    }

    @Override
    protected void checkCharacter(char c, String srcStr, int index) {
        this.checkControlCharacter(c, srcStr, index);
        if (ANVLRecord.isCR(c)) {
            this.folding = true;
            this.sb.append("\r\n ");
        } else if (ANVLRecord.isLF(c)) {
            if (!this.folding) {
                this.folding = true;
                this.sb.append("\r\n ");
            }
        } else if (!this.folding || !Character.isWhitespace(c)) {
            this.folding = false;
            this.sb.append(c);
        }
    }
}

