/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.producer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.fs.FSDataInputStream;
import org.archive.format.gzip.GZIPMemberSeries;
import org.archive.resource.ResourceFactory;
import org.archive.resource.ResourceProducer;
import org.archive.resource.TransformingResourceProducer;
import org.archive.resource.generic.GenericResourceProducer;
import org.archive.resource.gzip.GZIPResourceContainer;
import org.archive.streamcontext.HDFSStream;
import org.archive.streamcontext.HTTP11Stream;
import org.archive.streamcontext.RandomAccessFileStream;
import org.archive.streamcontext.Stream;

public class EnvelopedResourceFile {
    private ResourceFactory factory;
    private boolean strict = true;
    private long startOffset = 0L;

    public EnvelopedResourceFile(ResourceFactory factory) {
        this.factory = factory;
    }

    private ResourceProducer getProducer(Stream stream, String name) {
        GenericResourceProducer producer = new GenericResourceProducer(stream, name);
        return new TransformingResourceProducer(producer, this.factory);
    }

    private ResourceProducer getGZProducer(Stream stream, String name) {
        GZIPMemberSeries series = new GZIPMemberSeries(stream, name, this.startOffset, this.strict);
        GZIPResourceContainer producer = new GZIPResourceContainer(series);
        if (this.factory == null) {
            return producer;
        }
        return new TransformingResourceProducer(producer, this.factory);
    }

    public ResourceProducer getResourceProducer(File file) throws IOException {
        return this.getResourceProducer(file, 0L);
    }

    public ResourceProducer getResourceProducer(File file, long offset) throws IOException {
        RandomAccessFileStream stream = new RandomAccessFileStream(file);
        if (offset > 0L) {
            stream.setOffset(offset);
        }
        return this.getProducer(stream, file.getName());
    }

    public ResourceProducer getGZResourceProducer(File file) throws IOException {
        return this.getGZResourceProducer(file, 0L);
    }

    public ResourceProducer getGZResourceProducer(File file, long offset) throws IOException {
        RandomAccessFileStream stream = new RandomAccessFileStream(file);
        if (offset > 0L) {
            stream.setOffset(offset);
        }
        return this.getGZProducer(stream, file.getName());
    }

    public ResourceProducer getGZResourceProducer(FSDataInputStream fsdis, String name) throws IOException {
        return this.getGZResourceProducer(fsdis, name, 0L);
    }

    public ResourceProducer getGZResourceProducer(FSDataInputStream fsdis, String name, long offset) throws IOException {
        HDFSStream stream = new HDFSStream(fsdis);
        if (offset > 0L) {
            stream.setOffset(offset);
        }
        return this.getGZProducer(stream, name);
    }

    public ResourceProducer getResourceProducer(FSDataInputStream fsdis, String name) throws IOException {
        return this.getResourceProducer(fsdis, name, 0L);
    }

    public ResourceProducer getResourceProducer(FSDataInputStream fsdis, String name, long offset) throws IOException {
        HDFSStream stream = new HDFSStream(fsdis);
        if (offset > 0L) {
            stream.setOffset(offset);
        }
        return this.getProducer(stream, name);
    }

    private String urlName(URL url) {
        File file = new File(url.getPath());
        String name = file.getName();
        if (name == null || name.length() == 0) {
            return "UNKNOWN";
        }
        return name;
    }

    public ResourceProducer getResourceProducer(URL url) throws IOException {
        return this.getResourceProducer(url, 0L);
    }

    public ResourceProducer getResourceProducer(URL url, long offset) throws IOException {
        return this.getResourceProducer(url, this.urlName(url), offset);
    }

    public ResourceProducer getResourceProducer(URL url, String name) throws IOException {
        return this.getResourceProducer(url, name, 0L);
    }

    public ResourceProducer getResourceProducer(URL url, String name, long offset) throws IOException {
        HTTP11Stream stream = new HTTP11Stream(url);
        if (offset > 0L) {
            stream.setOffset(offset);
        }
        return this.getProducer(stream, name);
    }

    public ResourceProducer getGZResourceProducer(URL url) throws IOException {
        return this.getGZResourceProducer(url, 0L);
    }

    public ResourceProducer getGZResourceProducer(URL url, long offset) throws IOException {
        return this.getGZResourceProducer(url, this.urlName(url), offset);
    }

    public ResourceProducer getGZResourceProducer(URL url, String name) throws IOException {
        return this.getGZResourceProducer(url, name, 0L);
    }

    public ResourceProducer getGZResourceProducer(URL url, String name, long offset) throws IOException {
        HTTP11Stream stream = new HTTP11Stream(url);
        if (offset > 0L) {
            stream.setOffset(offset);
        }
        return this.getGZProducer(stream, name);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }
}

