/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.handlers;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

public class PKCS7ContentHandler
implements DataContentHandler {
    private final ActivationDataFlavor _adf;
    private final ActivationDataFlavor[] _dfs;

    PKCS7ContentHandler(ActivationDataFlavor activationDataFlavor, ActivationDataFlavor[] activationDataFlavorArray) {
        this._adf = activationDataFlavor;
        this._dfs = activationDataFlavorArray;
    }

    public Object getContent(DataSource dataSource) throws IOException {
        return dataSource.getInputStream();
    }

    public Object getTransferData(ActivationDataFlavor activationDataFlavor, DataSource dataSource) throws IOException {
        if (this._adf.equals(activationDataFlavor)) {
            return this.getContent(dataSource);
        }
        return null;
    }

    public ActivationDataFlavor[] getTransferDataFlavors() {
        return this._dfs;
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (object instanceof MimeBodyPart) {
            try {
                ((MimeBodyPart)object).writeTo(outputStream);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.getMessage());
            }
        } else if (object instanceof byte[]) {
            outputStream.write((byte[])object);
        } else if (object instanceof InputStream) {
            int n;
            InputStream inputStream = (InputStream)object;
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            while ((n = inputStream.read()) >= 0) {
                outputStream.write(n);
            }
            inputStream.close();
        } else if (object instanceof SMIMEStreamingProcessor) {
            SMIMEStreamingProcessor sMIMEStreamingProcessor = (SMIMEStreamingProcessor)object;
            sMIMEStreamingProcessor.write(outputStream);
        } else {
            throw new IOException("unknown object in writeTo " + object);
        }
    }
}

