/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class IdempotentCloser
implements AutoCloseable {
    private final AtomicBoolean isClosed;

    public IdempotentCloser() {
        this(false);
    }

    public IdempotentCloser(boolean isClosed) {
        this.isClosed = new AtomicBoolean(isClosed);
    }

    public void assertOpen(Supplier<String> message) {
        if (this.isClosed.get()) {
            throw new IllegalStateException(message.get());
        }
    }

    public void assertOpen(String message) {
        if (this.isClosed.get()) {
            throw new IllegalStateException(message);
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        this.close(null, null);
    }

    public void close(Runnable onInitialClose) {
        this.close(onInitialClose, null);
    }

    public void close(Runnable onInitialClose, Runnable onSubsequentClose) {
        if (this.isClosed.compareAndSet(false, true)) {
            if (onInitialClose != null) {
                onInitialClose.run();
            }
        } else if (onSubsequentClose != null) {
            onSubsequentClose.run();
        }
    }

    public String toString() {
        return "IdempotentCloser{isClosed=" + this.isClosed + '}';
    }
}

