/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectConverter
implements Converter {
    public static final ObjectConverter INSTANCE = new ObjectConverter();

    ObjectConverter() {
    }

    @Override
    public Object convert(JSON jSON, JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        Map<String, PropertyInfo> map = context.getSetProperties(clazz);
        if (object instanceof Map) {
            Object obj = jSON.create(context, clazz);
            if (obj == null) {
                return null;
            }
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String string = entry.getKey().toString();
                PropertyInfo propertyInfo = map.get(string);
                if (propertyInfo == null) {
                    propertyInfo = map.get(ObjectConverter.toLowerCamel(context, string));
                }
                if (propertyInfo == null) continue;
                context.enter(string, propertyInfo.getWriteAnnotation(JSONHint.class));
                Class<?> clazz2 = propertyInfo.getWriteType();
                Type type2 = propertyInfo.getWriteGenericType();
                if (type2 instanceof TypeVariable && type instanceof ParameterizedType) {
                    type2 = ObjectConverter.resolveTypeVariable((TypeVariable)type2, (ParameterizedType)type);
                    clazz2 = ClassUtil.getRawType(type2);
                }
                propertyInfo.set(obj, jSON.postparse(context, entry.getValue(), clazz2, type2));
                context.exit();
            }
            return obj;
        }
        if (object instanceof List) {
            throw new UnsupportedOperationException("Cannot convert " + object.getClass() + " to " + type);
        }
        JSONHint jSONHint = context.getHint();
        if (jSONHint != null && jSONHint.anonym().length() > 0) {
            PropertyInfo propertyInfo = map.get(jSONHint.anonym());
            if (propertyInfo == null) {
                return null;
            }
            Object obj = jSON.create(context, clazz);
            if (obj == null) {
                return null;
            }
            context.enter(jSONHint.anonym(), propertyInfo.getWriteAnnotation(JSONHint.class));
            Class<?> clazz3 = propertyInfo.getWriteType();
            Type type3 = propertyInfo.getWriteGenericType();
            if (type3 instanceof TypeVariable && type instanceof ParameterizedType) {
                type3 = ObjectConverter.resolveTypeVariable((TypeVariable)type3, (ParameterizedType)type);
                clazz3 = ClassUtil.getRawType(type3);
            }
            propertyInfo.set(obj, jSON.postparse(context, object, clazz3, type3));
            context.exit();
            return obj;
        }
        throw new UnsupportedOperationException("Cannot convert " + object.getClass() + " to " + type);
    }

    private static String toLowerCamel(JSON.Context context, String string) {
        StringBuilder stringBuilder = context.getCachedBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 1 && Character.isUpperCase(stringBuilder.charAt(0)) && !Character.isUpperCase(stringBuilder.charAt(1))) {
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
        }
        return stringBuilder.toString();
    }

    private static Type resolveTypeVariable(TypeVariable<?> typeVariable, ParameterizedType parameterizedType) {
        Class<?> clazz = ClassUtil.getRawType(parameterizedType);
        if (clazz.equals(typeVariable.getGenericDeclaration())) {
            String string = typeVariable.getName();
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeVariableArray.length; ++i) {
                if (!string.equals(typeVariableArray[i].getName())) continue;
                return typeArray[i];
            }
        }
        return typeVariable.getBounds()[0];
    }
}

