/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;

public class ClientMetricsConfigs
extends AbstractConfig {
    public static final String SUBSCRIPTION_METRICS = "metrics";
    public static final String PUSH_INTERVAL_MS = "interval.ms";
    public static final String CLIENT_MATCH_PATTERN = "match";
    public static final String CLIENT_INSTANCE_ID = "client_instance_id";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SOFTWARE_NAME = "client_software_name";
    public static final String CLIENT_SOFTWARE_VERSION = "client_software_version";
    public static final String CLIENT_SOURCE_ADDRESS = "client_source_address";
    public static final String CLIENT_SOURCE_PORT = "client_source_port";
    public static final String ALL_SUBSCRIBED_METRICS_CONFIG = "*";
    public static final int DEFAULT_INTERVAL_MS = 300000;
    private static final int MIN_INTERVAL_MS = 100;
    private static final int MAX_INTERVAL_MS = 3600000;
    private static final Set<String> ALLOWED_MATCH_PARAMS = new HashSet<String>(Arrays.asList("client_instance_id", "client_id", "client_software_name", "client_software_version", "client_source_address", "client_source_port"));
    private static final ConfigDef CONFIG = new ConfigDef().define("metrics", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, "Subscription metrics list").define("interval.ms", ConfigDef.Type.INT, (Object)300000, ConfigDef.Importance.MEDIUM, "Push interval in milliseconds").define("match", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, "Client match pattern list");

    public ClientMetricsConfigs(Properties props) {
        super(CONFIG, (Map)props);
    }

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public static Set<String> names() {
        return CONFIG.names();
    }

    public static void validate(String subscriptionName, Properties properties) {
        if (subscriptionName == null || subscriptionName.isEmpty()) {
            throw new InvalidRequestException("Subscription name can't be empty");
        }
        ClientMetricsConfigs.validateProperties(properties);
    }

    private static void validateProperties(Properties properties) {
        int pushIntervalMs;
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!ClientMetricsConfigs.names().contains(key)) {
                throw new InvalidRequestException("Unknown client metrics configuration: " + key);
            }
        }));
        if (properties.containsKey(PUSH_INTERVAL_MS) && ((pushIntervalMs = Integer.parseInt(properties.getProperty(PUSH_INTERVAL_MS))) < 100 || pushIntervalMs > 3600000)) {
            String msg = String.format("Invalid value %s for %s, interval must be between 100 and 3600000 (1 hour)", pushIntervalMs, PUSH_INTERVAL_MS);
            throw new InvalidRequestException(msg);
        }
        if (properties.containsKey(CLIENT_MATCH_PATTERN)) {
            List<String> patterns = Arrays.asList(properties.getProperty(CLIENT_MATCH_PATTERN).split(","));
            ClientMetricsConfigs.parseMatchingPatterns(patterns);
        }
    }

    public static Map<String, Pattern> parseMatchingPatterns(List<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Pattern> patternsMap = new HashMap<String, Pattern>();
        patterns.forEach(pattern -> {
            String[] nameValuePair = pattern.split("=");
            if (nameValuePair.length != 2) {
                throw new InvalidConfigurationException("Illegal client matching pattern: " + pattern);
            }
            String param = nameValuePair[0].trim();
            if (!ClientMetricsConfigs.isValidParam(param)) {
                throw new InvalidConfigurationException("Illegal client matching pattern: " + pattern);
            }
            try {
                Pattern patternValue = Pattern.compile(nameValuePair[1].trim());
                patternsMap.put(param, patternValue);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidConfigurationException("Illegal client matching pattern: " + pattern);
            }
        });
        return patternsMap;
    }

    private static boolean isValidParam(String paramName) {
        return ALLOWED_MATCH_PARAMS.contains(paramName);
    }
}

