/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;

public class JsonUtilClient {
    static final DatanodeInfo[] EMPTY_DATANODE_INFO_ARRAY = new DatanodeInfo[0];
    static final String UNSUPPPORTED_EXCEPTION_STR = UnsupportedOperationException.class.getName();

    static RemoteException toRemoteException(Map<?, ?> json) {
        Map m = (Map)json.get(RemoteException.class.getSimpleName());
        String message = (String)m.get("message");
        String javaClassName = (String)m.get("javaClassName");
        if (UNSUPPPORTED_EXCEPTION_STR.equals(javaClassName)) {
            throw new UnsupportedOperationException(message);
        }
        return new RemoteException(javaClassName, message);
    }

    static Token<? extends TokenIdentifier> toToken(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString((String)m.get("urlString"));
        return token;
    }

    static Token<BlockTokenIdentifier> toBlockToken(Map<?, ?> m) throws IOException {
        return JsonUtilClient.toToken(m);
    }

    static FsPermission toFsPermission(String s) {
        return null == s ? null : new FsPermission(Short.parseShort(s, 8));
    }

    public static HdfsFileStatus toFileStatus(Map<?, ?> json, boolean includesType) {
        if (json == null) {
            return null;
        }
        Map m = includesType ? (Map)json.get(FileStatus.class.getSimpleName()) : json;
        String localName = (String)m.get("pathSuffix");
        WebHdfsConstants.PathType type = WebHdfsConstants.PathType.valueOf((String)m.get("type"));
        byte[] symlink = type != WebHdfsConstants.PathType.SYMLINK ? null : DFSUtilClient.string2Bytes((String)m.get("symlink"));
        long len = ((Number)m.get("length")).longValue();
        String owner = (String)m.get("owner");
        String group = (String)m.get("group");
        FsPermission permission = JsonUtilClient.toFsPermission((String)m.get("permission"));
        Boolean aclBit = (Boolean)m.get("aclBit");
        Boolean encBit = (Boolean)m.get("encBit");
        Boolean erasureBit = (Boolean)m.get("ecBit");
        Boolean snapshotEnabledBit = (Boolean)m.get("snapshotEnabled");
        EnumSet<HdfsFileStatus.Flags> f = EnumSet.noneOf(HdfsFileStatus.Flags.class);
        if (aclBit != null && aclBit.booleanValue()) {
            f.add(HdfsFileStatus.Flags.HAS_ACL);
        }
        if (encBit != null && encBit.booleanValue()) {
            f.add(HdfsFileStatus.Flags.HAS_CRYPT);
        }
        if (erasureBit != null && erasureBit.booleanValue()) {
            f.add(HdfsFileStatus.Flags.HAS_EC);
        }
        if (snapshotEnabledBit != null && snapshotEnabledBit.booleanValue()) {
            f.add(HdfsFileStatus.Flags.SNAPSHOT_ENABLED);
        }
        Map ecPolicyObj = (Map)m.get("ecPolicyObj");
        ErasureCodingPolicy ecPolicy = null;
        if (ecPolicyObj != null) {
            Map extraOptions = (Map)ecPolicyObj.get("extraOptions");
            ECSchema ecSchema = new ECSchema((String)ecPolicyObj.get("codecName"), (int)((Number)ecPolicyObj.get("numDataUnits")).longValue(), (int)((Number)ecPolicyObj.get("numParityUnits")).longValue(), extraOptions);
            ecPolicy = new ErasureCodingPolicy((String)ecPolicyObj.get("name"), ecSchema, (int)((Number)ecPolicyObj.get("cellSize")).longValue(), (byte)((Number)ecPolicyObj.get("id")).longValue());
        }
        long aTime = ((Number)m.get("accessTime")).longValue();
        long mTime = ((Number)m.get("modificationTime")).longValue();
        long blockSize = ((Number)m.get("blockSize")).longValue();
        short replication = ((Number)m.get("replication")).shortValue();
        long fileId = m.containsKey("fileId") ? ((Number)m.get("fileId")).longValue() : 0L;
        int childrenNum = JsonUtilClient.getInt(m, "childrenNum", -1);
        byte storagePolicy = m.containsKey("storagePolicy") ? (byte)((Number)m.get("storagePolicy")).longValue() : (byte)0;
        return new HdfsFileStatus.Builder().length(len).isdir(type == WebHdfsConstants.PathType.DIRECTORY).replication(replication).blocksize(blockSize).mtime(mTime).atime(aTime).perm(permission).flags(f).owner(owner).group(group).symlink(symlink).path(DFSUtilClient.string2Bytes(localName)).fileId(fileId).children(childrenNum).storagePolicy(storagePolicy).ecPolicy(ecPolicy).build();
    }

    static HdfsFileStatus[] toHdfsFileStatusArray(Map<?, ?> json) {
        Preconditions.checkNotNull(json);
        Map rootmap = (Map)json.get(FileStatus.class.getSimpleName() + "es");
        List<?> array = JsonUtilClient.getList(rootmap, FileStatus.class.getSimpleName());
        Preconditions.checkNotNull(array);
        HdfsFileStatus[] statuses = new HdfsFileStatus[array.size()];
        int i = 0;
        for (Object object : array) {
            Map m = (Map)object;
            statuses[i++] = JsonUtilClient.toFileStatus(m, false);
        }
        return statuses;
    }

    static DirectoryListing toDirectoryListing(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map<?, ?> listing = JsonUtilClient.getMap(json, "DirectoryListing");
        Map<?, ?> partialListing = JsonUtilClient.getMap(listing, "partialListing");
        HdfsFileStatus[] fileStatuses = JsonUtilClient.toHdfsFileStatusArray(partialListing);
        int remainingEntries = JsonUtilClient.getInt(listing, "remainingEntries", -1);
        Preconditions.checkState((remainingEntries != -1 ? 1 : 0) != 0, (Object)"remainingEntries was not set");
        return new DirectoryListing(fileStatuses, remainingEntries);
    }

    static ExtendedBlock toExtendedBlock(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        String blockPoolId = (String)m.get("blockPoolId");
        long blockId = ((Number)m.get("blockId")).longValue();
        long numBytes = ((Number)m.get("numBytes")).longValue();
        long generationStamp = ((Number)m.get("generationStamp")).longValue();
        return new ExtendedBlock(blockPoolId, blockId, numBytes, generationStamp);
    }

    static int getInt(Map<?, ?> m, String key, int defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    static long getLong(Map<?, ?> m, String key, long defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).longValue();
    }

    static String getString(Map<?, ?> m, String key, String defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    static List<?> getList(Map<?, ?> m, String key) {
        Object list = m.get(key);
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    static Map<?, ?> getMap(Map<?, ?> m, String key) {
        Object map = m.get(key);
        if (map instanceof Map) {
            return (Map)map;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DatanodeInfo toDatanodeInfo(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        String ipAddr = JsonUtilClient.getString(m, "ipAddr", null);
        int xferPort = JsonUtilClient.getInt(m, "xferPort", -1);
        if (ipAddr == null) {
            String name = JsonUtilClient.getString(m, "name", null);
            if (name == null) throw new IOException("Missing both 'ipAddr' and 'name' in server response.");
            int colonIdx = name.indexOf(58);
            if (colonIdx <= 0) throw new IOException("Invalid value in server response: name=[" + name + "]");
            ipAddr = name.substring(0, colonIdx);
            xferPort = Integer.parseInt(name.substring(colonIdx + 1));
        }
        if (xferPort != -1) return new DatanodeInfo.DatanodeInfoBuilder().setIpAddr(ipAddr).setHostName((String)m.get("hostName")).setDatanodeUuid((String)m.get("storageID")).setXferPort(xferPort).setInfoPort(((Number)m.get("infoPort")).intValue()).setInfoSecurePort(JsonUtilClient.getInt(m, "infoSecurePort", 0)).setIpcPort(((Number)m.get("ipcPort")).intValue()).setCapacity(JsonUtilClient.getLong(m, "capacity", 0L)).setDfsUsed(JsonUtilClient.getLong(m, "dfsUsed", 0L)).setRemaining(JsonUtilClient.getLong(m, "remaining", 0L)).setBlockPoolUsed(JsonUtilClient.getLong(m, "blockPoolUsed", 0L)).setCacheCapacity(JsonUtilClient.getLong(m, "cacheCapacity", 0L)).setCacheUsed(JsonUtilClient.getLong(m, "cacheUsed", 0L)).setLastUpdate(JsonUtilClient.getLong(m, "lastUpdate", 0L)).setLastUpdateMonotonic(JsonUtilClient.getLong(m, "lastUpdateMonotonic", 0L)).setXceiverCount(JsonUtilClient.getInt(m, "xceiverCount", 0)).setNetworkLocation(JsonUtilClient.getString(m, "networkLocation", "")).setAdminState(DatanodeInfo.AdminStates.valueOf(JsonUtilClient.getString(m, "adminState", "NORMAL"))).setUpgradeDomain(JsonUtilClient.getString(m, "upgradeDomain", "")).setLastBlockReportTime(JsonUtilClient.getLong(m, "lastBlockReportTime", 0L)).setLastBlockReportMonotonic(JsonUtilClient.getLong(m, "lastBlockReportMonotonic", 0L)).build();
        throw new IOException("Invalid or missing 'xferPort' in server response.");
    }

    static DatanodeInfo[] toDatanodeInfoArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return EMPTY_DATANODE_INFO_ARRAY;
        }
        DatanodeInfo[] array = new DatanodeInfo[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = JsonUtilClient.toDatanodeInfo((Map)object);
        }
        return array;
    }

    static StorageType[] toStorageTypeArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return StorageType.EMPTY_ARRAY;
        }
        StorageType[] array = new StorageType[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = StorageType.parseStorageType((String)object.toString());
        }
        return array;
    }

    static LocatedBlock toLocatedBlock(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        ExtendedBlock b = JsonUtilClient.toExtendedBlock((Map)m.get("block"));
        DatanodeInfo[] locations = JsonUtilClient.toDatanodeInfoArray(JsonUtilClient.getList(m, "locations"));
        long startOffset = ((Number)m.get("startOffset")).longValue();
        boolean isCorrupt = (Boolean)m.get("isCorrupt");
        DatanodeInfo[] cachedLocations = JsonUtilClient.toDatanodeInfoArray(JsonUtilClient.getList(m, "cachedLocations"));
        StorageType[] storageTypes = JsonUtilClient.toStorageTypeArray(JsonUtilClient.getList(m, "storageTypes"));
        LocatedBlock locatedblock = new LocatedBlock(b, locations, null, storageTypes, startOffset, isCorrupt, cachedLocations);
        locatedblock.setBlockToken(JsonUtilClient.toBlockToken((Map)m.get("blockToken")));
        return locatedblock;
    }

    static List<LocatedBlock> toLocatedBlockList(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocatedBlock> list = new ArrayList<LocatedBlock>(objects.size());
        for (Object object : objects) {
            list.add(JsonUtilClient.toLocatedBlock((Map)object));
        }
        return list;
    }

    static ContentSummary toContentSummary(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(ContentSummary.class.getSimpleName());
        long length = ((Number)m.get("length")).longValue();
        long fileCount = ((Number)m.get("fileCount")).longValue();
        long directoryCount = ((Number)m.get("directoryCount")).longValue();
        String ecPolicy = (String)m.get("ecPolicy");
        ContentSummary.Builder builder = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).erasureCodingPolicy(ecPolicy);
        builder = JsonUtilClient.buildQuotaUsage(builder, m, ContentSummary.Builder.class);
        if (m.get("snapshotLength") != null) {
            long snapshotLength = ((Number)m.get("snapshotLength")).longValue();
            builder.snapshotLength(snapshotLength);
        }
        if (m.get("snapshotFileCount") != null) {
            long snapshotFileCount = ((Number)m.get("snapshotFileCount")).longValue();
            builder.snapshotFileCount(snapshotFileCount);
        }
        if (m.get("snapshotDirectoryCount") != null) {
            long snapshotDirectoryCount = ((Number)m.get("snapshotDirectoryCount")).longValue();
            builder.snapshotDirectoryCount(snapshotDirectoryCount);
        }
        if (m.get("snapshotSpaceConsumed") != null) {
            long snapshotSpaceConsumed = ((Number)m.get("snapshotSpaceConsumed")).longValue();
            builder.snapshotSpaceConsumed(snapshotSpaceConsumed);
        }
        return builder.build();
    }

    static QuotaUsage toQuotaUsage(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(QuotaUsage.class.getSimpleName());
        QuotaUsage.Builder builder = new QuotaUsage.Builder();
        builder = JsonUtilClient.buildQuotaUsage(builder, m, QuotaUsage.Builder.class);
        return builder.build();
    }

    private static <T extends QuotaUsage.Builder> T buildQuotaUsage(T builder, Map<?, ?> m, Class<T> type) {
        long quota = ((Number)m.get("quota")).longValue();
        long spaceConsumed = ((Number)m.get("spaceConsumed")).longValue();
        long spaceQuota = ((Number)m.get("spaceQuota")).longValue();
        Map typem = (Map)m.get("typeQuota");
        QuotaUsage.Builder result = (QuotaUsage.Builder)type.cast(builder.quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota));
        if (m.get("fileAndDirectoryCount") != null) {
            long fileAndDirectoryCount = ((Number)m.get("fileAndDirectoryCount")).longValue();
            result = (QuotaUsage.Builder)type.cast(result.fileAndDirectoryCount(fileAndDirectoryCount));
        }
        if (typem != null) {
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                Map typeQuota = (Map)typem.get(t.toString());
                if (typeQuota == null) continue;
                result = (QuotaUsage.Builder)type.cast(result.typeQuota(t, ((Number)typeQuota.get("quota")).longValue()).typeConsumed(t, ((Number)typeQuota.get("consumed")).longValue()));
            }
        }
        return (T)result;
    }

    static MD5MD5CRC32FileChecksum toMD5MD5CRC32FileChecksum(Map<?, ?> json) throws IOException {
        MD5MD5CRC32GzipFileChecksum checksum;
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(FileChecksum.class.getSimpleName());
        String algorithm = (String)m.get("algorithm");
        int length = ((Number)m.get("length")).intValue();
        byte[] bytes = StringUtils.hexStringToByte((String)((String)m.get("bytes")));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        DataChecksum.Type crcType = MD5MD5CRC32FileChecksum.getCrcTypeFromAlgorithmName((String)algorithm);
        switch (crcType) {
            case CRC32: {
                checksum = new MD5MD5CRC32GzipFileChecksum();
                break;
            }
            case CRC32C: {
                checksum = new MD5MD5CRC32CastagnoliFileChecksum();
                break;
            }
            default: {
                throw new IOException("Unknown algorithm: " + algorithm);
            }
        }
        checksum.readFields((DataInput)in);
        if (!checksum.getAlgorithmName().equals(algorithm)) {
            throw new IOException("Algorithm not matched. Expected " + algorithm + ", Received " + checksum.getAlgorithmName());
        }
        if (length != checksum.getLength()) {
            throw new IOException("Length not matched: length=" + length + ", checksum.getLength()=" + checksum.getLength());
        }
        return checksum;
    }

    static AclStatus toAclStatus(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(AclStatus.class.getSimpleName());
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner((String)m.get("owner"));
        aclStatusBuilder.group((String)m.get("group"));
        aclStatusBuilder.stickyBit(((Boolean)m.get("stickyBit")).booleanValue());
        String permString = (String)m.get("permission");
        if (permString != null) {
            FsPermission permission = JsonUtilClient.toFsPermission(permString);
            aclStatusBuilder.setPermission(permission);
        }
        List entries = (List)m.get("entries");
        ArrayList<AclEntry> aclEntryList = new ArrayList<AclEntry>();
        for (Object entry : entries) {
            AclEntry aclEntry = AclEntry.parseAclEntry((String)((String)entry), (boolean)true);
            aclEntryList.add(aclEntry);
        }
        aclStatusBuilder.addEntries(aclEntryList);
        return aclStatusBuilder.build();
    }

    static String getPath(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        return (String)json.get("Path");
    }

    static byte[] getXAttr(Map<?, ?> json, String name) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtilClient.toXAttrs(json);
        if (xAttrs != null) {
            return xAttrs.get(name);
        }
        return null;
    }

    static byte[] getXAttr(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtilClient.toXAttrs(json);
        if (xAttrs != null && !xAttrs.values().isEmpty()) {
            return xAttrs.values().iterator().next();
        }
        return null;
    }

    static Map<String, byte[]> toXAttrs(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        return JsonUtilClient.toXAttrMap(JsonUtilClient.getList(json, "XAttrs"));
    }

    static List<String> toXAttrNames(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        String namesInJson = (String)json.get("XAttrNames");
        ObjectReader reader = new ObjectMapper().readerFor(List.class);
        List xattrs = (List)reader.readValue(namesInJson);
        ArrayList names = Lists.newArrayListWithCapacity((int)json.keySet().size());
        for (Object xattr : xattrs) {
            names.add((String)xattr);
        }
        return names;
    }

    static Map<String, byte[]> toXAttrMap(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap xAttrs = Maps.newHashMap();
        for (Object object : objects) {
            Map m = (Map)object;
            String name = (String)m.get("name");
            String value = (String)m.get("value");
            xAttrs.put(name, JsonUtilClient.decodeXAttrValue(value));
        }
        return xAttrs;
    }

    static byte[] decodeXAttrValue(String value) throws IOException {
        if (value != null) {
            return XAttrCodec.decodeValue((String)value);
        }
        return new byte[0];
    }

    static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> json) throws IOException {
        Map m = (Map)json.get(Token.class.getSimpleName());
        return JsonUtilClient.toToken(m);
    }

    static LocatedBlocks toLocatedBlocks(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(LocatedBlocks.class.getSimpleName());
        long fileLength = ((Number)m.get("fileLength")).longValue();
        boolean isUnderConstruction = (Boolean)m.get("isUnderConstruction");
        List<LocatedBlock> locatedBlocks = JsonUtilClient.toLocatedBlockList(JsonUtilClient.getList(m, "locatedBlocks"));
        LocatedBlock lastLocatedBlock = JsonUtilClient.toLocatedBlock((Map)m.get("lastLocatedBlock"));
        boolean isLastBlockComplete = (Boolean)m.get("isLastBlockComplete");
        return new LocatedBlocks(fileLength, isUnderConstruction, locatedBlocks, lastLocatedBlock, isLastBlockComplete, null, null);
    }

    public static Collection<BlockStoragePolicy> getStoragePolicies(Map<?, ?> json) {
        List objs;
        Map policiesJson = (Map)json.get("BlockStoragePolicies");
        if (policiesJson != null && (objs = (List)policiesJson.get(BlockStoragePolicy.class.getSimpleName())) != null) {
            BlockStoragePolicy[] storagePolicies = new BlockStoragePolicy[objs.size()];
            for (int i = 0; i < objs.size(); ++i) {
                BlockStoragePolicy blockStoragePolicy;
                Map m = (Map)objs.get(i);
                storagePolicies[i] = blockStoragePolicy = JsonUtilClient.toBlockStoragePolicy(m);
            }
            return Arrays.asList(storagePolicies);
        }
        return new ArrayList<BlockStoragePolicy>(0);
    }

    public static BlockStoragePolicy toBlockStoragePolicy(Map<?, ?> m) {
        byte id = ((Number)m.get("id")).byteValue();
        String name = (String)m.get("name");
        StorageType[] storageTypes = JsonUtilClient.toStorageTypes((List)m.get("storageTypes"));
        StorageType[] creationFallbacks = JsonUtilClient.toStorageTypes((List)m.get("creationFallbacks"));
        StorageType[] replicationFallbacks = JsonUtilClient.toStorageTypes((List)m.get("replicationFallbacks"));
        Boolean copyOnCreateFile = (Boolean)m.get("copyOnCreateFile");
        return new BlockStoragePolicy(id, name, storageTypes, creationFallbacks, replicationFallbacks, copyOnCreateFile);
    }

    public static ErasureCodingPolicy toECPolicy(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        byte id = ((Number)m.get("id")).byteValue();
        String name = (String)m.get("name");
        String codec = (String)m.get("codecName");
        int cellsize = ((Number)m.get("cellSize")).intValue();
        int dataunits = ((Number)m.get("numDataUnits")).intValue();
        int parityunits = ((Number)m.get("numParityUnits")).intValue();
        ECSchema ecs = new ECSchema(codec, dataunits, parityunits);
        return new ErasureCodingPolicy(name, ecs, cellsize, id);
    }

    private static StorageType[] toStorageTypes(List<?> list) {
        if (list == null) {
            return null;
        }
        StorageType[] storageTypes = new StorageType[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            storageTypes[i] = StorageType.parseStorageType((String)((String)list.get(i)));
        }
        return storageTypes;
    }

    public static FsServerDefaults toFsServerDefaults(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(FsServerDefaults.class.getSimpleName());
        long blockSize = JsonUtilClient.getLong(m, "blockSize", -1L);
        int bytesPerChecksum = JsonUtilClient.getInt(m, "bytesPerChecksum", -1);
        int writePacketSize = JsonUtilClient.getInt(m, "writePacketSize", -1);
        short replication = (short)JsonUtilClient.getInt(m, "replication", -1);
        int fileBufferSize = JsonUtilClient.getInt(m, "fileBufferSize", -1);
        boolean encryptDataTransfer = m.containsKey("encryptDataTransfer") ? (Boolean)m.get("encryptDataTransfer") : false;
        long trashInterval = JsonUtilClient.getLong(m, "trashInterval", 0L);
        DataChecksum.Type type = DataChecksum.Type.valueOf((int)JsonUtilClient.getInt(m, "checksumType", 1));
        String keyProviderUri = (String)m.get("keyProviderUri");
        byte storagepolicyId = m.containsKey("defaultStoragePolicyId") ? ((Number)m.get("defaultStoragePolicyId")).byteValue() : (byte)0;
        return new FsServerDefaults(blockSize, bytesPerChecksum, writePacketSize, replication, fileBufferSize, encryptDataTransfer, trashInterval, type, keyProviderUri, storagepolicyId);
    }

    public static SnapshotDiffReport toSnapshotDiffReport(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(SnapshotDiffReport.class.getSimpleName());
        String snapshotRoot = (String)m.get("snapshotRoot");
        String fromSnapshot = (String)m.get("fromSnapshot");
        String toSnapshot = (String)m.get("toSnapshot");
        List<SnapshotDiffReport.DiffReportEntry> diffList = JsonUtilClient.toDiffList(JsonUtilClient.getList(m, "diffList"));
        return new SnapshotDiffReport(snapshotRoot, fromSnapshot, toSnapshot, diffList);
    }

    private static List<SnapshotDiffReport.DiffReportEntry> toDiffList(List<?> objs) {
        if (objs == null) {
            return null;
        }
        ChunkedArrayList diffList = new ChunkedArrayList();
        for (int i = 0; i < objs.size(); ++i) {
            diffList.add(JsonUtilClient.toDiffReportEntry((Map)objs.get(i)));
        }
        return diffList;
    }

    private static SnapshotDiffReport.DiffReportEntry toDiffReportEntry(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        SnapshotDiffReport.DiffType type = SnapshotDiffReport.DiffType.parseDiffType((String)json.get("type"));
        byte[] sourcePath = JsonUtilClient.toByteArray((String)json.get("sourcePath"));
        byte[] targetPath = JsonUtilClient.toByteArray((String)json.get("targetPath"));
        return new SnapshotDiffReport.DiffReportEntry(type, sourcePath, targetPath);
    }

    private static byte[] toByteArray(String str) {
        if (str == null) {
            return null;
        }
        return DFSUtilClient.string2Bytes(str);
    }

    public static SnapshottableDirectoryStatus[] toSnapshottableDirectoryList(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        List list = (List)json.get("SnapshottableDirectoryList");
        if (list == null) {
            return null;
        }
        SnapshottableDirectoryStatus[] statuses = new SnapshottableDirectoryStatus[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            statuses[i] = JsonUtilClient.toSnapshottableDirectoryStatus((Map)list.get(i));
        }
        return statuses;
    }

    private static SnapshottableDirectoryStatus toSnapshottableDirectoryStatus(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        int snapshotNumber = JsonUtilClient.getInt(json, "snapshotNumber", 0);
        int snapshotQuota = JsonUtilClient.getInt(json, "snapshotQuota", 0);
        byte[] parentFullPath = JsonUtilClient.toByteArray((String)json.get("parentFullPath"));
        HdfsFileStatus dirStatus = JsonUtilClient.toFileStatus((Map)json.get("dirStatus"), false);
        SnapshottableDirectoryStatus snapshottableDirectoryStatus = new SnapshottableDirectoryStatus(dirStatus, snapshotNumber, snapshotQuota, parentFullPath);
        return snapshottableDirectoryStatus;
    }
}

