/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJavaScriptErrorListener
implements JavaScriptErrorListener,
Serializable {
    private static final Log LOG = LogFactory.getLog(DefaultJavaScriptErrorListener.class);

    @Override
    public void scriptException(HtmlPage page, ScriptException scriptException) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)"Error during JavaScript execution", (Throwable)scriptException);
        }
    }

    @Override
    public void timeoutError(HtmlPage page, long allowedTime, long executionTime) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Timeout during JavaScript execution after " + executionTime + "ms; allowed only " + allowedTime + "ms"));
        }
    }

    @Override
    public void malformedScriptURL(HtmlPage page, String url, MalformedURLException malformedURLException) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Unable to build URL for script src tag [" + url + "]"), (Throwable)malformedURLException);
        }
    }

    @Override
    public void loadScriptError(HtmlPage page, URL scriptUrl, Exception exception) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Error loading JavaScript from [" + scriptUrl + "]."), (Throwable)exception);
        }
    }

    @Override
    public void warn(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (LOG.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder().append("warning: message=[").append(message).append("] sourceName=[").append(sourceName).append("] line=[").append(line).append("] lineSource=[").append(lineSource).append("] lineOffset=[").append(lineOffset).append(']');
            LOG.warn((Object)msg.toString());
        }
    }
}

