/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.lang.invoke.MethodHandles;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.FetchSchedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFetchSchedule
extends Configured
implements FetchSchedule {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int defaultInterval;
    protected int maxInterval;

    public AbstractFetchSchedule() {
        super(null);
    }

    public AbstractFetchSchedule(Configuration conf) {
        super(conf);
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.defaultInterval = conf.getInt("db.fetch.interval.default", 0);
        this.maxInterval = conf.getInt("db.fetch.interval.max", 0);
        LOG.info("defaultInterval={}", (Object)this.defaultInterval);
        LOG.info("maxInterval={}", (Object)this.maxInterval);
    }

    @Override
    public CrawlDatum initializeSchedule(Text url, CrawlDatum datum) {
        datum.setFetchTime(System.currentTimeMillis());
        datum.setFetchInterval(this.defaultInterval);
        datum.setRetriesSinceFetch(0);
        return datum;
    }

    @Override
    public CrawlDatum setFetchSchedule(Text url, CrawlDatum datum, long prevFetchTime, long prevModifiedTime, long fetchTime, long modifiedTime, int state) {
        datum.setRetriesSinceFetch(0);
        return datum;
    }

    @Override
    public CrawlDatum setPageGoneSchedule(Text url, CrawlDatum datum, long prevFetchTime, long prevModifiedTime, long fetchTime) {
        if ((float)datum.getFetchInterval() * 1.5f < (float)this.maxInterval) {
            datum.setFetchInterval((float)datum.getFetchInterval() * 1.5f);
        } else {
            datum.setFetchInterval((float)this.maxInterval * 0.9f);
        }
        datum.setFetchTime(fetchTime + (long)datum.getFetchInterval() * 1000L);
        return datum;
    }

    @Override
    public CrawlDatum setPageRetrySchedule(Text url, CrawlDatum datum, long prevFetchTime, long prevModifiedTime, long fetchTime) {
        datum.setFetchTime(fetchTime + 86400000L);
        datum.setRetriesSinceFetch(datum.getRetriesSinceFetch() + 1);
        return datum;
    }

    @Override
    public long calculateLastFetchTime(CrawlDatum datum) {
        if (datum.getStatus() == 1) {
            return 0L;
        }
        return datum.getFetchTime() - (long)datum.getFetchInterval() * 1000L;
    }

    @Override
    public boolean shouldFetch(Text url, CrawlDatum datum, long curTime) {
        if (datum.getFetchTime() - curTime > (long)this.maxInterval * 1000L) {
            if (datum.getFetchInterval() > this.maxInterval) {
                datum.setFetchInterval((float)this.maxInterval * 0.9f);
            }
            datum.setFetchTime(curTime);
        }
        return datum.getFetchTime() <= curTime;
    }

    @Override
    public CrawlDatum forceRefetch(Text url, CrawlDatum datum, boolean asap) {
        if (datum.getFetchInterval() > this.maxInterval) {
            datum.setFetchInterval((float)this.maxInterval * 0.9f);
        }
        datum.setStatus(1);
        datum.setRetriesSinceFetch(0);
        datum.setSignature(null);
        datum.setModifiedTime(0L);
        if (asap) {
            datum.setFetchTime(System.currentTimeMillis());
        }
        return datum;
    }
}

