/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.OutputStream;
import java.nio.charset.Charset;

public class CircularOutputStream
extends OutputStream {
    private static final int DEFAULT_SIZE = 4096;
    private int end;
    private boolean filled = false;
    private final byte[] buffer;

    public CircularOutputStream(int maxSize) {
        this.buffer = new byte[maxSize];
    }

    public CircularOutputStream() {
        this(4096);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        int bufferSize = this.buffer.length;
        while (len > 0) {
            int chunk = Math.min(bufferSize, len);
            if (bufferSize >= this.end + chunk) {
                System.arraycopy(b, off, this.buffer, this.end, chunk);
                this.end += chunk;
            } else {
                int space = bufferSize - this.end;
                System.arraycopy(b, off, this.buffer, this.end, space);
                this.filled = true;
                this.end = chunk - space;
                System.arraycopy(b, off + space, this.buffer, 0, this.end);
            }
            off += chunk;
            len -= chunk;
        }
    }

    @Override
    public synchronized void write(int b) {
        if (this.end == this.buffer.length) {
            this.filled = true;
            this.end = 0;
        }
        this.buffer[this.end++] = (byte)b;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public synchronized String toString() {
        int size = this.filled ? this.buffer.length : this.end;
        byte[] toReturn = new byte[size];
        if (!this.filled) {
            System.arraycopy(this.buffer, 0, toReturn, 0, this.end);
            return new String(toReturn, Charset.defaultCharset());
        }
        int n = this.buffer.length - this.end;
        System.arraycopy(this.buffer, this.end, toReturn, 0, n);
        System.arraycopy(this.buffer, 0, toReturn, n, this.end);
        return new String(toReturn, Charset.defaultCharset());
    }
}

