/*
 * Decompiled with CFR 0.152.
 */
package com.martinkl.warc.mapred;

import com.martinkl.warc.WARCFileWriter;
import com.martinkl.warc.WARCWritable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class WARCOutputFormat
extends FileOutputFormat<NullWritable, WARCWritable> {
    public RecordWriter<NullWritable, WARCWritable> getRecordWriter(FileSystem fs, JobConf job, String filename, Progressable progress) throws IOException {
        return new WARCWriter(job, filename, progress);
    }

    private static class WARCWriter
    implements RecordWriter<NullWritable, WARCWritable> {
        private final WARCFileWriter writer;

        public WARCWriter(JobConf job, String filename, Progressable progress) throws IOException {
            CompressionCodec codec = FileOutputFormat.getCompressOutput((JobConf)job) ? WARCFileWriter.getGzipCodec((Configuration)job) : null;
            Path workFile = FileOutputFormat.getTaskOutputPath((JobConf)job, (String)filename);
            this.writer = new WARCFileWriter((Configuration)job, codec, workFile, progress);
        }

        public void write(NullWritable key, WARCWritable value) throws IOException {
            this.writer.write(value);
        }

        public void close(Reporter reporter) throws IOException {
            this.writer.close();
        }
    }
}

