/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;

public abstract class InternalMappedTerms<A extends InternalTerms<A, B>, B extends InternalTerms.Bucket<B>>
extends InternalTerms<A, B> {
    protected final DocValueFormat format;
    protected final int shardSize;
    protected final boolean showTermDocCountError;
    protected final long otherDocCount;
    protected final List<B> buckets;
    protected Map<String, B> bucketMap;
    protected long docCountError;

    protected InternalMappedTerms(String name, BucketOrder reduceOrder, BucketOrder order, int requiredSize, long minDocCount, Map<String, Object> metadata, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<B> buckets, long docCountError) {
        super(name, reduceOrder, order, requiredSize, minDocCount, metadata);
        this.format = format;
        this.shardSize = shardSize;
        this.showTermDocCountError = showTermDocCountError;
        this.otherDocCount = otherDocCount;
        this.docCountError = docCountError;
        this.buckets = buckets;
    }

    protected InternalMappedTerms(StreamInput in, InternalTerms.Bucket.Reader<B> bucketReader) throws IOException {
        super(in);
        this.docCountError = in.readZLong();
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.shardSize = InternalMappedTerms.readSize(in);
        this.showTermDocCountError = in.readBoolean();
        this.otherDocCount = in.readVLong();
        this.buckets = in.readList(stream -> bucketReader.read(stream, this.format, this.showTermDocCountError));
    }

    @Override
    protected final void writeTermTypeInfoTo(StreamOutput out) throws IOException {
        out.writeZLong(this.docCountError);
        out.writeNamedWriteable(this.format);
        InternalMappedTerms.writeSize(this.shardSize, out);
        out.writeBoolean(this.showTermDocCountError);
        out.writeVLong(this.otherDocCount);
        out.writeList(this.buckets);
    }

    @Override
    protected void setDocCountError(long docCountError) {
        this.docCountError = docCountError;
    }

    @Override
    protected int getShardSize() {
        return this.shardSize;
    }

    @Override
    public long getDocCountError() {
        return this.docCountError;
    }

    @Override
    public long getSumOfOtherDocCounts() {
        return this.otherDocCount;
    }

    @Override
    public List<B> getBuckets() {
        return this.buckets;
    }

    @Override
    public B getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = this.buckets.stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, Function.identity()));
        }
        return (B)((InternalTerms.Bucket)this.bucketMap.get(term));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMappedTerms that = (InternalMappedTerms)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.otherDocCount, that.otherDocCount) && Objects.equals(this.showTermDocCountError, that.showTermDocCountError) && Objects.equals(this.shardSize, that.shardSize) && Objects.equals(this.docCountError, that.docCountError);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.otherDocCount, this.showTermDocCountError, this.shardSize);
    }

    @Override
    public final XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return InternalMappedTerms.doXContentCommon(builder, params, this.docCountError, this.otherDocCount, this.buckets);
    }
}

