/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterParser;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.util.CharacterFilterUtils;

public class PropertyConfigurationMapper {
    private final ParameterParser elAgnosticParameterParser = new ExpressionLanguageAgnosticParameterParser();
    private final ParameterParser elAwareParameterParser = new ExpressionLanguageAwareParameterParser();

    public Map<String, PropertyConfiguration> mapRawPropertyValuesToPropertyConfiguration(ComponentNode componentNode, Map<String, String> rawPropertyValues) {
        LinkedHashMap<String, PropertyConfiguration> configurationMap = new LinkedHashMap<String, PropertyConfiguration>();
        for (Map.Entry<String, String> entry : rawPropertyValues.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            PropertyDescriptor propertyDescriptor = componentNode.getPropertyDescriptor(propertyName);
            PropertyConfiguration configuration = this.mapRawPropertyValuesToPropertyConfiguration(propertyDescriptor, propertyValue);
            configurationMap.put(propertyName, configuration);
        }
        return configurationMap;
    }

    public PropertyConfiguration mapRawPropertyValuesToPropertyConfiguration(PropertyDescriptor propertyDescriptor, String propertyValue) {
        String updatedValue = CharacterFilterUtils.filterInvalidXmlCharacters(propertyValue);
        ParameterTokenList updatedValueReferences = this.elAgnosticParameterParser.parseTokens(updatedValue);
        List parameterReferences = updatedValueReferences.toReferenceList();
        boolean supportsEL = propertyDescriptor.isExpressionLanguageSupported();
        if (supportsEL) {
            VariableImpact variableImpact = Query.prepare((String)propertyValue).getVariableImpact();
            return new PropertyConfiguration(updatedValue, this.elAwareParameterParser.parseTokens(updatedValue), parameterReferences, variableImpact);
        }
        return new PropertyConfiguration(updatedValue, updatedValueReferences, parameterReferences, VariableImpact.NEVER_IMPACTED);
    }
}

