/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.queries;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public interface CompilerOptionsQueryImplementation {
    @CheckForNull
    public Result getOptions(@NonNull FileObject var1);

    public static abstract class Result {
        private static final Logger LOG = Logger.getLogger(CompilerOptionsQueryImplementation.class.getName());

        @NonNull
        public abstract List<? extends String> getArguments();

        public abstract void addChangeListener(@NonNull ChangeListener var1);

        public abstract void removeChangeListener(@NonNull ChangeListener var1);

        protected final List<String> parseLine(@NonNull String commandLine) {
            return Result.doParseLine(commandLine, null);
        }

        protected final List<String> parseLine(@NonNull String commandLine, @NullAllowed URI workingDirectory) {
            return Result.doParseLine(commandLine, workingDirectory);
        }

        static List<String> doParseLine(@NonNull String commandLine, @NullAllowed URI workingDirectory) {
            Consumer<String> defaultHandleOption;
            ArrayList result = new ArrayList();
            StringBuilder current = new StringBuilder();
            boolean escape = false;
            boolean doubleQuote = false;
            boolean quote = false;
            Consumer<String> handleOption = defaultHandleOption = result::add;
            block7: for (int i = 0; i < commandLine.length(); ++i) {
                char c = commandLine.charAt(i);
                switch (c) {
                    case '\\': {
                        if (quote) continue block7;
                        escape = !escape;
                        continue block7;
                    }
                    case '\'': {
                        if (!escape && !doubleQuote) {
                            quote = !quote;
                        }
                        escape = false;
                        continue block7;
                    }
                    case '\"': {
                        if (!escape && !quote) {
                            doubleQuote = !doubleQuote;
                        }
                        escape = false;
                        continue block7;
                    }
                    case '\t': 
                    case ' ': {
                        if (!(escape || quote || doubleQuote)) {
                            if (current.length() > 0) {
                                handleOption.accept(current.toString());
                                handleOption = defaultHandleOption;
                                current = new StringBuilder();
                            }
                        } else {
                            current.append(c);
                        }
                        escape = false;
                        continue block7;
                    }
                    case '@': {
                        if (workingDirectory != null && i + 1 < commandLine.length() && commandLine.charAt(i + 1) != '@' && current.length() == 0) {
                            handleOption = path -> {
                                try {
                                    URI resolved = workingDirectory.resolve((String)path);
                                    FileObject file = URLMapper.findFileObject(resolved.toURL());
                                    if (file == null) {
                                        LOG.log(Level.FINE, "URI {0}, resolved to {1}, did not yield an existing file", new Object[]{path, resolved.toString()});
                                        result.add("@" + path);
                                        return;
                                    }
                                    for (String line : file.asLines()) {
                                        result.addAll(Result.doParseLine(line, null));
                                    }
                                }
                                catch (IOException ex) {
                                    LOG.log(Level.FINE, null, ex);
                                }
                            };
                            continue block7;
                        }
                    }
                    default: {
                        current.append(c);
                        escape = false;
                    }
                }
            }
            if (current.length() > 0) {
                handleOption.accept(current.toString());
            }
            return Collections.unmodifiableList(result);
        }
    }
}

