/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.VariableElement;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.jdk.CheckRegex;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class Regexp {
    public static ErrorDescription hint(final HintContext ctx) {
        String val;
        final StringBuilder regexp = new StringBuilder();
        final boolean[] accept = new boolean[]{true};
        Tree leaf = ctx.getVariables().get("$pattern").getLeaf();
        if (leaf.getKind() == Tree.Kind.STRING_LITERAL) {
            TreePath pattern = ctx.getVariables().get("$pattern");
            new ErrorAwareTreePathScanner<Void, Void>(){

                @Override
                public Void visitLiteral(LiteralTree node, Void p) {
                    if (node.getValue() instanceof String) {
                        regexp.append(node.getValue());
                        return null;
                    }
                    accept[0] = false;
                    return null;
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    VariableElement ve;
                    Element el = ctx.getInfo().getTrees().getElement(this.getCurrentPath());
                    if (el != null && el.getKind() == ElementKind.FIELD && (ve = (VariableElement)el).getConstantValue() instanceof String) {
                        regexp.append(ve.getConstantValue());
                        return null;
                    }
                    accept[0] = false;
                    return null;
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    VariableElement ve;
                    Element el = ctx.getInfo().getTrees().getElement(this.getCurrentPath());
                    if (el != null && el.getKind() == ElementKind.FIELD && (ve = (VariableElement)el).getConstantValue() instanceof String) {
                        regexp.append(ve.getConstantValue());
                        return null;
                    }
                    accept[0] = false;
                    return null;
                }

                @Override
                public Void visitBinary(BinaryTree node, Void p) {
                    if (node.getKind() != Tree.Kind.PLUS) {
                        return (Void)super.visitBinary(node, p);
                    }
                    accept[0] = false;
                    return null;
                }

                @Override
                public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                    accept[0] = false;
                    return null;
                }
            }.scan(pattern, (Void)null);
            if (!accept[0] || regexp.length() == 0) {
                return null;
            }
        } else if (leaf.getKind() == Tree.Kind.IDENTIFIER && (val = CheckRegex.identifierSearch(leaf, ctx)) != null) {
            regexp.append(val);
        }
        try {
            Pattern.compile(regexp.toString());
            return null;
        }
        catch (PatternSyntaxException pse) {
            String displayName = NbBundle.getMessage(Regexp.class, "DN_RegExp", new Object[]{pse.getDescription(), pse.getMessage(), pse.getPattern(), pse.getIndex()});
            return ErrorDescriptionFactory.forTree(ctx, leaf, displayName, new Fix[0]);
        }
    }
}

