/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.impl.ActionsList;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.netbeans.spi.editor.mimelookup.MimeLocation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

@MimeLocation(subfolderName="Toolbars/Default", instanceProviderClass=ToolbarActionsProvider.class)
public final class ToolbarActionsProvider
extends ActionsList
implements InstanceProvider<ToolbarActionsProvider> {
    private static final Logger LOG = Logger.getLogger(ToolbarActionsProvider.class.getName());
    static final String TOOLBAR_ACTIONS_FOLDER_NAME = "Toolbars/Default";
    private static final String TEXT_BASE_PATH = "Editors/text/base/";

    public static List getToolbarItems(String mimeType) {
        MimePath mimePath = MimePath.parse(mimeType);
        ActionsList provider = mimeType.equals("text/base") ? (ActionsList)MimeLookup.getLookup(mimePath).lookup(LegacyToolbarActionsProvider.class) : (ActionsList)MimeLookup.getLookup(mimePath).lookup(ToolbarActionsProvider.class);
        return provider == null ? Collections.emptyList() : provider.getAllInstances();
    }

    public ToolbarActionsProvider() {
        super(null, false, false);
    }

    private ToolbarActionsProvider(List<FileObject> keys) {
        super(keys, true, false);
    }

    @Override
    public ToolbarActionsProvider createInstance(List<FileObject> fileObjectList) {
        return new ToolbarActionsProvider(fileObjectList);
    }

    @MimeLocation(subfolderName="Toolbars/Default", instanceProviderClass=LegacyToolbarActionsProvider.class)
    public static final class LegacyToolbarActionsProvider
    extends ActionsList
    implements InstanceProvider<LegacyToolbarActionsProvider> {
        public LegacyToolbarActionsProvider() {
            this(null);
        }

        private LegacyToolbarActionsProvider(List<FileObject> keys) {
            super(keys, false, false);
        }

        @Override
        public LegacyToolbarActionsProvider createInstance(List<FileObject> fileObjectList) {
            ArrayList<FileObject> textBaseFilesList = new ArrayList<FileObject>();
            for (FileObject o : fileObjectList) {
                FileObject fileObject = null;
                if (o instanceof DataObject) {
                    fileObject = ((DataObject)((Object)o)).getPrimaryFile();
                } else {
                    if (!(o instanceof FileObject)) continue;
                    fileObject = o;
                }
                String fullPath = fileObject.getPath();
                int idx = fullPath.lastIndexOf(ToolbarActionsProvider.TOOLBAR_ACTIONS_FOLDER_NAME);
                assert (idx != -1) : "Expecting files with 'Toolbars/Default' in the path: " + fullPath;
                String path = fullPath.substring(0, idx);
                if (!ToolbarActionsProvider.TEXT_BASE_PATH.equals(path)) continue;
                textBaseFilesList.add(fileObject);
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("The 'text/base' mime type is deprecated, please move your file to the root. Offending file: " + fullPath);
            }
            return new LegacyToolbarActionsProvider(textBaseFilesList);
        }
    }
}

