/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class CodeTemplatesStorage
implements StorageDescription<String, CodeTemplateDescription> {
    private static final Logger LOG = Logger.getLogger(CodeTemplatesStorage.class.getName());
    public static final String ID = "CodeTemplates";
    private static final String E_ROOT = "codetemplates";
    private static final String E_CODETEMPLATE = "codetemplate";
    private static final String E_DESCRIPTION = "description";
    private static final String E_CODE = "code";
    private static final String A_ABBREV = "abbreviation";
    private static final String A_DESCRIPTION_ID = "descriptionId";
    private static final String A_CONTEXTS = "contexts";
    private static final String A_UUID = "uuid";
    private static final String A_REMOVE = "remove";
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_PRESERVE = "preserve";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Code Templates settings 1.0//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorCodeTemplates-1_0.dtd";
    private static final String MIME_TYPE = "text/x-nbeditor-codetemplatesettings";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isUsingProfiles() {
        return false;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public String getLegacyFileName() {
        return "abbreviations.xml";
    }

    @Override
    public StorageReader<String, CodeTemplateDescription> createReader(FileObject f, String mimePath) {
        if (MIME_TYPE.equals(f.getMIMEType())) {
            return new Reader(f, mimePath);
        }
        return new LegacyReader(f, mimePath);
    }

    @Override
    public StorageWriter<String, CodeTemplateDescription> createWriter(FileObject f, String mimePath) {
        return new Writer();
    }

    private static final class Reader
    extends TemplatesReader {
        private Map<String, CodeTemplateDescription> codeTemplatesMap = new HashMap<String, CodeTemplateDescription>();
        private Set<String> removedTemplates = new HashSet<String>();
        private String abbreviation = null;
        private String description = null;
        private String code = null;
        private List<String> contexts = null;
        private String uuid = null;
        private StringBuilder text = null;
        private StringBuilder cdataText = null;
        private boolean insideCdata = false;

        public Reader(FileObject f, String mimePath) {
            super(f, mimePath);
        }

        @Override
        public Map<String, CodeTemplateDescription> getAdded() {
            return this.codeTemplatesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedTemplates;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
                if (this.insideCdata) {
                    this.cdataText.append(ch, start, length);
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals(CodeTemplatesStorage.E_ROOT)) {
                if (qName.equals(CodeTemplatesStorage.E_CODETEMPLATE)) {
                    boolean removed = Boolean.valueOf(attributes.getValue(CodeTemplatesStorage.A_REMOVE));
                    this.abbreviation = null;
                    this.description = null;
                    this.contexts = null;
                    this.uuid = null;
                    this.text = null;
                    this.cdataText = null;
                    if (removed) {
                        String abbrev = attributes.getValue(CodeTemplatesStorage.A_ABBREV);
                        this.removedTemplates.add(abbrev);
                    } else {
                        String ctxs;
                        String localizedDescription;
                        this.abbreviation = attributes.getValue(CodeTemplatesStorage.A_ABBREV);
                        this.description = attributes.getValue(CodeTemplatesStorage.A_DESCRIPTION_ID);
                        if (this.description != null && (localizedDescription = StorageSupport.getLocalizingBundleMessage(this.getProcessedFile(), this.description, null)) != null) {
                            this.description = localizedDescription;
                        }
                        if ((ctxs = attributes.getValue(CodeTemplatesStorage.A_CONTEXTS)) != null) {
                            String[] arr = ctxs.split(",");
                            this.contexts = new ArrayList<String>(arr.length);
                            for (String context : arr) {
                                if ((context = context.trim()).length() <= 0) continue;
                                this.contexts.add(context);
                            }
                        } else {
                            this.contexts = null;
                        }
                        this.uuid = attributes.getValue(CodeTemplatesStorage.A_UUID);
                    }
                } else if (qName.equals(CodeTemplatesStorage.E_CODE)) {
                    if (this.abbreviation != null) {
                        this.text = new StringBuilder();
                        this.cdataText = new StringBuilder();
                        this.insideCdata = false;
                    }
                } else if (qName.equals(CodeTemplatesStorage.E_DESCRIPTION) && this.abbreviation != null) {
                    this.text = new StringBuilder();
                    this.cdataText = new StringBuilder();
                    this.insideCdata = false;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!qName.equals(CodeTemplatesStorage.E_ROOT)) {
                if (qName.equals(CodeTemplatesStorage.E_CODETEMPLATE)) {
                    if (this.abbreviation != null) {
                        CodeTemplateDescription template = new CodeTemplateDescription(this.abbreviation, this.description == null ? null : CharacterConversions.lineSeparatorToLineFeed(this.description), this.code == null ? "" : CharacterConversions.lineSeparatorToLineFeed(this.code), this.contexts, this.uuid, this.getMimePath());
                        this.codeTemplatesMap.put(this.abbreviation, template);
                    }
                } else if (qName.equals(CodeTemplatesStorage.E_CODE)) {
                    if (this.text != null) {
                        this.code = this.cdataText.length() > 0 ? this.cdataText.toString() : this.text.toString();
                    }
                } else if (qName.equals(CodeTemplatesStorage.E_DESCRIPTION) && this.text != null) {
                    if (this.cdataText.length() > 0) {
                        this.description = this.cdataText.toString();
                    } else if (this.text.length() > 0) {
                        this.description = this.text.toString();
                    }
                }
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = true;
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = false;
            }
        }
    }

    private static final class LegacyReader
    extends TemplatesReader {
        private static final String EL_ROOT = "abbrevs";
        private static final String EL_CODETEMPLATE = "abbrev";
        private static final String AL_ABBREV = "key";
        private static final String AL_REMOVE = "remove";
        private Map<String, CodeTemplateDescription> codeTemplatesMap = new HashMap<String, CodeTemplateDescription>();
        private Set<String> removedTemplates = new HashSet<String>();
        private String abbreviation = null;
        private StringBuilder text = null;

        public LegacyReader(FileObject f, String mimePath) {
            super(f, mimePath);
        }

        @Override
        public Map<String, CodeTemplateDescription> getAdded() {
            return this.codeTemplatesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedTemplates;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals(EL_ROOT) && qName.equals(EL_CODETEMPLATE)) {
                boolean removed = Boolean.valueOf(attributes.getValue("remove"));
                if (removed) {
                    String abbrev = attributes.getValue(AL_ABBREV);
                    this.removedTemplates.add(abbrev);
                    this.abbreviation = null;
                    this.text = null;
                } else {
                    this.abbreviation = attributes.getValue(AL_ABBREV);
                    this.text = new StringBuilder();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!qName.equals(EL_ROOT) && qName.equals(EL_CODETEMPLATE) && this.abbreviation != null) {
                String parametrizedText = this.text.toString().replaceFirst("([^|]+)[|]([^|]+)", "$1\\${cursor}$2");
                CodeTemplateDescription template = new CodeTemplateDescription(this.abbreviation, null, CharacterConversions.lineSeparatorToLineFeed(parametrizedText), null, null, this.getMimePath());
                this.codeTemplatesMap.put(this.abbreviation, template);
            }
        }
    }

    private static final class Writer
    extends StorageWriter<String, CodeTemplateDescription> {
        @Override
        public Document getDocument() {
            Element element;
            Document doc = XMLUtil.createDocument(CodeTemplatesStorage.E_ROOT, null, CodeTemplatesStorage.PUBLIC_ID, CodeTemplatesStorage.SYSTEM_ID);
            Node root = doc.getElementsByTagName(CodeTemplatesStorage.E_ROOT).item(0);
            for (CodeTemplateDescription codeTemplate : this.getAdded().values()) {
                String description;
                String uuid;
                element = doc.createElement(CodeTemplatesStorage.E_CODETEMPLATE);
                root.appendChild(element);
                element.setAttribute(CodeTemplatesStorage.A_ABBREV, codeTemplate.getAbbreviation());
                List<String> contexts = codeTemplate.getContexts();
                if (contexts != null && !contexts.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < contexts.size(); ++i) {
                        String ctx = contexts.get(i);
                        if (ctx == null || (ctx = ctx.trim()).length() <= 0) continue;
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(ctx);
                    }
                    if (sb.length() > 0) {
                        element.setAttribute(CodeTemplatesStorage.A_CONTEXTS, sb.toString());
                    }
                }
                if ((uuid = codeTemplate.getUniqueId()) != null) {
                    element.setAttribute(CodeTemplatesStorage.A_UUID, uuid);
                }
                element.setAttribute(CodeTemplatesStorage.A_XML_SPACE, CodeTemplatesStorage.V_PRESERVE);
                String code = codeTemplate.getParametrizedText();
                if (code.length() > 0) {
                    Element codeElement = doc.createElement(CodeTemplatesStorage.E_CODE);
                    codeElement.appendChild(doc.createCDATASection(code));
                    element.appendChild(codeElement);
                }
                if ((description = codeTemplate.getDescription()) == null || description.length() <= 0) continue;
                Element descriptionElement = doc.createElement(CodeTemplatesStorage.E_DESCRIPTION);
                descriptionElement.appendChild(doc.createCDATASection(description));
                element.appendChild(descriptionElement);
            }
            for (String abbreviation : this.getRemoved()) {
                element = doc.createElement(CodeTemplatesStorage.E_CODETEMPLATE);
                root.appendChild(element);
                element.setAttribute(CodeTemplatesStorage.A_ABBREV, abbreviation);
                element.setAttribute(CodeTemplatesStorage.A_REMOVE, Boolean.TRUE.toString());
            }
            return doc;
        }
    }

    private static abstract class TemplatesReader
    extends StorageReader<String, CodeTemplateDescription> {
        protected TemplatesReader(FileObject f, String mimePath) {
            super(f, mimePath);
        }

        @Override
        public abstract Map<String, CodeTemplateDescription> getAdded();

        @Override
        public abstract Set<String> getRemoved();
    }
}

