/*
 * Decompiled with CFR 0.152.
 */
package jpt30.tools;

import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import jpt30.tools.DocumentationTool;
import jpt30.tools.JavaCompiler;
import nbjavac.ModuleWrapper;
import nbjavac.ServiceLoaderWrapper;

public class ToolProvider {
    private static final String systemJavaCompilerModule = "jdk.compiler";
    private static final String systemJavaCompilerName = "jpt.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolModule = "jdk.javadoc";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";

    private ToolProvider() {
    }

    public static JavaCompiler getSystemJavaCompiler() {
        return (JavaCompiler)JavaCompiler.class.cast(((Supplier<Object>)() -> {
            try {
                JavaCompiler v;
                try {
                    v = ToolProvider.getSystemTool(JavaCompiler.class, systemJavaCompilerModule, systemJavaCompilerName);
                }
                catch (Error err) {
                    v = null;
                }
                if (v == null) {
                    v = Class.forName(systemJavaCompilerName).newInstance();
                }
                return JavaCompiler.class.cast(v);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }).get());
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return (DocumentationTool)DocumentationTool.class.cast(((Supplier<Object>)() -> {
            try {
                DocumentationTool v;
                try {
                    v = ToolProvider.getSystemTool(DocumentationTool.class, systemDocumentationToolModule, systemDocumentationToolName);
                }
                catch (Error err) {
                    v = null;
                }
                if (v == null) {
                    v = Class.forName(systemDocumentationToolName).newInstance();
                }
                return DocumentationTool.class.cast(v);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }).get());
    }

    @Deprecated
    public static ClassLoader getSystemToolClassLoader() {
        return null;
    }

    private static <T> T getSystemTool(Class<T> clazz, String moduleName, String className) {
        try {
            ServiceLoader<T> sl = ServiceLoaderWrapper.loadTool(clazz);
            for (T tool : sl) {
                if (!Objects.equals(ModuleWrapper.getModule(tool.getClass()).getName(), moduleName)) continue;
                return tool;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new Error(e);
        }
        return null;
    }
}

