/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.SystemEvent;

public class SwitchAjaxExceptionHandlerWrapperImpl
extends ExceptionHandlerWrapper {
    private ExceptionHandler requestExceptionHandler;
    private ExceptionHandler ajaxExceptionHandler;
    private Boolean isAjaxRequest;

    public SwitchAjaxExceptionHandlerWrapperImpl(ExceptionHandler requestExceptionHandler, ExceptionHandler ajaxExceptionHandler) {
        this.requestExceptionHandler = requestExceptionHandler;
        this.ajaxExceptionHandler = ajaxExceptionHandler;
    }

    @Override
    public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
        this.isAjaxRequest(exceptionQueuedEvent);
        super.processEvent(exceptionQueuedEvent);
    }

    protected boolean isAjaxRequest(SystemEvent exceptionQueuedEvent) {
        if (this.isAjaxRequest == null) {
            FacesContext facesContext;
            ExceptionQueuedEvent eqe;
            ExceptionQueuedEventContext eqec;
            if (exceptionQueuedEvent instanceof ExceptionQueuedEvent && (eqec = (eqe = (ExceptionQueuedEvent)exceptionQueuedEvent).getContext()) != null && (facesContext = eqec.getContext()) != null) {
                return this.isAjaxRequest(facesContext);
            }
            return this.isAjaxRequest();
        }
        return this.isAjaxRequest;
    }

    protected boolean isAjaxRequest(FacesContext facesContext) {
        if (this.isAjaxRequest == null) {
            PartialViewContext pvc = (facesContext = facesContext == null ? FacesContext.getCurrentInstance() : facesContext).getPartialViewContext();
            if (pvc == null) {
                return false;
            }
            this.isAjaxRequest = pvc.isAjaxRequest();
        }
        return this.isAjaxRequest;
    }

    protected boolean isAjaxRequest() {
        if (this.isAjaxRequest == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            PartialViewContext pvc = facesContext.getPartialViewContext();
            if (pvc == null) {
                return false;
            }
            this.isAjaxRequest = pvc.isAjaxRequest();
        }
        return this.isAjaxRequest;
    }

    @Override
    public ExceptionHandler getWrapped() {
        if (this.isAjaxRequest()) {
            return this.ajaxExceptionHandler;
        }
        return this.requestExceptionHandler;
    }
}

