/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.sshd.client.proxy.ProxyData;
import org.apache.sshd.client.proxy.ProxyDataFactory;

public class DefaultProxyDataFactory
implements ProxyDataFactory {
    private final ProxySelector selector;

    public DefaultProxyDataFactory() {
        this(ProxySelector.getDefault());
    }

    public DefaultProxyDataFactory(ProxySelector selector) {
        this.selector = selector;
    }

    @Override
    public ProxyData get(InetSocketAddress remoteAddress) {
        if (this.selector == null) {
            return null;
        }
        try {
            List<Proxy> proxies = this.selector.select(new URI("socket://" + remoteAddress.getHostString()));
            ProxyData data = this.getData(proxies);
            if (data == null) {
                proxies = this.selector.select(new URI("https", "//" + remoteAddress.getHostString(), null));
                data = this.getData(proxies);
            }
            return data;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private ProxyData getData(List<Proxy> proxies) {
        if (proxies.isEmpty()) {
            return null;
        }
        Proxy proxy = proxies.get(0);
        SocketAddress address = proxy.address();
        if (!(address instanceof InetSocketAddress)) {
            return null;
        }
        return new ProxyData(proxy);
    }
}

