/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.sshd.common.util.security.PublicKeyFactory;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;

public final class BouncyCastlePublicKeyFactory
implements PublicKeyFactory {
    public static final PublicKeyFactory INSTANCE = new BouncyCastlePublicKeyFactory();

    private BouncyCastlePublicKeyFactory() {
    }

    @Override
    public PublicKey getPublicKey(PrivateKey key) {
        if ("Ed25519".equalsIgnoreCase(key.getAlgorithm())) {
            return BouncyCastlePublicKeyFactory.getPublicEdDSAKey(key);
        }
        return null;
    }

    private static PublicKey getPublicEdDSAKey(PrivateKey key) {
        if (key instanceof EdDSAPrivateKey) {
            EdDSAPrivateKey edDSAKey = (EdDSAPrivateKey)key;
            return edDSAKey.getPublicKey();
        }
        return null;
    }
}

