/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedDataTransferFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STOU
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(STOU.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            InetAddress address;
            ServerDataConnectionFactory connFactory = session.getDataConnection();
            if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                return;
            }
            session.resetState();
            String pathName = request.getArgument();
            FtpFile file = null;
            try {
                FtpFile dir;
                String filePrefix = pathName == null ? "ftp.dat" : ((dir = session.getFileSystemView().getFile(pathName)).isDirectory() ? pathName + "/ftp.dat" : pathName);
                file = session.getFileSystemView().getFile(filePrefix);
                if (file != null) {
                    file = this.getUniqueFile(session, file);
                }
            }
            catch (Exception ex) {
                this.LOG.debug("Exception getting file object", (Throwable)ex);
            }
            if (file == null) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "STOU", null, null));
                return;
            }
            String fileName = file.getAbsolutePath();
            if (!file.isWritable()) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "STOU.permission", fileName, file));
                return;
            }
            session.write(new DefaultFtpReply(150, "FILE: " + fileName));
            boolean failure = false;
            try {
                dataConnection = session.getDataConnection().openConnection();
            }
            catch (Exception e) {
                this.LOG.debug("Exception getting the input data stream", (Throwable)e);
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 425, "STOU", fileName, file));
                session.getDataConnection().closeDataConnection();
                return;
            }
            long transSz = 0L;
            try (OutputStream os = file.createOutputStream(0L);){
                transSz = dataConnection.transferFromClient(session.getFtpletSession(), os);
                os.close();
                this.LOG.info("File uploaded {}", (Object)fileName);
                ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                if (ftpStat != null) {
                    ftpStat.setUpload(session, file, transSz);
                }
            }
            catch (SocketException ex) {
                this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                failure = true;
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 426, "STOU", fileName, file));
            }
            catch (IOException ex) {
                this.LOG.debug("IOException during data transfer", (Throwable)ex);
                failure = true;
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 551, "STOU", fileName, file));
            }
            if (!failure) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 226, "STOU", fileName, file, transSz));
            }
        }
        finally {
            session.getDataConnection().closeDataConnection();
        }
    }

    protected FtpFile getUniqueFile(FtpIoSession session, FtpFile oldFile) throws FtpException {
        FtpFile newFile = oldFile;
        FileSystemView fsView = session.getFileSystemView();
        String fileName = newFile.getAbsolutePath();
        while (newFile.doesExist() && (newFile = fsView.getFile(fileName + '.' + System.currentTimeMillis())) != null) {
        }
        return newFile;
    }
}

