/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoService;

public class IoServiceStatistics {
    private final IoService service;
    private double readBytesThroughput;
    private double writtenBytesThroughput;
    private double readMessagesThroughput;
    private double writtenMessagesThroughput;
    private double largestReadBytesThroughput;
    private double largestWrittenBytesThroughput;
    private double largestReadMessagesThroughput;
    private double largestWrittenMessagesThroughput;
    private long readBytes;
    private long writtenBytes;
    private long readMessages;
    private long writtenMessages;
    private long lastReadTime;
    private long lastWriteTime;
    private long lastReadBytes;
    private long lastWrittenBytes;
    private long lastReadMessages;
    private long lastWrittenMessages;
    private long lastThroughputCalculationTime;
    private int scheduledWriteBytes;
    private int scheduledWriteMessages;
    private final Lock throughputCalculationLock = new ReentrantLock();
    private final Config config = new Config();

    public IoServiceStatistics(IoService service) {
        this.service = service;
    }

    public final int getLargestManagedSessionCount() {
        return ((AbstractIoService)this.service).getListeners().getLargestManagedSessionCount();
    }

    public final long getCumulativeManagedSessionCount() {
        return ((AbstractIoService)this.service).getListeners().getCumulativeManagedSessionCount();
    }

    public final long getLastIoTime() {
        if (!this.config.isStatisticsCalcEnabled) {
            return 0L;
        }
        if (!this.config.isLastReadTimeCalcEnabled || !this.config.isLastWriteTimeCalcEnabled) {
            return 0L;
        }
        this.throughputCalculationLock.lock();
        try {
            long l = Math.max(this.lastReadTime, this.lastWriteTime);
            return l;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final long getLastReadTime() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isLastReadTimeCalcEnabled) {
            return 0L;
        }
        this.throughputCalculationLock.lock();
        try {
            long l = this.lastReadTime;
            return l;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final long getLastWriteTime() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isLastWriteTimeCalcEnabled) {
            return 0L;
        }
        this.throughputCalculationLock.lock();
        try {
            long l = this.lastWriteTime;
            return l;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final long getReadBytes() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isReadBytesCalcEnabled) {
            return 0L;
        }
        this.throughputCalculationLock.lock();
        try {
            long l = this.readBytes;
            return l;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final long getWrittenBytes() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isWrittenBytesCalcEnabled) {
            return 0L;
        }
        this.throughputCalculationLock.lock();
        try {
            long l = this.writtenBytes;
            return l;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final long getReadMessages() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isReadMessagesCalcEnabled) {
            return 0L;
        }
        this.throughputCalculationLock.lock();
        try {
            long l = this.readMessages;
            return l;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final long getWrittenMessages() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isWrittenMessagesCalcEnabled) {
            return 0L;
        }
        this.throughputCalculationLock.lock();
        try {
            long l = this.writtenMessages;
            return l;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getReadBytesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isReadBytesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            this.resetThroughput();
            double d = this.readBytesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getWrittenBytesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isWrittenBytesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            this.resetThroughput();
            double d = this.writtenBytesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getReadMessagesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isReadMessagesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            this.resetThroughput();
            double d = this.readMessagesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getWrittenMessagesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isWrittenMessagesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            this.resetThroughput();
            double d = this.writtenMessagesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getLargestReadBytesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isReadBytesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            double d = this.largestReadBytesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getLargestWrittenBytesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isWrittenBytesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            double d = this.largestWrittenBytesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getLargestReadMessagesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isReadMessagesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            double d = this.largestReadMessagesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final double getLargestWrittenMessagesThroughput() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isWrittenMessagesCalcEnabled) {
            return 0.0;
        }
        this.throughputCalculationLock.lock();
        try {
            double d = this.largestWrittenMessagesThroughput;
            return d;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final int getThroughputCalculationInterval() {
        return this.config.getThroughputCalculationInterval();
    }

    public final long getThroughputCalculationIntervalInMillis() {
        return this.config.getThroughputCalculationIntervalInMillis();
    }

    public final void setThroughputCalculationInterval(int throughputCalculationInterval) {
        this.config.setThroughputCalculationInterval(throughputCalculationInterval);
    }

    protected final void setLastReadTime(long lastReadTime) {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isLastReadTimeCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            this.lastReadTime = lastReadTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    protected final void setLastWriteTime(long lastWriteTime) {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isLastWriteTimeCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            this.lastWriteTime = lastWriteTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    private void resetThroughput() {
        if (this.service.getManagedSessionCount() == 0) {
            this.readBytesThroughput = 0.0;
            this.writtenBytesThroughput = 0.0;
            this.readMessagesThroughput = 0.0;
            this.writtenMessagesThroughput = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThroughput(long currentTime) {
        if (!this.config.isStatisticsCalcEnabled) {
            return;
        }
        long minInterval = this.config.getThroughputCalculationIntervalInMillis();
        if (minInterval == 0L) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            int interval = (int)(currentTime - this.lastThroughputCalculationTime);
            if ((long)interval < minInterval) {
                return;
            }
            this.readBytesThroughput = (double)(this.readBytes - this.lastReadBytes) * 1000.0 / (double)interval;
            this.writtenBytesThroughput = (double)(this.writtenBytes - this.lastWrittenBytes) * 1000.0 / (double)interval;
            this.readMessagesThroughput = (double)(this.readMessages - this.lastReadMessages) * 1000.0 / (double)interval;
            this.writtenMessagesThroughput = (double)(this.writtenMessages - this.lastWrittenMessages) * 1000.0 / (double)interval;
            if (this.readBytesThroughput > this.largestReadBytesThroughput) {
                this.largestReadBytesThroughput = this.readBytesThroughput;
            }
            if (this.writtenBytesThroughput > this.largestWrittenBytesThroughput) {
                this.largestWrittenBytesThroughput = this.writtenBytesThroughput;
            }
            if (this.readMessagesThroughput > this.largestReadMessagesThroughput) {
                this.largestReadMessagesThroughput = this.readMessagesThroughput;
            }
            if (this.writtenMessagesThroughput > this.largestWrittenMessagesThroughput) {
                this.largestWrittenMessagesThroughput = this.writtenMessagesThroughput;
            }
            this.lastReadBytes = this.readBytes;
            this.lastWrittenBytes = this.writtenBytes;
            this.lastReadMessages = this.readMessages;
            this.lastWrittenMessages = this.writtenMessages;
            this.lastThroughputCalculationTime = currentTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increaseReadBytes(long nbBytesRead, long currentTime) {
        if (!this.config.isStatisticsCalcEnabled) {
            return;
        }
        if (!this.config.isReadBytesCalcEnabled && !this.config.isLastReadTimeCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            this.readBytes += nbBytesRead;
            this.lastReadTime = currentTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final void increaseReadMessages(long currentTime) {
        if (!this.config.isStatisticsCalcEnabled) {
            return;
        }
        if (!this.config.isReadMessagesCalcEnabled && !this.config.isLastReadTimeCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            ++this.readMessages;
            this.lastReadTime = currentTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increaseWrittenBytes(int nbBytesWritten, long currentTime) {
        if (!this.config.isStatisticsCalcEnabled) {
            return;
        }
        if (!this.config.isWrittenBytesCalcEnabled && !this.config.isLastWriteTimeCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            this.writtenBytes += (long)nbBytesWritten;
            this.lastWriteTime = currentTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final void increaseWrittenMessages(long currentTime) {
        if (!this.config.isStatisticsCalcEnabled) {
            return;
        }
        if (!this.config.isWrittenMessagesCalcEnabled && !this.config.isLastWriteTimeCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            ++this.writtenMessages;
            this.lastWriteTime = currentTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final int getScheduledWriteBytes() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isScheduledWriteBytesCalcEnabled) {
            return 0;
        }
        this.throughputCalculationLock.lock();
        try {
            int n = this.scheduledWriteBytes;
            return n;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final void increaseScheduledWriteBytes(int increment) {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isScheduledWriteBytesCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            this.scheduledWriteBytes += increment;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final int getScheduledWriteMessages() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isScheduledWriteMessagesCalcEnabled) {
            return 0;
        }
        this.throughputCalculationLock.lock();
        try {
            int n = this.scheduledWriteMessages;
            return n;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final void increaseScheduledWriteMessages() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isScheduledWriteMessagesCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            ++this.scheduledWriteMessages;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final void decreaseScheduledWriteMessages() {
        if (!this.config.isStatisticsCalcEnabled || !this.config.isScheduledWriteMessagesCalcEnabled) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            --this.scheduledWriteMessages;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    protected void setLastThroughputCalculationTime(long lastThroughputCalculationTime) {
        if (!this.config.isStatisticsCalcEnabled) {
            return;
        }
        if (this.config.getThroughputCalculationInterval() == 0) {
            return;
        }
        this.throughputCalculationLock.lock();
        try {
            this.lastThroughputCalculationTime = lastThroughputCalculationTime;
        }
        finally {
            this.throughputCalculationLock.unlock();
        }
    }

    public final Config getConfig() {
        return this.config;
    }

    public static final class Config {
        private volatile boolean isReadBytesCalcEnabled = true;
        private volatile boolean isWrittenBytesCalcEnabled = true;
        private volatile boolean isReadMessagesCalcEnabled = true;
        private volatile boolean isWrittenMessagesCalcEnabled = true;
        private volatile boolean isLastReadTimeCalcEnabled = true;
        private volatile boolean isLastWriteTimeCalcEnabled = true;
        private volatile boolean isScheduledWriteBytesCalcEnabled = true;
        private volatile boolean isScheduledWriteMessagesCalcEnabled = true;
        private final AtomicInteger throughputCalculationInterval = new AtomicInteger(3);
        private volatile boolean isStatisticsCalcEnabled = true;

        public boolean isStatisticsCalcEnabled() {
            return this.isStatisticsCalcEnabled;
        }

        public void setStatisticsCalcEnabled(boolean statisticsCalcEnabled) {
            this.isStatisticsCalcEnabled = statisticsCalcEnabled;
        }

        public boolean isReadBytesCalcEnabled() {
            return this.isReadBytesCalcEnabled;
        }

        public void setReadBytesCalcEnabled(boolean readBytesCalcEnabled) {
            this.isReadBytesCalcEnabled = readBytesCalcEnabled;
        }

        public boolean isWrittenBytesCalcEnabled() {
            return this.isWrittenBytesCalcEnabled;
        }

        public void setWrittenBytesCalcEnabled(boolean writtenBytesCalcEnabled) {
            this.isWrittenBytesCalcEnabled = writtenBytesCalcEnabled;
        }

        public boolean isReadMessagesCalcEnabled() {
            return this.isReadMessagesCalcEnabled;
        }

        public void setReadMessagesCalcEnabled(boolean readMessagesCalcEnabled) {
            this.isReadMessagesCalcEnabled = readMessagesCalcEnabled;
        }

        public boolean isWrittenMessagesCalcEnabled() {
            return this.isWrittenMessagesCalcEnabled;
        }

        public void setWrittenMessagesCalcEnabled(boolean writtenMessagesCalcEnabled) {
            this.isWrittenMessagesCalcEnabled = writtenMessagesCalcEnabled;
        }

        public boolean isLastReadTimeCalcEnabled() {
            return this.isLastReadTimeCalcEnabled;
        }

        public void setLastReadTimeCalcEnabled(boolean lastReadTimeCalcEnabled) {
            this.isLastReadTimeCalcEnabled = lastReadTimeCalcEnabled;
        }

        public boolean isLastWriteTimeCalcEnabled() {
            return this.isLastWriteTimeCalcEnabled;
        }

        public void setLastWriteTimeCalcEnabled(boolean lastWriteTimeCalcEnabled) {
            this.isLastWriteTimeCalcEnabled = lastWriteTimeCalcEnabled;
        }

        public boolean isScheduledWriteBytesCalcEnabled() {
            return this.isScheduledWriteBytesCalcEnabled;
        }

        public void setScheduledWriteBytesCalcEnabled(boolean scheduledWriteBytesCalcEnabled) {
            this.isScheduledWriteBytesCalcEnabled = scheduledWriteBytesCalcEnabled;
        }

        public boolean isScheduledWriteMessagesCalcEnabled() {
            return this.isScheduledWriteMessagesCalcEnabled;
        }

        public void setScheduledWriteMessagesCalcEnabled(boolean scheduledWriteMessagesCalcEnabled) {
            this.isScheduledWriteMessagesCalcEnabled = scheduledWriteMessagesCalcEnabled;
        }

        public int getThroughputCalculationInterval() {
            return this.throughputCalculationInterval.get();
        }

        public long getThroughputCalculationIntervalInMillis() {
            return (long)this.throughputCalculationInterval.get() * 1000L;
        }

        public void setThroughputCalculationInterval(int throughputCalculationInterval) {
            if (throughputCalculationInterval < 0) {
                throw new IllegalArgumentException("throughputCalculationInterval: " + throughputCalculationInterval);
            }
            this.throughputCalculationInterval.set(throughputCalculationInterval);
        }
    }
}

