/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.IHookCallBack;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.internal.ArrayIterator;
import org.testng.internal.Graph;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.MethodInheritance;
import org.testng.internal.RunInfo;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.ITestOrConfiguration;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IFutureResult;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadTimeoutException;
import org.testng.internal.thread.ThreadUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHelper {
    private static boolean m_quiet = true;
    static /* synthetic */ Class class$org$testng$internal$annotations$IExpectedExceptions;
    static /* synthetic */ Class class$org$testng$internal$annotations$ITest;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$org$testng$ITestContext;
    static /* synthetic */ Class array$$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$org$testng$IHookCallBack;
    static /* synthetic */ Class class$org$testng$ITestResult;

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, List<ITestNGMethod> outExcludedMethods) {
        return MethodHelper.collectAndOrderMethods(methods.toArray(new ITestNGMethod[methods.size()]), forTests, runInfo, finder, false, outExcludedMethods);
    }

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods) {
        return MethodHelper.collectAndOrderMethods(methods.toArray(new ITestNGMethod[methods.size()]), forTests, runInfo, finder, unique, outExcludedMethods);
    }

    public static ITestNGMethod[] collectAndOrderMethods(ITestNGMethod[] methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, List<ITestNGMethod> outExcludedMethods) {
        return MethodHelper.collectAndOrderMethods(methods, forTests, runInfo, finder, false, outExcludedMethods);
    }

    public static ITestNGMethod[] collectAndOrderMethods(ITestNGMethod[] methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods) {
        ArrayList<ITestNGMethod> includedMethods = new ArrayList<ITestNGMethod>();
        MethodHelper.collectMethodsByGroup(methods, forTests, includedMethods, outExcludedMethods, runInfo, finder, unique);
        List<ITestNGMethod> vResult = MethodHelper.sortMethods(forTests, includedMethods, finder);
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    public static ITestNGMethod[] collectAndOrderConfigurationMethods(ITestNGMethod[] methods, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods) {
        return MethodHelper.collectAndOrderMethods(methods, false, runInfo, finder, unique, outExcludedMethods);
    }

    public static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod method, ITestNGMethod[] methods, String groupRegexp) {
        boolean foundGroup = false;
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            String[] groups;
            for (String group : groups = tm.getGroups()) {
                if (!Pattern.matches(groupRegexp, group)) continue;
                vResult.add(tm);
                foundGroup = true;
            }
        }
        if (!foundGroup) {
            method.setMissingGroup(groupRegexp);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    public static ITestNGMethod[] findMethodsNamed(String mainMethod, ITestNGMethod[] methods, String[] regexps) {
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        String currentRegexp = null;
        for (String fullyQualifiedRegexp : regexps) {
            boolean foundAtLeastAMethod = false;
            if (null != fullyQualifiedRegexp) {
                String regexp;
                currentRegexp = regexp = MethodHelper.escapeRegexp(fullyQualifiedRegexp);
                boolean usePackage = regexp.indexOf(".") != -1;
                for (ITestNGMethod method : methods) {
                    String methodName;
                    Method thisMethod = method.getMethod();
                    String thisMethodName = thisMethod.getName();
                    String string = methodName = usePackage ? MethodHelper.calculateMethodCanonicalName(thisMethod) : thisMethodName;
                    if (!Pattern.matches(regexp, methodName)) continue;
                    vResult.add(method);
                    foundAtLeastAMethod = true;
                }
            }
            if (foundAtLeastAMethod) continue;
            throw new TestNGException(new StringBuffer().append(mainMethod).append("() is depending on nonexistent method ").append(currentRegexp).toString());
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private static String escapeRegexp(String regex) {
        if (regex.indexOf(36) == -1) {
            return regex;
        }
        String[] fragments = regex.split("\\$");
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < fragments.length - 1; ++i) {
            result.append(fragments[i]).append("\\$");
        }
        result.append(fragments[fragments.length - 1]);
        if (regex.endsWith("$")) {
            result.append("\\$");
        }
        return result.toString();
    }

    public static Class[] findExpectedExceptions(IAnnotationFinder finder, Method method) {
        Class[] result = new Class[]{};
        IExpectedExceptions expectedExceptions = (IExpectedExceptions)finder.findAnnotation(method, class$org$testng$internal$annotations$IExpectedExceptions == null ? (class$org$testng$internal$annotations$IExpectedExceptions = MethodHelper.class$("org.testng.internal.annotations.IExpectedExceptions")) : class$org$testng$internal$annotations$IExpectedExceptions);
        if (expectedExceptions != null) {
            result = expectedExceptions.getValue();
        } else {
            ITest testAnnotation = (ITest)finder.findAnnotation(method, class$org$testng$internal$annotations$ITest == null ? (class$org$testng$internal$annotations$ITest = MethodHelper.class$("org.testng.internal.annotations.ITest")) : class$org$testng$internal$annotations$ITest);
            if (testAnnotation != null) {
                Class[] ee = testAnnotation.getExpectedExceptions();
                if (testAnnotation != null && ee.length > 0) {
                    result = ee;
                }
            }
        }
        return result;
    }

    public static boolean isEnabled(Class objectClass, IAnnotationFinder finder) {
        ITest testClassAnnotation = AnnotationHelper.findTest(finder, objectClass);
        return MethodHelper.isEnabled(testClassAnnotation);
    }

    public static boolean isEnabled(Method m, IAnnotationFinder finder) {
        ITest annotation = AnnotationHelper.findTest(finder, m);
        if (null == annotation) {
            annotation = AnnotationHelper.findTest(finder, m.getDeclaringClass());
        }
        return MethodHelper.isEnabled(annotation);
    }

    public static boolean isEnabled(ITestOrConfiguration test) {
        return null == test || null != test && test.getEnabled();
    }

    public static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod method, List<ITestNGMethod> methods, String groupRegexp) {
        ITestNGMethod[] allMethods = methods.toArray(new ITestNGMethod[methods.size()]);
        return MethodHelper.findMethodsThatBelongToGroup(method, allMethods, groupRegexp);
    }

    public static void findGroupTransitiveClosure(XmlMethodSelector xms, List<ITestNGMethod> includedMethods, List<ITestNGMethod> allMethods, String[] includedGroups, Set<String> outGroups, Set<ITestNGMethod> outMethods) {
        HashMap<ITestNGMethod, ITestNGMethod> runningMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
        for (ITestNGMethod m : includedMethods) {
            runningMethods.put(m, m);
        }
        HashMap<String, String> runningGroups = new HashMap<String, String>();
        for (String thisGroup : includedGroups) {
            runningGroups.put(thisGroup, thisGroup);
        }
        boolean keepGoing = true;
        HashMap<ITestNGMethod, ITestNGMethod> newMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
        while (keepGoing) {
            for (ITestNGMethod m : includedMethods) {
                String[] mdu;
                String[] ig;
                for (String g : ig = m.getGroupsDependedUpon()) {
                    ITestNGMethod[] im;
                    if (runningGroups.containsKey(g)) continue;
                    runningGroups.put(g, g);
                    for (ITestNGMethod thisMethod : im = MethodHelper.findMethodsThatBelongToGroup(m, allMethods, g)) {
                        if (runningMethods.containsKey(thisMethod)) continue;
                        runningMethods.put(thisMethod, thisMethod);
                        newMethods.put(thisMethod, thisMethod);
                    }
                }
                for (String tm : mdu = m.getMethodsDependedUpon()) {
                    ITestNGMethod thisMethod = MethodHelper.findMethodNamed(tm, allMethods);
                    if (thisMethod == null || runningMethods.containsKey(thisMethod)) continue;
                    runningMethods.put(thisMethod, thisMethod);
                    newMethods.put(thisMethod, thisMethod);
                }
            }
            keepGoing = newMethods.size() > 0;
            includedMethods = new ArrayList<ITestNGMethod>();
            includedMethods.addAll(newMethods.keySet());
            newMethods = new HashMap();
        }
        outMethods.addAll(runningMethods.keySet());
        outGroups.addAll(runningGroups.keySet());
    }

    public static Map<String, List<ITestNGMethod>> findGroupsMethods(Collection<ITestClass> classes, boolean before) {
        HashMap<String, List<ITestNGMethod>> result = new HashMap<String, List<ITestNGMethod>>();
        for (ITestClass cls : classes) {
            ITestNGMethod[] methods;
            for (ITestNGMethod method : methods = before ? cls.getBeforeGroupsMethods() : cls.getAfterGroupsMethods()) {
                for (String group : before ? method.getBeforeGroups() : method.getAfterGroups()) {
                    ArrayList<ITestNGMethod> methodList = (ArrayList<ITestNGMethod>)result.get(group);
                    if (methodList == null) {
                        methodList = new ArrayList<ITestNGMethod>();
                        result.put(group, methodList);
                    }
                    if (methodList.contains(method)) continue;
                    methodList.add(method);
                }
            }
        }
        return result;
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> methods) {
        HashMap<ITestNGMethod, ITestNGMethod> uniq = new HashMap<ITestNGMethod, ITestNGMethod>();
        for (List<ITestNGMethod> l : methods) {
            for (ITestNGMethod m : l) {
                uniq.put(m, m);
            }
        }
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        result.addAll(uniq.values());
        return result;
    }

    private static ITestNGMethod findMethodNamed(String tm, List<ITestNGMethod> allMethods) {
        for (ITestNGMethod m : allMethods) {
            String methodName = new StringBuffer().append(m.getMethod().getDeclaringClass().getName()).append(".").append(m.getMethodName()).toString();
            if (!methodName.equals(tm)) continue;
            return m;
        }
        return null;
    }

    private static boolean includeMethod(ITestOrConfiguration annotation, RunInfo runInfo, ITestNGMethod tm, boolean forTests, boolean unique, List<ITestNGMethod> outIncludedMethods) {
        boolean result = false;
        if (MethodHelper.isEnabled(annotation) && runInfo.includeMethod(tm, forTests)) {
            if (unique) {
                if (!MethodHelper.isMethodAlreadyPresent(outIncludedMethods, tm)) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private static void collectMethodsByGroup(ITestNGMethod[] methods, boolean forTests, List<ITestNGMethod> outIncludedMethods, List<ITestNGMethod> outExcludedMethods, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        for (ITestNGMethod tm : methods) {
            IConfiguration annotation;
            boolean in = false;
            Method m = tm.getMethod();
            in = forTests ? MethodHelper.includeMethod(AnnotationHelper.findTest(finder, m), runInfo, tm, forTests, unique, outIncludedMethods) : ((annotation = AnnotationHelper.findConfiguration(finder, m)).getAlwaysRun() ? true : MethodHelper.includeMethod(AnnotationHelper.findTest(finder, m), runInfo, tm, forTests, unique, outIncludedMethods));
            if (in) {
                outIncludedMethods.add(tm);
                continue;
            }
            outExcludedMethods.add(tm);
        }
    }

    private static boolean isMethodAlreadyPresent(List<ITestNGMethod> result, ITestNGMethod tm) {
        for (ITestNGMethod m : result) {
            Class<?> c2;
            Class<?> c1;
            Method jm1 = m.getMethod();
            Method jm2 = tm.getMethod();
            if (!jm1.getName().equals(jm2.getName()) || !(c1 = jm1.getDeclaringClass()).isAssignableFrom(c2 = jm2.getDeclaringClass()) && !c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static Graph topologicalSort(ITestNGMethod[] methods, List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList) {
        Graph<ITestNGMethod> result = new Graph<ITestNGMethod>();
        for (ITestNGMethod m : methods) {
            result.addNode(m);
            HashMap<ITestNGMethod, ITestNGMethod> predecessors = new HashMap<ITestNGMethod, ITestNGMethod>();
            String[] methodsDependedUpon = m.getMethodsDependedUpon();
            String[] groupsDependedUpon = m.getGroupsDependedUpon();
            if (methodsDependedUpon.length > 0) {
                ITestNGMethod[] methodsNamed;
                String methodName = MethodHelper.calculateMethodCanonicalName(m);
                for (ITestNGMethod pred : methodsNamed = MethodHelper.findMethodsNamed(methodName, methods, methodsDependedUpon)) {
                    predecessors.put(pred, pred);
                }
            }
            if (groupsDependedUpon.length > 0) {
                for (String group : groupsDependedUpon) {
                    ITestNGMethod[] methodsThatBelongToGroup;
                    for (ITestNGMethod pred : methodsThatBelongToGroup = MethodHelper.findMethodsThatBelongToGroup(m, methods, group)) {
                        predecessors.put(pred, pred);
                    }
                }
            }
            for (ITestNGMethod predecessor : predecessors.values()) {
                result.addPredecessor(m, predecessor);
            }
        }
        result.topologicalSort();
        sequentialList.addAll(result.getStrictlySortedNodes());
        parallelList.addAll(result.getIndependentNodes());
        return result;
    }

    public static String calculateMethodCanonicalName(ITestNGMethod m) {
        return MethodHelper.calculateMethodCanonicalName(m.getMethod());
    }

    public static String calculateMethodCanonicalName(Method m) {
        String packageName = new StringBuffer().append(m.getDeclaringClass().getName()).append(".").append(m.getName()).toString();
        for (Class<?> cls = m.getDeclaringClass(); cls != (class$java$lang$Object == null ? MethodHelper.class$("java.lang.Object") : class$java$lang$Object); cls = cls.getSuperclass()) {
            try {
                if (cls.getDeclaredMethod(m.getName(), m.getParameterTypes()) == null) continue;
                packageName = cls.getName();
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String result = new StringBuffer().append(packageName).append(".").append(m.getName()).toString();
        return result;
    }

    private static List<ITestNGMethod> sortMethods(boolean forTests, List<ITestNGMethod> allMethods, IAnnotationFinder finder) {
        ArrayList<ITestNGMethod> sl = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> pl = new ArrayList<ITestNGMethod>();
        ITestNGMethod[] allMethodsArray = allMethods.toArray(new ITestNGMethod[allMethods.size()]);
        if (!forTests && allMethodsArray.length > 0) {
            ITestNGMethod m = allMethodsArray[0];
            boolean before = m.isBeforeClassConfiguration() || m.isBeforeMethodConfiguration() || m.isBeforeSuiteConfiguration() || m.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(allMethodsArray, before);
        }
        MethodHelper.topologicalSort(allMethodsArray, sl, pl);
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        result.addAll(sl);
        result.addAll(pl);
        return result;
    }

    public static void ppp(String s) {
        System.out.println(new StringBuffer().append("[MethodHelper] ").append(s).toString());
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod method, ITestNGMethod[] methods) {
        ArrayList<ITestNGMethod> parallelList = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> sequentialList = new ArrayList<ITestNGMethod>();
        Graph g = MethodHelper.topologicalSort(methods, sequentialList, parallelList);
        List<ITestNGMethod> result = g.findPredecessors(method);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeMethod(Method thisMethod, Object instance, Object[] parameters) throws InvocationTargetException, IllegalAccessException {
        Object result = null;
        boolean isPublic = Modifier.isPublic(thisMethod.getModifiers());
        try {
            if (!isPublic) {
                thisMethod.setAccessible(true);
            }
            result = thisMethod.invoke(instance, parameters);
        }
        finally {
            if (!isPublic) {
                thisMethod.setAccessible(false);
            }
        }
        return result;
    }

    public static Iterator<Object[]> createArrayIterator(Object[][] objects) {
        ArrayIterator result = new ArrayIterator(objects);
        return result;
    }

    public static Iterator<Object[]> invokeDataProvider(Object instance, Method dataProvider, ITestNGMethod method, ITestContext testContext) {
        Iterator<Object[]> result;
        block8: {
            result = null;
            Method testMethod = method.getMethod();
            try {
                Class<?> returnType;
                ArrayList<Object> lParameters = new ArrayList<Object>();
                Class<?>[] parameterTypes = dataProvider.getParameterTypes();
                if (parameterTypes.length > 2) {
                    throw new TestNGException(new StringBuffer().append("DataProvider ").append(dataProvider).append(" cannot have more than two parameters").toString());
                }
                for (Class<?> cls : parameterTypes) {
                    if (cls.equals(class$java$lang$reflect$Method == null ? MethodHelper.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method)) {
                        lParameters.add(testMethod);
                        continue;
                    }
                    if (!cls.equals(class$org$testng$ITestContext == null ? MethodHelper.class$("org.testng.ITestContext") : class$org$testng$ITestContext)) continue;
                    lParameters.add(testContext);
                }
                Object[] parameters = lParameters.toArray(new Object[lParameters.size()]);
                if ((array$$Ljava$lang$Object == null ? (array$$Ljava$lang$Object = MethodHelper.class$("[[Ljava.lang.Object;")) : array$$Ljava$lang$Object).isAssignableFrom(returnType = dataProvider.getReturnType())) {
                    Object[][] oResult = (Object[][])MethodHelper.invokeMethod(dataProvider, instance, parameters);
                    method.setParameterInvocationCount(oResult.length);
                    result = MethodHelper.createArrayIterator(oResult);
                    break block8;
                }
                if ((class$java$util$Iterator == null ? (class$java$util$Iterator = MethodHelper.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(returnType)) {
                    result = (Iterator<Object[]>)MethodHelper.invokeMethod(dataProvider, instance, parameters);
                    break block8;
                }
                throw new TestNGException(new StringBuffer().append("Data Provider ").append(dataProvider).append(" must return").append(" either Object[][] or Iterator<Object>[], not ").append(returnType).toString());
            }
            catch (InvocationTargetException e) {
                throw new TestNGException(e);
            }
            catch (IllegalAccessException e) {
                throw new TestNGException(e);
            }
        }
        return result;
    }

    public static String calculateMethodCanonicalName(Class methodClass, String methodName) {
        Method[] methods = methodClass.getMethods();
        Method result = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            result = m;
            break;
        }
        return result != null ? MethodHelper.calculateMethodCanonicalName(result) : null;
    }

    public static void invokeHookable(final Object instance, final Object[] parameters, ITestClass testClass, final Method thisMethod, TestResult testResult) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Throwable {
        Method runMethod = testClass.getRealClass().getMethod("run", class$org$testng$IHookCallBack == null ? (class$org$testng$IHookCallBack = MethodHelper.class$("org.testng.IHookCallBack")) : class$org$testng$IHookCallBack, class$org$testng$ITestResult == null ? (class$org$testng$ITestResult = MethodHelper.class$("org.testng.ITestResult")) : class$org$testng$ITestResult);
        final Throwable[] error = new Throwable[1];
        IHookCallBack callback = new IHookCallBack(){

            public void runTestMethod(ITestResult tr) {
                try {
                    MethodHelper.invokeMethod(thisMethod, instance, parameters);
                }
                catch (Throwable t) {
                    error[0] = t;
                    tr.setThrowable(t);
                }
            }
        };
        runMethod.invoke(instance, callback, testResult);
        if (error[0] != null) {
            throw error[0];
        }
    }

    public static void invokeWithTimeout(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult) throws InterruptedException, ThreadExecutionException {
        IExecutor exec = ThreadUtil.createExecutor(1, tm.getMethod().getName());
        InvokeMethodRunnable imr = new InvokeMethodRunnable(tm, instance, parameterValues);
        IFutureResult future = exec.submitRunnable(imr);
        exec.shutdown();
        boolean finished = exec.awaitTermination(tm.getTimeOut());
        if (!finished) {
            exec.stopNow();
            testResult.setThrowable(new ThreadTimeoutException(new StringBuffer().append("Method ").append(tm.getMethod()).append(" didn't finish within the time-out ").append(tm.getTimeOut()).toString()));
            testResult.setStatus(2);
        } else {
            Utils.log(new StringBuffer().append("Invoker ").append(Thread.currentThread().hashCode()).toString(), 3, new StringBuffer().append("Method ").append(tm.getMethod()).append(" completed within the time-out ").append(tm.getTimeOut()).toString());
            future.get();
            testResult.setStatus(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

