/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.email;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.email.EmailConfig;
import org.apache.manifoldcf.crawler.connectors.email.EmailSession;
import org.apache.manifoldcf.crawler.connectors.email.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class EmailConnector
extends BaseRepositoryConnector {
    protected static final long SESSION_EXPIRATION_MILLISECONDS = 300000L;
    protected long sessionExpiration = -1L;
    protected String server = null;
    protected String portString = null;
    protected String username = null;
    protected String password = null;
    protected String protocol = null;
    protected Properties properties = null;
    protected String urlTemplate = null;
    protected String attachmentUrlTemplate = null;
    protected EmailSession session = null;
    private static Map<String, String> providerMap = new HashMap<String, String>();

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.server = configParameters.getParameter("server");
        this.portString = configParameters.getParameter("port");
        this.protocol = configParameters.getParameter("protocol");
        this.username = configParameters.getParameter("username");
        this.password = configParameters.getObfuscatedParameter("password");
        this.urlTemplate = configParameters.getParameter("url");
        this.attachmentUrlTemplate = configParameters.getParameter("attachmenturl");
        this.properties = new Properties();
        int i = 0;
        while (i < configParameters.getChildCount()) {
            ConfigNode cn;
            if (!(cn = configParameters.getChild(i++)).getType().equals("properties")) continue;
            String findParameterName = cn.getAttributeValue("name");
            String findParameterValue = cn.getAttributeValue("value");
            this.properties.setProperty(findParameterName, findParameterValue);
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.attachmentUrlTemplate = null;
        this.urlTemplate = null;
        this.server = null;
        this.portString = null;
        this.protocol = null;
        this.username = null;
        this.password = null;
        this.properties = null;
        this.finalizeConnection();
        super.disconnect();
    }

    public void poll() throws ManifoldCFException {
        if (this.session != null && System.currentTimeMillis() >= this.sessionExpiration) {
            this.finalizeConnection();
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        this.finalizeConnection();
        this.getSession();
        try {
            CheckConnectionThread cct = new CheckConnectionThread(this.session);
            cct.start();
            cct.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (MessagingException e) {
            EmailConnector.handleMessagingException(e, "checking the connection");
        }
    }

    public int getConnectorModel() {
        return 1;
    }

    public String[] getActivitiesList() {
        return new String[]{"fetch"};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.server};
    }

    public int getMaxDocumentRequest() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        this.getSession();
        int i = 0;
        HashMap<String, String> findMap = new HashMap<String, String>();
        ArrayList<String> folderNames = new ArrayList<String>();
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if ((sn = spec.getChild(i++)).getType().equals("folder")) {
                folderNames.add(sn.getAttributeValue("name"));
                continue;
            }
            if (!sn.getType().equals("filter")) continue;
            String findParameterName = sn.getAttributeValue("name");
            String findParameterValue = sn.getAttributeValue("value");
            findMap.put(findParameterName, findParameterValue);
        }
        for (String folderName : folderNames) {
            try {
                OpenFolderThread oft = new OpenFolderThread(this.session, folderName);
                oft.start();
                Folder folder = oft.finishUp();
                try {
                    Message[] messages;
                    for (Message message : messages = this.findMessages(folder, startTime, seedTime, findMap)) {
                        String emailID = ((MimeMessage)message).getMessageID();
                        activities.addSeedDocument(EmailConnector.createDocumentIdentifier(folderName, emailID));
                    }
                }
                finally {
                    CloseFolderThread cft = new CloseFolderThread(this.session, folder);
                    cft.start();
                    cft.finishUp();
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
            catch (MessagingException e) {
                EmailConnector.handleMessagingException(e, "finding emails");
            }
        }
        return new Long(seedTime).toString();
    }

    private Message[] findMessages(Folder folder, long startTime, long endTime, Map<String, String> findMap) throws MessagingException, InterruptedException {
        Message[] result;
        SubjectTerm searchTerm = null;
        for (Map.Entry<String, String> pair : findMap.entrySet()) {
            String findParameterName = pair.getKey().toLowerCase(Locale.ROOT);
            String findParameterValue = pair.getValue();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Email: Finding emails where '" + findParameterName + "' = '" + findParameterValue + "'"));
            }
            SubjectTerm searchClause = null;
            Integer comparisonTerm = null;
            if (findParameterName.equals("subject")) {
                searchClause = new SubjectTerm(findParameterValue);
            } else if (findParameterName.equals("from")) {
                searchClause = new FromStringTerm(findParameterValue);
            } else if (findParameterName.equals("to")) {
                searchClause = new RecipientStringTerm(Message.RecipientType.TO, findParameterValue);
            } else if (findParameterName.equals("body")) {
                searchClause = new BodyTerm(findParameterValue);
            } else if (findParameterName.equals("start date")) {
                comparisonTerm = 5;
            } else if (findParameterName.equals("end date")) {
                comparisonTerm = 2;
            }
            if (comparisonTerm != null) {
                SimpleDateFormat date = new SimpleDateFormat("dd/MM/yyyy", Locale.ROOT);
                try {
                    searchClause = new ReceivedDateTerm(comparisonTerm.intValue(), date.parse(findParameterValue));
                }
                catch (ParseException e) {
                    Logging.connectors.warn((Object)("Email: Unknown date format: '" + findParameterValue + "'for filter parameter name: '" + findParameterName + "'"));
                }
            }
            if (searchClause != null) {
                if (searchTerm == null) {
                    searchTerm = searchClause;
                    continue;
                }
                searchTerm = new AndTerm((SearchTerm)searchTerm, (SearchTerm)searchClause);
                continue;
            }
            Logging.connectors.warn((Object)("Email: Unknown filter parameter name: '" + findParameterName + "'"));
        }
        if (searchTerm == null) {
            GetMessagesThread gmt = new GetMessagesThread(this.session, folder);
            gmt.start();
            result = gmt.finishUp();
        } else {
            SearchMessagesThread smt = new SearchMessagesThread(this.session, folder, (SearchTerm)searchTerm);
            smt.start();
            result = smt.finishUp();
        }
        return result;
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            int port;
            if (this.urlTemplate == null) {
                throw new ManifoldCFException("Missing url parameter");
            }
            if (this.server == null) {
                throw new ManifoldCFException("Missing server parameter");
            }
            if (this.properties == null) {
                throw new ManifoldCFException("Missing server properties");
            }
            if (this.protocol == null) {
                throw new ManifoldCFException("Missing protocol parameter");
            }
            if (this.portString != null && this.portString.length() > 0) {
                try {
                    port = Integer.parseInt(this.portString);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Port number has bad format: " + e.getMessage(), (Throwable)e);
                }
            } else {
                port = -1;
            }
            try {
                ConnectThread connectThread = new ConnectThread(this.server, port, this.username, this.password, providerMap.get(this.protocol), this.properties);
                connectThread.start();
                this.session = connectThread.finishUp();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
            catch (MessagingException e) {
                EmailConnector.handleMessagingException(e, "connecting");
            }
        }
        this.sessionExpiration = System.currentTimeMillis() + 300000L;
    }

    protected void finalizeConnection() {
        if (this.session != null) {
            try {
                CloseSessionThread closeSessionThread = new CloseSessionThread(this.session);
                closeSessionThread.start();
                closeSessionThread.finishUp();
            }
            catch (InterruptedException closeSessionThread) {
            }
            catch (MessagingException e) {
                Logging.connectors.warn((Object)("Error while closing connection to server: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        ArrayList<String> requiredMetadata = new ArrayList<String>();
        boolean useEmailExtractor = false;
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (sn.getType().equals("metadata")) {
                String metadataAttribute = sn.getAttributeValue("name");
                requiredMetadata.add(metadataAttribute);
            }
            if (!sn.getType().equals("extractemail")) continue;
            useEmailExtractor = true;
        }
        HashMap<String, Folder> openFolders = new HashMap<String, Folder>();
        try {
            for (String documentIdentifier : documentIdentifiers) {
                Integer attachmentIndex = EmailConnector.extractAttachmentNumberFromDocumentIdentifier(documentIdentifier);
                if (attachmentIndex == null) {
                    String versionString = "_" + this.urlTemplate;
                    if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                    String compositeID = documentIdentifier;
                    String version = versionString;
                    String folderName = EmailConnector.extractFolderNameFromDocumentIdentifier(compositeID);
                    String id = EmailConnector.extractEmailIDFromDocumentIdentifier(compositeID);
                    String errorCode = null;
                    Object errorDesc = null;
                    Long fileLengthLong = null;
                    long startTime = System.currentTimeMillis();
                    try {
                        Folder folder = (Folder)openFolders.get(folderName);
                        if (folder == null) {
                            this.getSession();
                            OpenFolderThread oft = new OpenFolderThread(this.session, folderName);
                            oft.start();
                            folder = oft.finishUp();
                            openFolders.put(folderName, folder);
                        }
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Email: Processing document identifier '" + compositeID + "'"));
                        }
                        MessageIDTerm messageIDTerm = new MessageIDTerm(id);
                        this.getSession();
                        SearchMessagesThread smt = new SearchMessagesThread(this.session, folder, (SearchTerm)messageIDTerm);
                        smt.start();
                        Message[] message = smt.finishUp();
                        String msgURL = EmailConnector.makeDocumentURI(this.urlTemplate, folderName, id);
                        Message msg = null;
                        Message[] messageArray = message;
                        int n = messageArray.length;
                        for (int i = 0; i < n; ++i) {
                            Message msg2;
                            msg = msg2 = messageArray[i];
                        }
                        if (msg == null) {
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        if (!activities.checkURLIndexable(msgURL)) {
                            errorCode = "EXCLUDEDURL";
                            errorDesc = "Excluded because of URL ('" + msgURL + "')";
                            activities.noDocument(documentIdentifier, version);
                            continue;
                        }
                        long fileLength = msg.getSize();
                        if (!activities.checkLengthIndexable(fileLength)) {
                            errorCode = "EXCLUDEDLENGTH";
                            errorDesc = "Excluded because of length (" + fileLength + ")";
                            activities.noDocument(documentIdentifier, version);
                            continue;
                        }
                        Date sentDate = msg.getSentDate();
                        if (!activities.checkDateIndexable(sentDate)) {
                            errorCode = "EXCLUDEDDATE";
                            errorDesc = "Excluded because of date (" + sentDate + ")";
                            activities.noDocument(documentIdentifier, version);
                            continue;
                        }
                        String mimeType = "text/plain";
                        if (!activities.checkMimeTypeIndexable(mimeType)) {
                            errorCode = "EXCLUDEDMIMETYPE";
                            errorDesc = "Excluded because of mime type ('" + mimeType + "')";
                            activities.noDocument(documentIdentifier, version);
                            continue;
                        }
                        try {
                            RepositoryDocument rd = new RepositoryDocument();
                            rd.setFileName(msg.getFileName());
                            rd.setMimeType(mimeType);
                            rd.setCreatedDate(sentDate);
                            rd.setModifiedDate(sentDate);
                            for (String metadata : requiredMetadata) {
                                int n2;
                                Multipart mp;
                                Object o;
                                if (metadata.toLowerCase(Locale.ROOT).equals("to")) {
                                    Address[] to = msg.getRecipients(Message.RecipientType.TO);
                                    if (to == null) continue;
                                    String[] toStr = new String[to.length];
                                    int j = 0;
                                    for (Address address : to) {
                                        toStr[j] = useEmailExtractor ? this.extractEmailAddress(address.toString()) : address.toString();
                                        ++j;
                                    }
                                    rd.addField("to", toStr);
                                    continue;
                                }
                                if (metadata.toLowerCase(Locale.ROOT).equals("from")) {
                                    Address[] from = msg.getFrom();
                                    String[] fromStr = new String[from.length];
                                    int j = 0;
                                    for (Address address : from) {
                                        fromStr[j] = useEmailExtractor ? this.extractEmailAddress(address.toString()) : address.toString();
                                        ++j;
                                    }
                                    rd.addField("from", fromStr);
                                    continue;
                                }
                                if (metadata.toLowerCase(Locale.ROOT).equals("subject")) {
                                    String subject = msg.getSubject();
                                    rd.addField("subject", subject);
                                    continue;
                                }
                                if (metadata.toLowerCase(Locale.ROOT).equals("date")) {
                                    rd.addField("date", sentDate.toString());
                                    continue;
                                }
                                if (metadata.toLowerCase(Locale.ROOT).equals("encoding of attachment")) {
                                    o = msg.getContent();
                                    if (o == null) continue;
                                    if (o instanceof Multipart) {
                                        mp = (Multipart)o;
                                        String[] encoding = new String[mp.getCount()];
                                        n2 = mp.getCount();
                                        for (int k = 0; k < n2; ++k) {
                                            BodyPart part = mp.getBodyPart(k);
                                            if (!this.isAttachment((Part)part)) continue;
                                            String[] fileSplit = part.getFileName().split("\\?");
                                            encoding[k] = fileSplit.length > 1 ? fileSplit[1] : "";
                                        }
                                        rd.addField("encoding", encoding);
                                        continue;
                                    }
                                    if (!(o instanceof String)) continue;
                                    rd.addField("encoding", "");
                                    continue;
                                }
                                if (metadata.toLowerCase(Locale.ROOT).equals("mime type of attachment")) {
                                    o = msg.getContent();
                                    if (o == null) continue;
                                    if (o instanceof Multipart) {
                                        mp = (Multipart)o;
                                        String[] MIMEType = new String[mp.getCount()];
                                        n2 = mp.getCount();
                                        for (int k = 0; k < n2; ++k) {
                                            BodyPart part = mp.getBodyPart(k);
                                            if (!this.isAttachment((Part)part)) continue;
                                            MIMEType[k] = part.getContentType();
                                        }
                                        rd.addField("mimetype", MIMEType);
                                        continue;
                                    }
                                    if (!(o instanceof String)) continue;
                                    rd.addField("mimetype", "");
                                    continue;
                                }
                                if (!metadata.toLowerCase(Locale.ROOT).equals("file name of attachment") || (o = msg.getContent()) == null) continue;
                                if (o instanceof Multipart) {
                                    mp = (Multipart)o;
                                    String[] attachmentNames = new String[mp.getCount()];
                                    n2 = mp.getCount();
                                    for (int k = 0; k < n2; ++k) {
                                        BodyPart part = mp.getBodyPart(k);
                                        if (!this.isAttachment((Part)part)) continue;
                                        attachmentNames[k] = part.getFileName();
                                    }
                                    rd.addField("attachmentname", attachmentNames);
                                    continue;
                                }
                                if (!(o instanceof String)) continue;
                                rd.addField("attachmentname", "");
                            }
                            EmailContent bodyContent = this.extractBodyContent(msg);
                            if (bodyContent != null) {
                                rd.setMimeType(bodyContent.getMimeType());
                                try (ByteArrayInputStream is = new ByteArrayInputStream(bodyContent.getContent().getBytes(StandardCharsets.UTF_8));){
                                    rd.setBinary((InputStream)is, fileLength);
                                    activities.ingestDocumentWithException(documentIdentifier, version, msgURL, rd);
                                    errorCode = "OK";
                                    fileLengthLong = new Long(fileLength);
                                }
                            }
                            if (this.attachmentUrlTemplate == null || msg.getContent() == null || !(msg.getContent() instanceof Multipart)) continue;
                            Multipart mp = (Multipart)msg.getContent();
                            int numAttachments = mp.getCount();
                            for (int i = 0; i < numAttachments; ++i) {
                                if (!this.isAttachment((Part)mp.getBodyPart(i))) continue;
                                activities.addDocumentReference(documentIdentifier + ":" + i);
                            }
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new ManifoldCFException(e.getMessage(), 2);
                        }
                        catch (MessagingException e) {
                            errorCode = ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                            errorDesc = e.getMessage();
                            EmailConnector.handleMessagingException(e, "processing email");
                            continue;
                        }
                        catch (IOException e) {
                            errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                            errorDesc = e.getMessage();
                            EmailConnector.handleIOException(e, "processing email");
                            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 2) {
                            errorCode = null;
                        }
                        throw e;
                    }
                    finally {
                        if (errorCode != null) {
                            activities.recordActivity(new Long(startTime), "fetch", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
                        }
                    }
                }
                int attachmentNumber = attachmentIndex;
                String versionString = "_" + this.attachmentUrlTemplate;
                if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                String compositeID = documentIdentifier;
                String version = versionString;
                String folderName = EmailConnector.extractFolderNameFromDocumentIdentifier(compositeID);
                String id = EmailConnector.extractEmailIDFromDocumentIdentifier(compositeID);
                String errorCode = null;
                Object errorDesc = null;
                Long fileLengthLong = null;
                long startTime = System.currentTimeMillis();
                try {
                    Folder folder = (Folder)openFolders.get(folderName);
                    if (folder == null) {
                        this.getSession();
                        OpenFolderThread oft = new OpenFolderThread(this.session, folderName);
                        oft.start();
                        folder = oft.finishUp();
                        openFolders.put(folderName, folder);
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Email: Processing document identifier '" + documentIdentifier + "'"));
                    }
                    MessageIDTerm messageIDTerm = new MessageIDTerm(id);
                    this.getSession();
                    SearchMessagesThread smt = new SearchMessagesThread(this.session, folder, (SearchTerm)messageIDTerm);
                    smt.start();
                    Message[] message = smt.finishUp();
                    String msgURL = EmailConnector.makeDocumentURI(this.attachmentUrlTemplate, folderName, id, attachmentNumber);
                    Message msg = null;
                    Message[] messageArray = message;
                    int sentDate = messageArray.length;
                    for (int mimeType = 0; mimeType < sentDate; ++mimeType) {
                        Message msg2;
                        msg = msg2 = messageArray[mimeType];
                    }
                    if (msg == null) {
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    if (!activities.checkURLIndexable(msgURL)) {
                        errorCode = "EXCLUDEDURL";
                        errorDesc = "Excluded because of URL ('" + msgURL + "')";
                        activities.noDocument(documentIdentifier, version);
                        continue;
                    }
                    Date sentDate2 = msg.getSentDate();
                    if (!activities.checkDateIndexable(sentDate2)) {
                        errorCode = "EXCLUDEDDATE";
                        errorDesc = "Excluded because of date (" + sentDate2 + ")";
                        activities.noDocument(documentIdentifier, version);
                        continue;
                    }
                    Multipart mp = (Multipart)msg.getContent();
                    if (mp.getCount() <= attachmentNumber) {
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    BodyPart part = mp.getBodyPart(attachmentNumber);
                    long fileLength = part.getSize();
                    if (!activities.checkLengthIndexable(fileLength)) {
                        errorCode = "EXCLUDEDLENGTH";
                        errorDesc = "Excluded because of length (" + fileLength + ")";
                        activities.noDocument(documentIdentifier, version);
                        continue;
                    }
                    String origMimeType = part.getContentType();
                    String mimeType = origMimeType == null || origMimeType.indexOf(";") == -1 ? origMimeType : origMimeType.substring(0, origMimeType.indexOf(";"));
                    if (!activities.checkMimeTypeIndexable(mimeType)) {
                        errorCode = "EXCLUDEDMIMETYPE";
                        errorDesc = "Excluded because of mime type ('" + mimeType + "')";
                        activities.noDocument(documentIdentifier, version);
                        continue;
                    }
                    try {
                        RepositoryDocument rd = new RepositoryDocument();
                        rd.setFileName(part.getFileName());
                        rd.setMimeType(mimeType);
                        rd.setCreatedDate(sentDate2);
                        rd.setModifiedDate(sentDate2);
                        for (String metadata : requiredMetadata) {
                            int j;
                            if (metadata.toLowerCase(Locale.ROOT).equals("to")) {
                                Address[] to = msg.getRecipients(Message.RecipientType.TO);
                                if (to == null) continue;
                                String[] toStr = new String[to.length];
                                j = 0;
                                for (Address address : to) {
                                    toStr[j] = useEmailExtractor ? this.extractEmailAddress(address.toString()) : address.toString();
                                    ++j;
                                }
                                rd.addField("to", toStr);
                                continue;
                            }
                            if (metadata.toLowerCase(Locale.ROOT).equals("from")) {
                                Address[] from = msg.getFrom();
                                String[] fromStr = new String[from.length];
                                j = 0;
                                for (Address address : from) {
                                    fromStr[j] = useEmailExtractor ? this.extractEmailAddress(address.toString()) : address.toString();
                                    ++j;
                                }
                                rd.addField("from", fromStr);
                                continue;
                            }
                            if (metadata.toLowerCase(Locale.ROOT).equals("subject")) {
                                String subject = msg.getSubject();
                                rd.addField("mailsubject", subject);
                                continue;
                            }
                            if (!metadata.toLowerCase(Locale.ROOT).equals("date")) continue;
                            rd.addField("date", sentDate2.toString());
                        }
                        try (InputStream is = part.getInputStream();){
                            rd.setBinary(is, fileLength);
                            activities.ingestDocumentWithException(documentIdentifier, version, msgURL, rd);
                            errorCode = "OK";
                            fileLengthLong = new Long(fileLength);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new ManifoldCFException(e.getMessage(), 2);
                    }
                    catch (MessagingException e) {
                        errorCode = ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                        errorDesc = e.getMessage();
                        EmailConnector.handleMessagingException(e, "processing email attachment");
                    }
                    catch (IOException e) {
                        errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                        errorDesc = e.getMessage();
                        EmailConnector.handleIOException(e, "processing email attachment");
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) {
                        errorCode = null;
                    }
                    throw e;
                }
                finally {
                    if (errorCode != null) {
                        activities.recordActivity(new Long(startTime), "fetch", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
                    }
                }
            }
        }
        finally {
            for (Folder f : openFolders.values()) {
                try {
                    CloseFolderThread cft = new CloseFolderThread(this.session, f);
                    cft.start();
                    cft.finishUp();
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException(e.getMessage(), 2);
                }
                catch (MessagingException e) {
                    EmailConnector.handleMessagingException(e, "closing folders");
                }
            }
        }
    }

    private EmailContent getContent(Part part) throws MessagingException, IOException {
        if (part.isMimeType("text/plain")) {
            return new EmailContent(part.getContent().toString());
        }
        if (part.isMimeType("text/html")) {
            return new EmailContent(part.getContent().toString(), "text/html");
        }
        if (part.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)part.getContent();
            EmailContent emailContent = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bodyPart = mp.getBodyPart(i);
                if (bodyPart.isMimeType("text/plain")) {
                    if (emailContent != null) continue;
                    emailContent = this.getContent((Part)bodyPart);
                    continue;
                }
                if (bodyPart.isMimeType("text/html")) {
                    emailContent = this.getContent((Part)bodyPart);
                    if (emailContent == null) continue;
                    return emailContent;
                }
                return this.getContent((Part)bodyPart);
            }
            return emailContent;
        }
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                EmailContent emailContent = this.getContent((Part)mp.getBodyPart(i));
                if (emailContent == null) continue;
                return emailContent;
            }
        }
        return null;
    }

    private EmailContent extractBodyContent(Message msg) throws MessagingException, IOException {
        EmailContent emailContent = null;
        Object o = msg.getContent();
        if (o instanceof Multipart) {
            Multipart mp = (Multipart)msg.getContent();
            int n = mp.getCount();
            for (int k = 0; k < n; ++k) {
                EmailContent content;
                BodyPart part = mp.getBodyPart(k);
                String disposition = part.getDisposition();
                if (disposition != null || (content = this.getContent((Part)part)) == null) continue;
                emailContent = content;
            }
        } else if (o instanceof String) {
            emailContent = new EmailContent((String)o);
        }
        return emailContent;
    }

    private boolean isAttachment(Part part) throws MessagingException {
        String disposition = part.getDisposition();
        return disposition != null && (disposition.toLowerCase(Locale.ROOT).equals("attachment") || disposition.toLowerCase(Locale.ROOT).equals("inline"));
    }

    private String extractEmailAddress(String rawEmailAddress) {
        Pattern pattern = Pattern.compile("<(.+?@.+?)>");
        Matcher matcher = pattern.matcher(rawEmailAddress);
        return matcher.find() ? matcher.group(1) : rawEmailAddress;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "EmailConnector.Server"));
        tabsArray.add(Messages.getString(locale, "EmailConnector.URL"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        EmailConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        EmailConnector.fillInURLConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationHeader.js", paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        EmailConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        EmailConnector.fillInURLConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "Configuration_Server.html", paramMap);
        Messages.outputResourceWithVelocity(out, locale, "Configuration_URL.html", paramMap);
    }

    private static void fillInServerConfigurationMap(Map<String, Object> paramMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        int i = 0;
        String username = parameters.getParameter("username");
        String password = parameters.getObfuscatedParameter("password");
        String protocol = parameters.getParameter("protocol");
        String server = parameters.getParameter("server");
        String port = parameters.getParameter("port");
        ArrayList list = new ArrayList();
        while (i < parameters.getChildCount()) {
            ConfigNode cn;
            if (!(cn = parameters.getChild(i++)).getType().equals("properties")) continue;
            String findParameterName = cn.getAttributeValue("name");
            String findParameterValue = cn.getAttributeValue("value");
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("name", findParameterName);
            row.put("value", findParameterValue);
            list.add(row);
        }
        if (username == null) {
            username = "";
        }
        password = password == null ? "" : mapper.mapPasswordToKey(password);
        if (protocol == null) {
            protocol = "IMAP";
        }
        if (server == null) {
            server = "";
        }
        if (port == null) {
            port = "";
        }
        paramMap.put("USERNAME", username);
        paramMap.put("PASSWORD", password);
        paramMap.put("PROTOCOL", protocol);
        paramMap.put("SERVER", server);
        paramMap.put("PORT", port);
        paramMap.put("PROPERTIES", list);
    }

    private static void fillInURLConfigurationMap(Map<String, Object> paramMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String urlTemplate = parameters.getParameter("url");
        if (urlTemplate == null) {
            urlTemplate = "http://sampleserver/$(FOLDERNAME)?id=$(MESSAGEID)";
        }
        paramMap.put("URL", urlTemplate);
        String attachmentUrlTemplate = parameters.getParameter("attachmenturl");
        if (attachmentUrlTemplate == null) {
            attachmentUrlTemplate = "http://sampleserver/$(FOLDERNAME)?id=$(MESSAGEID)&attach=$(ATTACHMENTNUMBER)";
        }
        paramMap.put("ATTACHMENTURL", attachmentUrlTemplate);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String operation;
        String port;
        String server;
        String protocol;
        String password;
        String userName;
        String attachmentUrlTemplate;
        String urlTemplate = variableContext.getParameter("url");
        if (urlTemplate != null) {
            parameters.setParameter("url", urlTemplate);
        }
        if ((attachmentUrlTemplate = variableContext.getParameter("attachmenturl")) != null) {
            parameters.setParameter("attachmenturl", attachmentUrlTemplate);
        }
        if ((userName = variableContext.getParameter("username")) != null) {
            parameters.setParameter("username", userName);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((protocol = variableContext.getParameter("protocol")) != null) {
            parameters.setParameter("protocol", protocol);
        }
        if ((server = variableContext.getParameter("server")) != null) {
            parameters.setParameter("server", server);
        }
        if ((port = variableContext.getParameter("port")) != null) {
            parameters.setParameter("port", port);
        }
        EmailConnector.removeNodes(parameters, "properties");
        String findCountString = variableContext.getParameter("findcount");
        if (findCountString != null) {
            int findCount = Integer.parseInt(findCountString);
            int i = 0;
            while (i < findCount) {
                String suffix;
                String findParameterOp;
                if ((findParameterOp = variableContext.getParameter("findop" + (suffix = "_" + Integer.toString(i++)))) != null && findParameterOp.equals("Delete")) continue;
                String findParameterName = variableContext.getParameter("findname" + suffix);
                String findParameterValue = variableContext.getParameter("findvalue" + suffix);
                EmailConnector.addFindParameterNode(parameters, findParameterName, findParameterValue);
            }
        }
        if ((operation = variableContext.getParameter("findop")) != null && operation.equals("Add")) {
            String findParameterName = variableContext.getParameter("findname");
            String findParameterValue = variableContext.getParameter("findvalue");
            EmailConnector.addFindParameterNode(parameters, findParameterName, findParameterValue);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        EmailConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        EmailConnector.fillInURLConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationView.html", paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "EmailConnector.Metadata"));
        tabsArray.add(Messages.getString(locale, "EmailConnector.Filter"));
        Messages.outputResourceWithVelocity(out, locale, "SpecificationHeader.js", paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        this.outputFilterTab(out, locale, ds, tabName, connectionSequenceNumber, actualSequenceNumber);
        this.outputMetadataTab(out, locale, ds, tabName, connectionSequenceNumber, actualSequenceNumber);
    }

    protected void outputMetadataTab(IHTTPOutput out, Locale locale, Specification ds, String tabName, int connectionSequenceNumber, int actualSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        EmailConnector.fillInMetadataTab(paramMap, ds);
        this.fillInMetadataAttributes(paramMap);
        Messages.outputResourceWithVelocity(out, locale, "Specification_Metadata.html", paramMap);
    }

    protected static void fillInMetadataTab(Map<String, Object> paramMap, Specification ds) {
        HashSet<String> metadataSelections = new HashSet<String>();
        String extractEmailSelection = null;
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("metadata")) {
                String metadataName = sn.getAttributeValue("name");
                metadataSelections.add(metadataName);
                continue;
            }
            if (!sn.getType().equals("extractemail")) continue;
            extractEmailSelection = sn.getAttributeValue("name");
        }
        paramMap.put("METADATASELECTIONS", metadataSelections);
        paramMap.put("EXTRACTEMAILSELECTION", extractEmailSelection);
    }

    protected void fillInMetadataAttributes(Map<String, Object> paramMap) {
        String[] matchNames = EmailConfig.BASIC_METADATA;
        paramMap.put("METADATAATTRIBUTES", matchNames);
        String extractEmailAttribute = "Use E-Mail Extractor";
        paramMap.put("EXTRACTEMAILATTRIBUTE", extractEmailAttribute);
    }

    protected void outputFilterTab(IHTTPOutput out, Locale locale, Specification ds, String tabName, int connectionSequenceNumber, int actualSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        EmailConnector.fillInFilterTab(paramMap, ds);
        if (tabName.equals(Messages.getString(locale, "EmailConnector.Filter"))) {
            this.fillInSearchableAttributes(paramMap);
        }
        Messages.outputResourceWithVelocity(out, locale, "Specification_Filter.html", paramMap);
    }

    private void fillInSearchableAttributes(Map<String, Object> paramMap) {
        String[] attributes = EmailConfig.BASIC_SEARCHABLE_ATTRIBUTES;
        paramMap.put("SEARCHABLEATTRIBUTES", attributes);
        try {
            String[] folderNames = this.getFolderNames();
            paramMap.put("FOLDERNAMES", folderNames);
            paramMap.put("EXCEPTION", "");
        }
        catch (ManifoldCFException e) {
            paramMap.put("EXCEPTION", e.getMessage());
        }
        catch (ServiceInterruption e) {
            paramMap.put("EXCEPTION", e.getMessage());
        }
    }

    protected static void fillInFilterTab(Map<String, Object> paramMap, Specification ds) {
        ArrayList filterList = new ArrayList();
        HashSet<String> folders = new HashSet<String>();
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("filter")) {
                String findParameterName = sn.getAttributeValue("name");
                String findParameterValue = sn.getAttributeValue("value");
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("name", findParameterName);
                row.put("value", findParameterValue);
                filterList.add(row);
                continue;
            }
            if (!sn.getType().equals("folder")) continue;
            String folderName = sn.getAttributeValue("name");
            folders.add(folderName);
        }
        paramMap.put("MATCHES", filterList);
        paramMap.put("FOLDERS", folders);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String result = this.processFilterTab(variableContext, ds, connectionSequenceNumber);
        if (result != null) {
            return result;
        }
        result = this.processMetadataTab(variableContext, ds, connectionSequenceNumber);
        return result;
    }

    protected String processFilterTab(IPostParameters variableContext, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String[] folders;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String findCountString = variableContext.getParameter(seqPrefix + "findcount");
        if (findCountString != null) {
            int findCount = Integer.parseInt(findCountString);
            EmailConnector.removeNodes(ds, "filter");
            int i = 0;
            while (i < findCount) {
                String suffix;
                String findParameterOp;
                if ((findParameterOp = variableContext.getParameter(seqPrefix + "findop" + (suffix = "_" + Integer.toString(i++)))) != null && findParameterOp.equals("Delete")) continue;
                String findParameterName = variableContext.getParameter(seqPrefix + "findname" + suffix);
                String findParameterValue = variableContext.getParameter(seqPrefix + "findvalue" + suffix);
                EmailConnector.addFindParameterNode(ds, findParameterName, findParameterValue);
            }
            String operation = variableContext.getParameter(seqPrefix + "findop");
            if (operation != null && operation.equals("Add")) {
                String findParameterName = variableContext.getParameter(seqPrefix + "findname");
                String findParameterValue = variableContext.getParameter(seqPrefix + "findvalue");
                EmailConnector.addFindParameterNode(ds, findParameterName, findParameterValue);
            }
        }
        if ((folders = variableContext.getParameterValues(seqPrefix + "folders")) != null) {
            EmailConnector.removeNodes(ds, "folder");
            for (String folder : folders) {
                EmailConnector.addFolderNode(ds, folder);
            }
        }
        return null;
    }

    protected String processMetadataTab(IPostParameters variableContext, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String result = this.processMetadataAttributes(variableContext, ds, connectionSequenceNumber);
        if (result != null) {
            return result;
        }
        result = this.processExtractEmail(variableContext, ds, connectionSequenceNumber);
        return result;
    }

    protected String processMetadataAttributes(IPostParameters variableContext, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        EmailConnector.removeNodes(ds, "metadata");
        String[] metadataNames = variableContext.getParameterValues(seqPrefix + "metadata");
        if (metadataNames != null) {
            int i = 0;
            while (i < metadataNames.length) {
                String metadataName = metadataNames[i++];
                EmailConnector.addIncludedMetadataNode(ds, metadataName);
            }
        }
        return null;
    }

    protected String processExtractEmail(IPostParameters variableContext, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        EmailConnector.removeNodes(ds, "extractemail");
        String extractEmail = variableContext.getParameter(seqPrefix + "extractemail");
        if (extractEmail == null) {
            return null;
        }
        SpecificationNode sn = new SpecificationNode("extractemail");
        sn.setAttribute("name", extractEmail);
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        EmailConnector.fillInFilterTab(paramMap, ds);
        EmailConnector.fillInMetadataTab(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "SpecificationView.html", paramMap);
    }

    protected String[] getFolderNames() throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        try {
            ListFoldersThread lft = new ListFoldersThread(this.session);
            lft.start();
            return lft.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (MessagingException e) {
            EmailConnector.handleMessagingException(e, "getting folder list");
            return null;
        }
    }

    protected static String makeDocumentURI(String urlTemplate, String folderName, String id) {
        String encodedFolderName = URLEncoder.encode((String)folderName);
        String encodedId = URLEncoder.encode((String)id);
        HashMap<String, String> subsMap = new HashMap<String, String>();
        subsMap.put("FOLDERNAME", encodedFolderName);
        subsMap.put("MESSAGEID", encodedId);
        return EmailConnector.substitute(urlTemplate, subsMap);
    }

    protected static String makeDocumentURI(String urlTemplate, String folderName, String id, int attachmentNumber) {
        String encodedFolderName = URLEncoder.encode((String)folderName);
        String encodedId = URLEncoder.encode((String)id);
        HashMap<String, String> subsMap = new HashMap<String, String>();
        subsMap.put("FOLDERNAME", encodedFolderName);
        subsMap.put("MESSAGEID", encodedId);
        subsMap.put("ATTACHMENTNUMBER", Integer.toString(attachmentNumber));
        return EmailConnector.substitute(urlTemplate, subsMap);
    }

    protected static String substitute(String template, Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (true) {
            int newIndex;
            if ((newIndex = template.indexOf("$(", index)) == -1) {
                sb.append(template.substring(index));
                break;
            }
            sb.append(template.substring(index, newIndex));
            int endIndex = template.indexOf(")", newIndex + 2);
            String varName = endIndex == -1 ? template.substring(newIndex + 2) : template.substring(newIndex + 2, endIndex);
            String subsValue = map.get(varName);
            if (subsValue == null) {
                subsValue = "";
            }
            sb.append(subsValue);
            if (endIndex == -1) break;
            index = endIndex + 1;
        }
        return sb.toString();
    }

    protected static void addFindParameterNode(ConfigParams parameters, String findParameterName, String findParameterValue) {
        ConfigNode cn = new ConfigNode("properties");
        cn.setAttribute("name", findParameterName);
        cn.setAttribute("value", findParameterValue);
        parameters.addChild(parameters.getChildCount(), (ConfigurationNode)cn);
    }

    protected static void removeNodes(ConfigParams parameters, String nodeTypeName) {
        int i = 0;
        while (i < parameters.getChildCount()) {
            ConfigNode cn = parameters.getChild(i);
            if (cn.getType().equals(nodeTypeName)) {
                parameters.removeChild(i);
                continue;
            }
            ++i;
        }
    }

    protected static void removeNodes(Specification ds, String nodeTypeName) {
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals(nodeTypeName)) {
                ds.removeChild(i);
                continue;
            }
            ++i;
        }
    }

    protected static void addIncludedMetadataNode(Specification ds, String metadataName) {
        SpecificationNode sn = new SpecificationNode("metadata");
        sn.setAttribute("name", metadataName);
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    protected static void addFindParameterNode(Specification ds, String findParameterName, String findParameterValue) {
        SpecificationNode sn = new SpecificationNode("filter");
        sn.setAttribute("name", findParameterName);
        sn.setAttribute("value", findParameterValue);
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    protected static void addFolderNode(Specification ds, String folderName) {
        SpecificationNode sn = new SpecificationNode("folder");
        sn.setAttribute("name", folderName);
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    protected static String createDocumentIdentifier(String folderName, String emailID) {
        return EmailConnector.makeSafeFolderName(folderName) + ":" + emailID;
    }

    protected static Integer extractAttachmentNumberFromDocumentIdentifier(String di) {
        int index1 = di.indexOf(":");
        if (index1 == -1) {
            throw new RuntimeException("Bad document identifier: '" + di + "'");
        }
        int index2 = di.indexOf(":", index1 + 1);
        if (index2 == -1) {
            return null;
        }
        return new Integer(di.substring(index2 + 1));
    }

    protected static String extractFolderNameFromDocumentIdentifier(String di) {
        int index = di.indexOf(":");
        if (index == -1) {
            throw new RuntimeException("Bad document identifier: '" + di + "'");
        }
        return di.substring(0, index);
    }

    protected static String extractEmailIDFromDocumentIdentifier(String di) {
        int index1 = di.indexOf(":");
        if (index1 == -1) {
            throw new RuntimeException("Bad document identifier: '" + di + "'");
        }
        int index2 = di.indexOf(":", index1 + 1);
        if (index2 == -1) {
            return di.substring(index1 + 1);
        }
        return di.substring(index1 + 1, index2);
    }

    protected static String makeSafeFolderName(String folderName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < folderName.length(); ++i) {
            char x = folderName.charAt(i);
            if (x == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (x == ':') {
                sb.append('\\').append('0');
                continue;
            }
            sb.append(x);
        }
        return sb.toString();
    }

    protected static String unpackSafeFolderName(String packedFolderName) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < packedFolderName.length()) {
            char x;
            if ((x = packedFolderName.charAt(i++)) == '\\') {
                if (i == packedFolderName.length()) {
                    throw new RuntimeException("Illegal packed folder name: '" + packedFolderName + "'");
                }
                if ((x = packedFolderName.charAt(i++)) == '\\') {
                    sb.append('\\');
                    continue;
                }
                if (x == '0') {
                    sb.append(':');
                    continue;
                }
                throw new RuntimeException("Illegal packed folder name: '" + packedFolderName + "'");
            }
            sb.append(x);
        }
        return sb.toString();
    }

    protected static void handleMessagingException(MessagingException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e.getMessage().indexOf("Connection dropped by server?") != -1) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Email server is down, retrying: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        Logging.connectors.error((Object)("Email: Error " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("Error " + context + ": " + e.getMessage(), (Throwable)e);
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketTimeoutException) {
            Logging.connectors.error((Object)("Email: Socket timeout " + context + ": " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Socket timeout: " + e.getMessage(), (Throwable)e);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
        }
        Logging.connectors.error((Object)("Email: IO error " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("IO error " + context + ": " + e.getMessage(), (Throwable)e);
    }

    static {
        providerMap.put("POP3", "pop3");
        providerMap.put("POP3-SSL", "pop3s");
        providerMap.put("IMAP", "imap");
        providerMap.put("IMAP-SSL", "imaps");
    }

    private static class EmailContent {
        private final String content;
        private final String mimeType;

        public EmailContent(String content) {
            this.content = content;
            this.mimeType = "text/plain";
        }

        public EmailContent(String content, String mimetype) {
            this.content = content;
            this.mimeType = mimetype;
        }

        public String getContent() {
            return this.content;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    protected static class SearchMessagesThread
    extends Thread {
        protected final EmailSession session;
        protected final Folder folder;
        protected final SearchTerm searchTerm;
        protected Message[] messages = null;
        protected Throwable exception = null;

        public SearchMessagesThread(EmailSession session, Folder folder, SearchTerm searchTerm) {
            this.session = session;
            this.folder = folder;
            this.searchTerm = searchTerm;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.messages = this.session.search(this.folder, this.searchTerm);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Message[] finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.messages;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class GetMessagesThread
    extends Thread {
        protected final EmailSession session;
        protected final Folder folder;
        protected Message[] messages = null;
        protected Throwable exception = null;

        public GetMessagesThread(EmailSession session, Folder folder) {
            this.session = session;
            this.folder = folder;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.messages = this.session.getMessages(this.folder);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Message[] finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.messages;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CloseFolderThread
    extends Thread {
        protected final EmailSession session;
        protected final Folder folder;
        protected Throwable exception = null;

        public CloseFolderThread(EmailSession session, Folder folder) {
            this.session = session;
            this.folder = folder;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.closeFolder(this.folder);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class OpenFolderThread
    extends Thread {
        protected final EmailSession session;
        protected final String folderName;
        protected Folder folder = null;
        protected Throwable exception = null;

        public OpenFolderThread(EmailSession session, String folderName) {
            this.session = session;
            this.folderName = folderName;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.folder = this.session.openFolder(this.folderName);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Folder finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.folder;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final EmailSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(EmailSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.checkConnection();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class ListFoldersThread
    extends Thread {
        protected final EmailSession session;
        protected String[] rval = null;
        protected Throwable exception = null;

        public ListFoldersThread(EmailSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.rval = this.session.listFolders();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public String[] finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.rval;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CloseSessionThread
    extends Thread {
        protected final EmailSession session;
        protected Throwable exception = null;

        public CloseSessionThread(EmailSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.close();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class ConnectThread
    extends Thread {
        protected final String server;
        protected final int port;
        protected final String username;
        protected final String password;
        protected final String protocol;
        protected final Properties properties;
        protected EmailSession session = null;
        protected Throwable exception = null;

        public ConnectThread(String server, int port, String username, String password, String protocol, Properties properties) {
            this.server = server;
            this.port = port;
            this.username = username;
            this.password = password;
            this.protocol = protocol;
            this.properties = properties;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session = new EmailSession(this.server, this.port, this.username, this.password, this.protocol, this.properties);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public EmailSession finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.session;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }
}

