/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IDiscoveredLinkHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.WebcrawlerConnector;

public class FindHandler
implements IDiscoveredLinkHandler {
    protected String parentURI;
    protected String targetURI = null;

    public FindHandler(String parentURI) {
        this.parentURI = parentURI;
    }

    @Override
    public void noteDiscoveredBase(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
        try {
            URI url;
            if (this.parentURI != null) {
                URI parentURL = new URI(this.parentURI);
                url = parentURL.resolve(rawURL);
            } else {
                url = new URI(rawURL);
            }
            String protocol = url.getScheme();
            String host = url.getHost();
            if (protocol == null || host == null) {
                return;
            }
            if (!WebcrawlerConnector.understoodProtocols.contains(protocol)) {
                return;
            }
            String id = url.toASCIIString();
            if (id == null) {
                return;
            }
            int i = 0;
            while (i < id.length()) {
                char x;
                if ((x = id.charAt(i++)) >= ' ' && x <= '\u007f') continue;
                return;
            }
            this.targetURI = id;
        }
        catch (URISyntaxException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public String getTargetURI() {
        return this.targetURI;
    }
}

