/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.knox.token;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.knox.token.Get;
import org.apache.knox.gateway.shell.knox.token.Renew;
import org.apache.knox.gateway.shell.knox.token.Revoke;

public class Token {
    private static final String KNOX_TOKEN_INCLUDE_GROUPS = "knox.token.include.groups";
    static String SERVICE_PATH = "/knoxtoken/api/v1/token";

    public static Get.Request get(KnoxSession session) {
        return new Get.Request(session);
    }

    public static Get.Request get(KnoxSession session, String doAsUser) {
        return new Get.Request(session, doAsUser, Collections.emptyList());
    }

    public static Get.Request get(KnoxSession session, String doAsUser, boolean includeGroupsInToken) {
        ArrayList<NameValuePair> queryParamss = new ArrayList<NameValuePair>();
        if (includeGroupsInToken) {
            queryParamss.add((NameValuePair)new BasicNameValuePair(KNOX_TOKEN_INCLUDE_GROUPS, "true"));
        }
        return new Get.Request(session, doAsUser, queryParamss);
    }

    public static Renew.Request renew(KnoxSession session, String token) {
        return new Renew.Request(session, token);
    }

    public static Renew.Request renew(KnoxSession session, String token, String doAsUser) {
        return new Renew.Request(session, token, doAsUser);
    }

    public static Revoke.Request revoke(KnoxSession session, String token) {
        return new Revoke.Request(session, token);
    }

    public static Revoke.Request revoke(KnoxSession session, String token, String doAsUser) {
        return new Revoke.Request(session, token, doAsUser);
    }
}

