/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import com.nimbusds.jose.JOSEObjectType;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.provider.federation.jwt.filter.AbstractJWTFilter;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.util.AuthFilterUtils;
import org.apache.knox.gateway.util.CertificateUtils;
import org.apache.knox.gateway.util.CookieUtils;

public class JWTFederationFilter
extends AbstractJWTFilter {
    private static final JWTMessages LOGGER = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    public static final String JWT_UNAUTHENTICATED_PATHS_PARAM = "jwt.unauthenticated.path.list";
    public static final String GRANT_TYPE = "grant_type";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CLIENT_ID = "client_id";
    public static final String MISMATCHING_CLIENT_ID_AND_CLIENT_SECRET = "Client credentials flow with mismatching client_id and client_secret";
    public static final String KNOX_TOKEN_AUDIENCES = "knox.token.audiences";
    public static final String TOKEN_VERIFICATION_PEM = "knox.token.verification.pem";
    public static final String KNOX_TOKEN_QUERY_PARAM_NAME = "knox.token.query.param.name";
    public static final String TOKEN_PRINCIPAL_CLAIM = "knox.token.principal.claim";
    public static final String JWKS_URL = "knox.token.jwks.url";
    public static final String JWKS_URLS = "knox.token.jwks.urls";
    public static final String ALLOWED_JWS_TYPES = "knox.token.allowed.jws.types";
    public static final String BEARER = "Bearer ";
    public static final String BASIC = "Basic";
    public static final String TOKEN = "Token";
    public static final String PASSCODE = "Passcode";
    public static final String KNOX_TOKEN_USE_COOKIE = "knox.token.use.cookie";
    public static final String KNOX_TOKEN_COOKIE_NAME = "knox.token.cookie.name";
    private boolean useCookie;
    private String cookieName;
    private String paramName;
    private Set<String> unAuthenticatedPaths = new HashSet<String>(20);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String verificationPEM;
        String oidcjwksurls;
        String oidcjwksurl;
        String queryParamName;
        super.init(filterConfig);
        String expectedAudiences = filterConfig.getInitParameter(KNOX_TOKEN_AUDIENCES);
        if (expectedAudiences != null) {
            this.audiences = this.parseExpectedAudiences(expectedAudiences);
        }
        if ((queryParamName = filterConfig.getInitParameter(KNOX_TOKEN_QUERY_PARAM_NAME)) != null) {
            this.paramName = queryParamName;
        }
        if ((oidcjwksurl = filterConfig.getInitParameter(JWKS_URL)) != null) {
            this.expectedJWKSUrls = this.parseJwksUrlsFromConfig(oidcjwksurl);
        }
        if ((oidcjwksurls = filterConfig.getInitParameter(JWKS_URLS)) != null) {
            this.expectedJWKSUrls.addAll(this.parseJwksUrlsFromConfig(oidcjwksurls));
        }
        this.allowedJwsTypes = new HashSet();
        String allowedTypes = filterConfig.getInitParameter(ALLOWED_JWS_TYPES);
        if (allowedTypes != null) {
            Stream.of(allowedTypes.trim().split(",")).forEach(allowedType -> this.allowedJwsTypes.add(new JOSEObjectType(allowedType.trim())));
        } else {
            this.allowedJwsTypes.add(JOSEObjectType.JWT);
        }
        String useCookieParam = filterConfig.getInitParameter(KNOX_TOKEN_USE_COOKIE);
        this.useCookie = StringUtils.isBlank((CharSequence)useCookieParam) ? false : Boolean.parseBoolean(useCookieParam);
        String cookieNameParam = filterConfig.getInitParameter(KNOX_TOKEN_COOKIE_NAME);
        this.cookieName = StringUtils.isBlank((CharSequence)cookieNameParam) ? "hadoop-jwt" : cookieNameParam;
        String oidcPrincipalclaim = filterConfig.getInitParameter(TOKEN_PRINCIPAL_CLAIM);
        if (oidcPrincipalclaim != null) {
            this.expectedPrincipalClaim = oidcPrincipalclaim;
        }
        if ((verificationPEM = filterConfig.getInitParameter(TOKEN_VERIFICATION_PEM)) != null) {
            this.publicKey = CertificateUtils.parseRSAPublicKey((String)verificationPEM);
        }
        String unAuthPathString = filterConfig.getInitParameter(JWT_UNAUTHENTICATED_PATHS_PARAM);
        AuthFilterUtils.addUnauthPaths(this.unAuthenticatedPaths, (String)unAuthPathString, (String)"/knoxtoken/api/v1/jwks.json");
        this.configureExpectedParameters(filterConfig);
    }

    private Set<URI> parseJwksUrlsFromConfig(String oidcjwksurls) {
        HashSet<URI> jwksUrlSet = new HashSet<URI>();
        Set jwksurls = Arrays.stream(oidcjwksurls.split(",")).map(String::trim).collect(Collectors.toSet());
        for (String jwksurl : jwksurls) {
            try {
                jwksUrlSet.add(new URI(jwksurl));
            }
            catch (URISyntaxException e) {
                log.invalidJwksUrl(jwksurl);
            }
        }
        return jwksUrlSet;
    }

    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (AuthFilterUtils.doesRequestContainUnauthPath(this.unAuthenticatedPaths, (ServletRequest)request)) {
            this.continueWithAnonymousSubject(request, response, chain);
            return;
        }
        if (this.useCookie) {
            try {
                if (this.authenticateWithCookies((HttpServletRequest)request, (HttpServletResponse)response, chain)) {
                    return;
                }
            }
            catch (NoValidCookiesException e) {
                log.missingValidCookie();
                this.handleValidationError((HttpServletRequest)request, (HttpServletResponse)response, 401, "There is no valid cookie found");
                return;
            }
        }
        Pair<TokenType, String> wireToken = null;
        try {
            wireToken = this.getWireToken(request);
        }
        catch (SecurityException e) {
            this.handleValidationError((HttpServletRequest)request, (HttpServletResponse)response, 400, null);
            throw e;
        }
        if (wireToken != null && wireToken.getLeft() != null && wireToken.getRight() != null) {
            TokenType tokenType = (TokenType)((Object)wireToken.getLeft());
            String tokenValue = (String)wireToken.getRight();
            if (TokenType.JWT.equals((Object)tokenType)) {
                try {
                    JWTToken token = new JWTToken(tokenValue);
                    if (this.validateToken((HttpServletRequest)request, (HttpServletResponse)response, chain, (JWT)token)) {
                        Subject subject = this.createSubjectFromToken((JWT)token);
                        this.continueWithEstablishedSecurityContext(subject, (HttpServletRequest)request, (HttpServletResponse)response, chain);
                    }
                }
                catch (ParseException | UnknownTokenException ex) {
                    ((HttpServletResponse)response).sendError(401);
                }
            } else if (TokenType.Passcode.equals((Object)tokenType)) {
                String tokenId = null;
                String passcode = null;
                try {
                    String[] base64DecodedTokenIdAndPasscode = this.decodeBase64(tokenValue).split("::");
                    tokenId = this.decodeBase64(base64DecodedTokenIdAndPasscode[0]);
                    passcode = this.decodeBase64(base64DecodedTokenIdAndPasscode[1]);
                }
                catch (Exception e) {
                    log.failedToParsePasscodeToken(e);
                    this.handleValidationError((HttpServletRequest)request, (HttpServletResponse)response, 401, "Error while parsing the received passcode token");
                }
                if (this.validateToken((HttpServletRequest)request, (HttpServletResponse)response, chain, tokenId, passcode)) {
                    try {
                        Subject subject = this.createSubjectFromTokenIdentifier(tokenId);
                        this.continueWithEstablishedSecurityContext(subject, (HttpServletRequest)request, (HttpServletResponse)response, chain);
                    }
                    catch (UnknownTokenException e) {
                        ((HttpServletResponse)response).sendError(401);
                    }
                }
            }
        } else {
            log.missingTokenFromHeader(wireToken);
            ((HttpServletResponse)response).sendError(401);
        }
    }

    private void validateClientID(HttpServletRequest request, String tokenValue) {
        String tokenId;
        String clientID = request.getParameter(CLIENT_ID);
        try {
            String[] base64DecodedTokenIdAndPasscode = this.decodeBase64(tokenValue).split("::");
            tokenId = this.decodeBase64(base64DecodedTokenIdAndPasscode[0]);
        }
        catch (Exception e) {
            throw new SecurityException("Error while parsing the received client secret", e);
        }
        if (clientID != null && !tokenId.equals(clientID)) {
            throw new SecurityException(MISMATCHING_CLIENT_ID_AND_CLIENT_SECRET);
        }
    }

    private String decodeBase64(String toBeDecoded) {
        return new String(Base64.getDecoder().decode(toBeDecoded.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public Pair<TokenType, String> getWireToken(ServletRequest request) throws IOException {
        Pair parsed = null;
        String token = null;
        String header = ((HttpServletRequest)request).getHeader("Authorization");
        if (header != null) {
            if (header.startsWith(BEARER)) {
                token = header.substring(BEARER.length());
                parsed = this.isJWT(token) ? Pair.of((Object)((Object)TokenType.JWT), (Object)token) : Pair.of((Object)((Object)TokenType.Passcode), (Object)token);
            } else if (header.toLowerCase(Locale.ROOT).startsWith(BASIC.toLowerCase(Locale.ROOT))) {
                parsed = this.parseFromHTTPBasicCredentials(header);
            }
        }
        if (parsed == null) {
            parsed = this.parseFromClientCredentialsFlow(request);
        }
        if (parsed == null && (token = request.getParameter(this.paramName)) != null) {
            parsed = Pair.of((Object)((Object)TokenType.JWT), (Object)token);
        }
        return parsed;
    }

    private Pair<TokenType, String> parseFromClientCredentialsFlow(ServletRequest request) throws IOException {
        boolean clientSecretPresentAsQueryString;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean bl = clientSecretPresentAsQueryString = httpRequest.getQueryString() != null && httpRequest.getQueryString().contains("client_secret=");
        if (clientSecretPresentAsQueryString) {
            throw new SecurityException("client_secret must not be sent as a query parameter");
        }
        return this.getClientCredentialsFromRequestBody(request);
    }

    private Pair<TokenType, String> getClientCredentialsFromRequestBody(ServletRequest request) {
        String grantType = request.getParameter(GRANT_TYPE);
        if (CLIENT_CREDENTIALS.equals(grantType)) {
            String clientSecret = request.getParameter(CLIENT_SECRET);
            this.validateClientID((HttpServletRequest)request, clientSecret);
            return Pair.of((Object)((Object)TokenType.Passcode), (Object)clientSecret);
        }
        return null;
    }

    private Pair<TokenType, String> parseFromHTTPBasicCredentials(String header) {
        String passcode;
        Pair parsed = null;
        String base64Credentials = header.substring(BASIC.length()).trim();
        byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
        String credentials = new String(credDecoded, StandardCharsets.UTF_8);
        String[] values = credentials.split(":", 2);
        String username = values[0];
        String string = passcode = values[1].isEmpty() ? null : values[1];
        if (TOKEN.equalsIgnoreCase(username) || PASSCODE.equalsIgnoreCase(username)) {
            parsed = Pair.of((Object)((Object)(TOKEN.equalsIgnoreCase(username) ? TokenType.JWT : TokenType.Passcode)), (Object)passcode);
        }
        return parsed;
    }

    private boolean authenticateWithCookies(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws NoValidCookiesException, ServletException, IOException {
        List relevantCookies = CookieUtils.getCookiesForName((HttpServletRequest)request, (String)this.cookieName);
        for (Cookie ssoCookie : relevantCookies) {
            try {
                JWTToken token = new JWTToken(ssoCookie.getValue());
                if (!this.validateToken(request, response, chain, (JWT)token)) continue;
                Subject subject = this.createSubjectFromToken((JWT)token);
                this.continueWithEstablishedSecurityContext(subject, request, response, chain);
                return true;
            }
            catch (ParseException | UnknownTokenException throwable) {
            }
        }
        if (!relevantCookies.isEmpty()) {
            throw new NoValidCookiesException();
        }
        return false;
    }

    @Override
    protected void handleValidationError(HttpServletRequest request, HttpServletResponse response, int status, String error) throws IOException {
        if (error != null) {
            response.sendError(status, error);
        } else {
            response.sendError(status);
        }
    }

    private void continueWithAnonymousSubject(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            Subject sub = new Subject();
            sub.getPrincipals().add((Principal)new PrimaryPrincipal("anonymous"));
            LOGGER.unauthenticatedPathBypass(((HttpServletRequest)request).getRequestURI(), this.unAuthenticatedPaths.toString());
            this.continueWithEstablishedSecurityContext(sub, (HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
        catch (Exception e) {
            LOGGER.unauthenticatedPathError(((HttpServletRequest)request).getRequestURI(), e.toString());
            throw e;
        }
    }

    private class NoValidCookiesException
    extends Exception {
        NoValidCookiesException() {
            super("None of the presented cookies are valid.");
        }
    }

    public static enum TokenType {
        JWT,
        Passcode;

    }
}

