/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.gen.OctetSequenceKeyGenerator;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.knoxtoken.ServletContextWrapper;
import org.apache.knox.gateway.service.knoxtoken.TokenResource;
import org.apache.knox.gateway.service.knoxtoken.TokenResourceV2;
import org.apache.knox.gateway.service.knoxtoken.TokenServiceMessages;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.TokenStateService;

public class PasscodeTokenResourceBase
extends TokenResourceV2 {
    protected GatewayServices services;
    private static TokenServiceMessages log = (TokenServiceMessages)MessagesFactory.get(TokenServiceMessages.class);

    protected void addExpiryIfNotNever(Map<String, Object> map) {
        long expiresIn = this.getTokenLifetimeInSeconds();
        if (expiresIn != -1L) {
            map.put("expires_in", expiresIn);
        }
    }

    @Override
    protected ServletContext wrapContextForDefaultParams(ServletContext context) throws ServletException {
        ServletContextWrapper wrapperContext = new ServletContextWrapper(context);
        wrapperContext.setInitParameter(this.getPrefix() + "knox.token.ttl", "-1");
        this.setExpectedParamsFromExtensionParams(wrapperContext);
        this.setupTokenStateService(wrapperContext);
        return wrapperContext;
    }

    private void setExpectedParamsFromExtensionParams(ServletContextWrapper context) {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return;
        }
        Enumeration<String> names = context.getInitParameterNames();
        while (names.hasMoreElements()) {
            int start;
            String name = names.nextElement();
            if (!name.startsWith(prefix) || (start = prefix.indexOf(46)) == -1) continue;
            context.setExtensionParameter(name.substring(start + 1), context.getInitParameter(name));
        }
    }

    public String getPrefix() {
        return null;
    }

    protected void setupTokenStateService(ServletContext wrapperContext) throws ServletException {
        char[] hashkey;
        wrapperContext.setInitParameter("knox.token.exp.server-managed", "true");
        this.services = (GatewayServices)wrapperContext.getAttribute("org.apache.knox.gateway.gateway.services");
        this.tokenStateService = (TokenStateService)this.services.getService(ServiceType.TOKEN_STATE_SERVICE);
        GatewayConfig gatewayConfig = (GatewayConfig)wrapperContext.getAttribute("org.apache.knox.gateway.config");
        gatewayConfig.getKnoxTokenHashAlgorithm();
        AliasService aliasService = (AliasService)this.services.getService(ServiceType.ALIAS_SERVICE);
        try {
            hashkey = aliasService.getPasswordFromAliasForGateway("knox.token.hash.key");
        }
        catch (AliasServiceException e) {
            throw new ServletException((Throwable)e);
        }
        if (hashkey == null) {
            this.generateAndStoreHMACKeyAlias();
        }
    }

    protected void generateAndStoreHMACKeyAlias() {
        int keyLength = Integer.parseInt(JWSAlgorithm.HS256.getName().substring(2));
        String jwkAsText = null;
        try {
            OctetSequenceKey jwk = (OctetSequenceKey)new OctetSequenceKeyGenerator(keyLength).keyID(UUID.randomUUID().toString()).algorithm((Algorithm)JWSAlgorithm.HS256).generate();
            jwkAsText = jwk.getKeyValue().toJSONString().replace("\"", "");
            this.getAliasService().addAliasForCluster("__gateway", "knox.token.hash.key", jwkAsText);
        }
        catch (JOSEException | AliasServiceException e) {
            throw new RuntimeException("Error while generating " + keyLength + " bits JWK secret", e);
        }
    }

    protected AliasService getAliasService() {
        return (AliasService)this.services.getService(ServiceType.ALIAS_SERVICE);
    }

    protected Response checkForInvalidRequestResponse(TokenResource.UserContext context) {
        Response response = this.enforceClientCertIfRequired();
        if (response != null) {
            return response;
        }
        response = this.onlyAllowGroupsToBeAddedWhenEnabled();
        if (response != null) {
            return response;
        }
        response = this.enforceTokenLimitsAsRequired(context.userName);
        if (response != null) {
            return response;
        }
        return response;
    }

    protected long getTokenLifetimeInSeconds() {
        long secs = this.tokenTTL / 1000L;
        String lifetimeStr = this.request.getParameter("lifespan");
        if (lifetimeStr == null || lifetimeStr.isEmpty()) {
            if (this.tokenTTL == -1L) {
                return -1L;
            }
        } else {
            try {
                long lifetime = Duration.parse(lifetimeStr).toMillis() / 1000L;
                if (this.tokenTTL == -1L) {
                    secs = lifetime;
                } else if (lifetime <= this.tokenTTL / 1000L) {
                    secs = lifetime;
                }
            }
            catch (DateTimeParseException e) {
                log.invalidLifetimeValue(lifetimeStr);
            }
        }
        return secs;
    }
}

