/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiAtlasReplicationArguments;
import com.cloudera.api.swagger.model.ApiHBaseReplicationArguments;
import com.cloudera.api.swagger.model.ApiHdfsCloudReplicationArguments;
import com.cloudera.api.swagger.model.ApiHdfsReplicationArguments;
import com.cloudera.api.swagger.model.ApiHive3ReplicationArguments;
import com.cloudera.api.swagger.model.ApiHiveCloudReplicationArguments;
import com.cloudera.api.swagger.model.ApiHiveReplicationArguments;
import com.cloudera.api.swagger.model.ApiIcebergReplicationArguments;
import com.cloudera.api.swagger.model.ApiOzoneReplicationArguments;
import com.cloudera.api.swagger.model.ApiRangerReplicationArgs;
import com.cloudera.api.swagger.model.ApiReplicationCommand;
import com.cloudera.api.swagger.model.ApiSchedule;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A replication job schedule. <p/> Replication jobs have service-specific arguments. This object has methods to retrieve arguments for all supported types of replication, but only one argument type is allowed to be set; the backend will check that the provided argument matches the service type where the replication is being scheduled. <p/> The replication job's arguments should match the underlying service. Refer to each property's documentation to find out which properties correspond to which services.")
public class ApiReplicationSchedule
extends ApiSchedule {
    @SerializedName(value="hdfsArguments")
    private ApiHdfsReplicationArguments hdfsArguments = null;
    @SerializedName(value="hiveArguments")
    private ApiHiveReplicationArguments hiveArguments = null;
    @SerializedName(value="hdfsCloudArguments")
    private ApiHdfsCloudReplicationArguments hdfsCloudArguments = null;
    @SerializedName(value="ozoneReplicationArguments")
    private ApiOzoneReplicationArguments ozoneReplicationArguments = null;
    @SerializedName(value="history")
    private List<ApiReplicationCommand> history = null;
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="hiveCloudArguments")
    private ApiHiveCloudReplicationArguments hiveCloudArguments = null;
    @SerializedName(value="hbaseArguments")
    private ApiHBaseReplicationArguments hbaseArguments = null;
    @SerializedName(value="hive3Arguments")
    private ApiHive3ReplicationArguments hive3Arguments = null;
    @SerializedName(value="rangerArguments")
    private ApiRangerReplicationArgs rangerArguments = null;
    @SerializedName(value="icebergArguments")
    private ApiIcebergReplicationArguments icebergArguments = null;
    @SerializedName(value="atlasReplicationArguments")
    private ApiAtlasReplicationArguments atlasReplicationArguments = null;

    public ApiReplicationSchedule hdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
        return this;
    }

    @Schema(description="")
    public ApiHdfsReplicationArguments getHdfsArguments() {
        return this.hdfsArguments;
    }

    public void setHdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
    }

    public ApiReplicationSchedule hiveArguments(ApiHiveReplicationArguments hiveArguments) {
        this.hiveArguments = hiveArguments;
        return this;
    }

    @Schema(description="")
    public ApiHiveReplicationArguments getHiveArguments() {
        return this.hiveArguments;
    }

    public void setHiveArguments(ApiHiveReplicationArguments hiveArguments) {
        this.hiveArguments = hiveArguments;
    }

    public ApiReplicationSchedule hdfsCloudArguments(ApiHdfsCloudReplicationArguments hdfsCloudArguments) {
        this.hdfsCloudArguments = hdfsCloudArguments;
        return this;
    }

    @Schema(description="")
    public ApiHdfsCloudReplicationArguments getHdfsCloudArguments() {
        return this.hdfsCloudArguments;
    }

    public void setHdfsCloudArguments(ApiHdfsCloudReplicationArguments hdfsCloudArguments) {
        this.hdfsCloudArguments = hdfsCloudArguments;
    }

    public ApiReplicationSchedule ozoneReplicationArguments(ApiOzoneReplicationArguments ozoneReplicationArguments) {
        this.ozoneReplicationArguments = ozoneReplicationArguments;
        return this;
    }

    @Schema(description="")
    public ApiOzoneReplicationArguments getOzoneReplicationArguments() {
        return this.ozoneReplicationArguments;
    }

    public void setOzoneReplicationArguments(ApiOzoneReplicationArguments ozoneReplicationArguments) {
        this.ozoneReplicationArguments = ozoneReplicationArguments;
    }

    public ApiReplicationSchedule history(List<ApiReplicationCommand> history) {
        this.history = history;
        return this;
    }

    public ApiReplicationSchedule addHistoryItem(ApiReplicationCommand historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<ApiReplicationCommand>();
        }
        this.history.add(historyItem);
        return this;
    }

    @Schema(description="List of active and/or finished commands for this schedule.")
    public List<ApiReplicationCommand> getHistory() {
        return this.history;
    }

    public void setHistory(List<ApiReplicationCommand> history) {
        this.history = history;
    }

    public ApiReplicationSchedule active(Boolean active) {
        this.active = active;
        return this;
    }

    @Schema(description="Read-only field that is true if this schedule is currently active, false if not. Available since API v11.")
    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ApiReplicationSchedule hiveCloudArguments(ApiHiveCloudReplicationArguments hiveCloudArguments) {
        this.hiveCloudArguments = hiveCloudArguments;
        return this;
    }

    @Schema(description="")
    public ApiHiveCloudReplicationArguments getHiveCloudArguments() {
        return this.hiveCloudArguments;
    }

    public void setHiveCloudArguments(ApiHiveCloudReplicationArguments hiveCloudArguments) {
        this.hiveCloudArguments = hiveCloudArguments;
    }

    public ApiReplicationSchedule hbaseArguments(ApiHBaseReplicationArguments hbaseArguments) {
        this.hbaseArguments = hbaseArguments;
        return this;
    }

    @Schema(description="")
    public ApiHBaseReplicationArguments getHbaseArguments() {
        return this.hbaseArguments;
    }

    public void setHbaseArguments(ApiHBaseReplicationArguments hbaseArguments) {
        this.hbaseArguments = hbaseArguments;
    }

    public ApiReplicationSchedule hive3Arguments(ApiHive3ReplicationArguments hive3Arguments) {
        this.hive3Arguments = hive3Arguments;
        return this;
    }

    @Schema(description="")
    public ApiHive3ReplicationArguments getHive3Arguments() {
        return this.hive3Arguments;
    }

    public void setHive3Arguments(ApiHive3ReplicationArguments hive3Arguments) {
        this.hive3Arguments = hive3Arguments;
    }

    public ApiReplicationSchedule rangerArguments(ApiRangerReplicationArgs rangerArguments) {
        this.rangerArguments = rangerArguments;
        return this;
    }

    @Schema(description="")
    public ApiRangerReplicationArgs getRangerArguments() {
        return this.rangerArguments;
    }

    public void setRangerArguments(ApiRangerReplicationArgs rangerArguments) {
        this.rangerArguments = rangerArguments;
    }

    public ApiReplicationSchedule icebergArguments(ApiIcebergReplicationArguments icebergArguments) {
        this.icebergArguments = icebergArguments;
        return this;
    }

    @Schema(description="")
    public ApiIcebergReplicationArguments getIcebergArguments() {
        return this.icebergArguments;
    }

    public void setIcebergArguments(ApiIcebergReplicationArguments icebergArguments) {
        this.icebergArguments = icebergArguments;
    }

    public ApiReplicationSchedule atlasReplicationArguments(ApiAtlasReplicationArguments atlasReplicationArguments) {
        this.atlasReplicationArguments = atlasReplicationArguments;
        return this;
    }

    @Schema(description="")
    public ApiAtlasReplicationArguments getAtlasReplicationArguments() {
        return this.atlasReplicationArguments;
    }

    public void setAtlasReplicationArguments(ApiAtlasReplicationArguments atlasReplicationArguments) {
        this.atlasReplicationArguments = atlasReplicationArguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiReplicationSchedule apiReplicationSchedule = (ApiReplicationSchedule)o;
        return Objects.equals(this.hdfsArguments, apiReplicationSchedule.hdfsArguments) && Objects.equals(this.hiveArguments, apiReplicationSchedule.hiveArguments) && Objects.equals(this.hdfsCloudArguments, apiReplicationSchedule.hdfsCloudArguments) && Objects.equals(this.ozoneReplicationArguments, apiReplicationSchedule.ozoneReplicationArguments) && Objects.equals(this.history, apiReplicationSchedule.history) && Objects.equals(this.active, apiReplicationSchedule.active) && Objects.equals(this.hiveCloudArguments, apiReplicationSchedule.hiveCloudArguments) && Objects.equals(this.hbaseArguments, apiReplicationSchedule.hbaseArguments) && Objects.equals(this.hive3Arguments, apiReplicationSchedule.hive3Arguments) && Objects.equals(this.rangerArguments, apiReplicationSchedule.rangerArguments) && Objects.equals(this.icebergArguments, apiReplicationSchedule.icebergArguments) && Objects.equals(this.atlasReplicationArguments, apiReplicationSchedule.atlasReplicationArguments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hdfsArguments, this.hiveArguments, this.hdfsCloudArguments, this.ozoneReplicationArguments, this.history, this.active, this.hiveCloudArguments, this.hbaseArguments, this.hive3Arguments, this.rangerArguments, this.icebergArguments, this.atlasReplicationArguments, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiReplicationSchedule {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    hdfsArguments: ").append(this.toIndentedString(this.hdfsArguments)).append("\n");
        sb.append("    hiveArguments: ").append(this.toIndentedString(this.hiveArguments)).append("\n");
        sb.append("    hdfsCloudArguments: ").append(this.toIndentedString(this.hdfsCloudArguments)).append("\n");
        sb.append("    ozoneReplicationArguments: ").append(this.toIndentedString(this.ozoneReplicationArguments)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    hiveCloudArguments: ").append(this.toIndentedString(this.hiveCloudArguments)).append("\n");
        sb.append("    hbaseArguments: ").append(this.toIndentedString(this.hbaseArguments)).append("\n");
        sb.append("    hive3Arguments: ").append(this.toIndentedString(this.hive3Arguments)).append("\n");
        sb.append("    rangerArguments: ").append(this.toIndentedString(this.rangerArguments)).append("\n");
        sb.append("    icebergArguments: ").append(this.toIndentedString(this.icebergArguments)).append("\n");
        sb.append("    atlasReplicationArguments: ").append(this.toIndentedString(this.atlasReplicationArguments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

