/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.flink;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class FlinkServiceModelGenerator
extends AbstractServiceModelGenerator {
    static final String SERVICE = "FLINK";
    static final String SERVICE_TYPE = "FLINK";
    static final String ROLE_TYPE = "FLINK_HISTORY_SERVER";
    static final String SSL_ENABLED = "ssl_enabled";
    static final String WEB_PORT = "historyserver_web_port";

    @Override
    public String getService() {
        return "FLINK";
    }

    @Override
    public String getServiceType() {
        return "FLINK";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, WEB_PORT);
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : "http";
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, Boolean.toString(sslEnabled));
        model.addRoleProperty(this.getRoleType(), WEB_PORT, port);
        return model;
    }
}

