/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.metatype.DefaultMetaTypeProvider;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.DesignateObject;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.OCD;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeInformationImpl
implements MetaTypeInformation {
    private final Bundle bundle;
    private final Set pids;
    private final Set factoryPids;
    private final Map metaTypeProviders;
    private Set locales;

    protected MetaTypeInformationImpl(Bundle bundle) {
        this.bundle = bundle;
        this.pids = new HashSet();
        this.factoryPids = new HashSet();
        this.metaTypeProviders = new HashMap();
    }

    void dispose() {
        this.pids.clear();
        this.factoryPids.clear();
        this.locales = null;
        this.metaTypeProviders.clear();
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public String[] getFactoryPids() {
        return this.factoryPids.toArray(new String[this.factoryPids.size()]);
    }

    @Override
    public String[] getPids() {
        return this.pids.toArray(new String[this.pids.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLocales() {
        if (this.locales == null) {
            MetaTypeInformationImpl metaTypeInformationImpl = this;
            synchronized (metaTypeInformationImpl) {
                HashSet newLocales = new HashSet();
                for (MetaTypeProvider mtp : this.metaTypeProviders.values()) {
                    this.addValues(newLocales, mtp.getLocales());
                }
                this.locales = newLocales;
            }
        }
        return this.locales.toArray(new String[this.locales.size()]);
    }

    @Override
    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("ObjectClassDefinition ID must not be null or empty");
        }
        MetaTypeProvider mtp = (MetaTypeProvider)this.metaTypeProviders.get(id);
        if (mtp == null) {
            throw new IllegalArgumentException("No ObjectClassDefinition for id=" + id);
        }
        ObjectClassDefinition ocd = mtp.getObjectClassDefinition(id, locale);
        if (ocd == null) {
            throw new IllegalArgumentException("No localized ObjectClassDefinition for id=" + id);
        }
        return ocd;
    }

    Designate getDesignate(String pid) {
        Object mto = this.metaTypeProviders.get(pid);
        if (mto instanceof DefaultMetaTypeProvider) {
            return ((DefaultMetaTypeProvider)mto).getDesignate(pid);
        }
        return null;
    }

    protected void addMetaData(MetaData md) {
        if (md.getDesignates() != null) {
            DefaultMetaTypeProvider dmtp = new DefaultMetaTypeProvider(this.bundle, md);
            for (Designate designate : md.getDesignates()) {
                Map map;
                OCD ocd;
                DesignateObject object = designate.getObject();
                String ocdRef = object == null ? null : object.getOcdRef();
                if (ocdRef == null || (ocd = (OCD)((map = md.getObjectClassDefinitions()) == null ? null : map.get(ocdRef))) == null) continue;
                if (designate.getFactoryPid() != null) {
                    this.factoryPids.add(designate.getFactoryPid());
                    this.addMetaTypeProvider(designate.getFactoryPid(), dmtp);
                    continue;
                }
                this.pids.add(designate.getPid());
                this.addMetaTypeProvider(designate.getPid(), dmtp);
            }
        }
    }

    protected void addMetaTypeProvider(String key, MetaTypeProvider mtp) {
        if (key != null && mtp != null) {
            this.metaTypeProviders.put(key, mtp);
            this.locales = null;
        }
    }

    protected MetaTypeProvider removeMetaTypeProvider(String key) {
        if (key != null) {
            this.locales = null;
            return (MetaTypeProvider)this.metaTypeProviders.remove(key);
        }
        return null;
    }

    protected void addSingletonMetaTypeProvider(String[] pids, MetaTypeProvider mtp) {
        this.addValues(this.pids, pids);
        for (int i = 0; i < pids.length; ++i) {
            this.addMetaTypeProvider(pids[i], mtp);
        }
    }

    protected void addFactoryMetaTypeProvider(String[] factoryPids, MetaTypeProvider mtp) {
        this.addValues(this.factoryPids, factoryPids);
        for (int i = 0; i < factoryPids.length; ++i) {
            this.addMetaTypeProvider(factoryPids[i], mtp);
        }
    }

    protected boolean removeSingletonMetaTypeProvider(String[] pids) {
        boolean wasRegistered = false;
        for (int i = 0; i < pids.length; ++i) {
            wasRegistered |= this.removeMetaTypeProvider(pids[i]) != null;
            this.pids.remove(pids[i]);
        }
        return wasRegistered;
    }

    protected boolean removeFactoryMetaTypeProvider(String[] factoryPids) {
        boolean wasRegistered = false;
        for (int i = 0; i < factoryPids.length; ++i) {
            wasRegistered |= this.removeMetaTypeProvider(factoryPids[i]) != null;
            this.factoryPids.remove(factoryPids[i]);
        }
        return wasRegistered;
    }

    protected void addService(String[] pids, boolean isSingleton, boolean isFactory, MetaTypeProvider mtp) {
    }

    protected void removeService(String[] pids, boolean isSingleton, boolean isFactory) {
    }

    private void addValues(Collection dest, Object[] values) {
        if (values != null && values.length > 0) {
            dest.addAll(Arrays.asList(values));
        }
    }
}

