/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.FailedPromiseImpl;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.PromiseImpl;
import org.osgi.util.promise.Success;
import org.osgi.util.promise.TimeoutException;

final class DeferredPromiseImpl<T>
extends PromiseImpl<T> {
    private final CountDownLatch resolved = new CountDownLatch(1);
    private T value;
    private Throwable fail;

    DeferredPromiseImpl(PromiseFactory factory) {
        super(factory);
    }

    @Override
    public boolean isDone() {
        return this.resolved.getCount() == 0L;
    }

    PromiseImpl<T> orDone() {
        if (!this.isDone()) {
            return this;
        }
        if (this.fail == null) {
            return this.resolved(this.value);
        }
        return this.failed(this.fail);
    }

    @Override
    public T getValue() throws InvocationTargetException, InterruptedException {
        this.resolved.await();
        if (this.fail == null) {
            return this.value;
        }
        throw new InvocationTargetException(this.fail);
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        this.resolved.await();
        return this.fail;
    }

    @Override
    void result(PromiseImpl.Result<? super T> consumer) {
        if (!this.isDone()) {
            consumer.accept(null, (Throwable)((Object)new AssertionError((Object)"promise not resolved")));
            return;
        }
        consumer.accept(this.value, this.fail);
    }

    public String toString() {
        if (!this.isDone()) {
            return super.toString() + "[unresolved]";
        }
        if (this.fail == null) {
            return super.toString() + "[resolved: " + this.value + "]";
        }
        return super.toString() + "[failed: " + this.fail + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryResolve(T v, Throwable f) {
        CountDownLatch countDownLatch = this.resolved;
        synchronized (countDownLatch) {
            if (this.isDone()) {
                return false;
            }
            if (f == null) {
                this.value = v;
            } else {
                this.fail = f;
            }
            this.resolved.countDown();
        }
        this.notifyCallbacks();
        return true;
    }

    void resolve(T v, Throwable f) {
        if (!this.tryResolve(v, f)) {
            throw new IllegalStateException("Already resolved");
        }
    }

    Promise<Void> resolveWith(Promise<? extends T> with) {
        DeferredPromiseImpl<Void> chained = this.deferred();
        with.onResolve(new ResolveWith(with, chained));
        return chained.orDone();
    }

    Promise<Void> resolveWith(CompletionStage<? extends T> with) {
        DeferredPromiseImpl<Void> chained = this.deferred();
        with.whenComplete(new ResolveWith(chained));
        return chained.orDone();
    }

    private final class ResolveWith
    implements Runnable,
    PromiseImpl.InlineCallback,
    PromiseImpl.Result<T>,
    BiConsumer<T, Throwable> {
        private final Promise<? extends T> with;
        private final DeferredPromiseImpl<Void> promise;

        ResolveWith(Promise<? extends T> with, DeferredPromiseImpl<Void> promise) {
            this.with = Objects.requireNonNull(with);
            this.promise = Objects.requireNonNull(promise);
        }

        ResolveWith(DeferredPromiseImpl<Void> promise) {
            this.with = null;
            this.promise = Objects.requireNonNull(promise);
        }

        @Override
        public void run() {
            PromiseImpl.result(this.with, this);
        }

        @Override
        public void accept(T v, Throwable f) {
            try {
                DeferredPromiseImpl.this.resolve(v, f);
                f = null;
            }
            catch (Throwable e) {
                f = e;
            }
            this.promise.tryResolve(null, f);
        }
    }

    final class Submit
    implements Runnable {
        private final Callable<? extends T> task;

        Submit(Callable<? extends T> task) {
            this.task = Objects.requireNonNull(task);
        }

        @Override
        public void run() {
            Throwable f;
            Object v;
            try {
                v = this.task.call();
                f = null;
            }
            catch (Throwable e) {
                f = e;
                v = null;
            }
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class Delay
    implements Runnable,
    PromiseImpl.InlineCallback {
        private final Runnable operation;
        private final long millis;

        Delay(PromiseImpl<T> promise, long millis) {
            this.operation = new ChainImpl(promise);
            this.millis = millis;
        }

        @Override
        public void run() {
            DeferredPromiseImpl.this.schedule(this.operation, this.millis, TimeUnit.MILLISECONDS);
        }
    }

    final class Timeout
    implements Runnable,
    PromiseImpl.InlineCallback,
    PromiseImpl.Result<T> {
        private final PromiseImpl<T> promise;
        private final ScheduledFuture<?> future;

        Timeout(PromiseImpl<T> promise, long millis) {
            this.promise = Objects.requireNonNull(promise);
            if (promise.isDone()) {
                this.future = null;
            } else {
                FailedPromiseImpl timedout = DeferredPromiseImpl.this.failed(new TimeoutException());
                ChainImpl operation = new ChainImpl(timedout);
                this.future = DeferredPromiseImpl.this.schedule(operation, millis, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            DeferredPromiseImpl.this.tryResolve(v, f);
            if (this.future != null) {
                this.future.cancel(false);
            }
        }
    }

    private final class FallbackChain
    implements Runnable,
    PromiseImpl.InlineCallback,
    PromiseImpl.Result<T> {
        private final Promise<? extends T> fallback;
        private final Throwable failure;

        FallbackChain(Promise<? extends T> fallback, Throwable failure) {
            this.fallback = Objects.requireNonNull(fallback);
            this.failure = Objects.requireNonNull(failure);
        }

        @Override
        public void run() {
            PromiseImpl.result(this.fallback, this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f != null) {
                f = this.failure;
            }
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class FallbackTo
    implements Runnable,
    PromiseImpl.InlineCallback,
    PromiseImpl.Result<T> {
        private final PromiseImpl<T> promise;
        private final Promise<? extends T> fallback;
        private final Class<?> failureType;

        FallbackTo(PromiseImpl<T> promise, Promise<? extends T> fallback, Class<?> failureType) {
            this.promise = Objects.requireNonNull(promise);
            this.fallback = Objects.requireNonNull(fallback);
            this.failureType = Objects.requireNonNull(failureType);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (this.failureType.isInstance(f)) {
                this.fallback.onResolve(new FallbackChain(this.fallback, f));
                return;
            }
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class RecoverWith
    implements Runnable,
    PromiseImpl.Result<T> {
        private final PromiseImpl<T> promise;
        private final Function<Promise<?>, Promise<? extends T>> recovery;
        private final Class<?> failureType;

        RecoverWith(PromiseImpl<T> promise, Function<Promise<?>, Promise<? extends T>> recovery, Class<?> failureType) {
            this.promise = Objects.requireNonNull(promise);
            this.recovery = Objects.requireNonNull(recovery);
            this.failureType = Objects.requireNonNull(failureType);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (this.failureType.isInstance(f)) {
                Promise recovered = null;
                try {
                    recovered = this.recovery.apply(this.promise);
                }
                catch (Throwable e) {
                    f = e;
                }
                if (recovered != null) {
                    recovered.onResolve(new Chain(recovered));
                    return;
                }
            }
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class Recover
    implements Runnable,
    PromiseImpl.Result<T> {
        private final PromiseImpl<T> promise;
        private final Function<Promise<?>, ? extends T> recovery;
        private final Class<?> failureType;

        Recover(PromiseImpl<T> promise, Function<Promise<?>, ? extends T> recovery, Class<?> failureType) {
            this.promise = Objects.requireNonNull(promise);
            this.recovery = Objects.requireNonNull(recovery);
            this.failureType = Objects.requireNonNull(failureType);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (this.failureType.isInstance(f)) {
                try {
                    v = this.recovery.apply(this.promise);
                    if (v != null) {
                        f = null;
                    }
                }
                catch (Throwable e) {
                    f = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class FlatMap<P>
    implements Runnable,
    PromiseImpl.Result<P> {
        private final PromiseImpl<P> promise;
        private final Function<? super P, Promise<? extends T>> mapper;

        FlatMap(PromiseImpl<P> promise, Function<? super P, Promise<? extends T>> mapper) {
            this.promise = Objects.requireNonNull(promise);
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(P v, Throwable f) {
            if (f == null) {
                Promise flatmap = null;
                try {
                    flatmap = this.mapper.apply(v);
                }
                catch (Throwable e) {
                    f = e;
                }
                if (flatmap != null) {
                    flatmap.onResolve(new Chain(flatmap));
                    return;
                }
            }
            DeferredPromiseImpl.this.tryResolve(null, f);
        }
    }

    final class Map<P>
    implements Runnable,
    PromiseImpl.Result<P> {
        private final PromiseImpl<P> promise;
        private final Function<? super P, ? extends T> mapper;

        Map(PromiseImpl<P> promise, Function<? super P, ? extends T> mapper) {
            this.promise = Objects.requireNonNull(promise);
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(P v, Throwable f) {
            Object map = null;
            if (f == null) {
                try {
                    map = this.mapper.apply(v);
                }
                catch (Throwable e) {
                    f = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(map, f);
        }
    }

    final class Filter
    implements Runnable,
    PromiseImpl.Result<T> {
        private final PromiseImpl<T> promise;
        private final Predicate<? super T> predicate;

        Filter(PromiseImpl<T> promise, Predicate<? super T> predicate) {
            this.promise = Objects.requireNonNull(promise);
            this.predicate = Objects.requireNonNull(predicate);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f == null) {
                try {
                    if (!this.predicate.test(v)) {
                        f = new NoSuchElementException();
                    }
                }
                catch (Throwable e) {
                    f = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class ThenAccept
    implements Runnable,
    PromiseImpl.Result<T> {
        private final PromiseImpl<T> promise;
        private final Consumer<? super T> consumer;

        ThenAccept(PromiseImpl<T> promise, Consumer<? super T> consumer) {
            this.promise = Objects.requireNonNull(promise);
            this.consumer = Objects.requireNonNull(consumer);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f == null) {
                try {
                    this.consumer.accept(v);
                }
                catch (Throwable e) {
                    f = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    private final class ChainImpl
    implements Runnable,
    PromiseImpl.InlineCallback,
    PromiseImpl.Result<T> {
        private final PromiseImpl<T> promise;

        ChainImpl(PromiseImpl<T> promise) {
            this.promise = Objects.requireNonNull(promise);
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class Chain
    implements Runnable,
    PromiseImpl.InlineCallback,
    PromiseImpl.Result<T> {
        private final Promise<? extends T> promise;

        Chain(Promise<? extends T> promise) {
            this.promise = Objects.requireNonNull(promise);
        }

        @Override
        public void run() {
            PromiseImpl.result(this.promise, this);
        }

        @Override
        public void accept(T v, Throwable f) {
            DeferredPromiseImpl.this.tryResolve(v, f);
        }
    }

    final class Then<P>
    implements Runnable,
    PromiseImpl.Result<P> {
        private final PromiseImpl<P> promise;
        private final Success<P, ? extends T> success;
        private final Failure failure;

        Then(PromiseImpl<P> promise, Success<? super P, ? extends T> success, Failure failure) {
            this.promise = Objects.requireNonNull(promise);
            this.success = success;
            this.failure = failure;
        }

        @Override
        public void run() {
            this.promise.result(this);
        }

        @Override
        public void accept(P v, Throwable f) {
            if (f != null) {
                if (this.failure != null) {
                    try {
                        this.failure.fail(this.promise);
                    }
                    catch (Throwable e) {
                        f = e;
                    }
                }
            } else if (this.success != null) {
                Promise returned = null;
                try {
                    returned = this.success.call(this.promise);
                }
                catch (Throwable e) {
                    f = e;
                }
                if (returned != null) {
                    returned.onResolve(new Chain(returned));
                    return;
                }
            }
            DeferredPromiseImpl.this.tryResolve(null, f);
        }
    }
}

