/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.utils.repository.BaseRepository;
import org.apache.karaf.features.internal.repository.JsonRepository;
import org.apache.karaf.features.internal.repository.XmlRepository;

public class RepositoryManager {
    private final ConcurrentMap<String, BaseRepository> repositories = new ConcurrentHashMap<String, BaseRepository>();

    public BaseRepository getRepository(String base, String uri) {
        BaseRepository repo;
        if (uri.startsWith("xml:")) {
            String u = URI.create(base).resolve(uri.substring("xml:".length())).toString();
            uri = "xml:" + u;
            repo = new XmlRepository(u, 0L, false);
        } else if (uri.startsWith("json:")) {
            String u = URI.create(base).resolve(uri.substring("json:".length())).toString();
            uri = "json:" + u;
            repo = new JsonRepository(u, 0L, false);
        } else {
            String u = URI.create(base).resolve(uri).toString();
            uri = "xml:" + u;
            repo = new XmlRepository(u, 0L, false);
        }
        this.repositories.putIfAbsent(uri, repo);
        return (BaseRepository)this.repositories.get(uri);
    }
}

