/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;

public class ConsumerGroupMember
extends ModernGroupMember {
    private int rebalanceTimeoutMs;
    private final String subscribedTopicRegex;
    private final String serverAssignorName;
    private final Map<Uuid, Set<Integer>> partitionsPendingRevocation;
    private final ConsumerGroupMemberMetadataValue.ClassicMemberMetadata classicMemberMetadata;

    private ConsumerGroupMember(String memberId, int memberEpoch, int previousMemberEpoch, String instanceId, String rackId, int rebalanceTimeoutMs, String clientId, String clientHost, Set<String> subscribedTopicNames, String subscribedTopicRegex, String serverAssignorName, MemberState state, Map<Uuid, Set<Integer>> assignedPartitions, Map<Uuid, Set<Integer>> partitionsPendingRevocation, ConsumerGroupMemberMetadataValue.ClassicMemberMetadata classicMemberMetadata) {
        super(memberId, memberEpoch, previousMemberEpoch, instanceId, rackId, clientId, clientHost, subscribedTopicNames, state, assignedPartitions);
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.subscribedTopicRegex = subscribedTopicRegex;
        this.serverAssignorName = serverAssignorName;
        this.partitionsPendingRevocation = partitionsPendingRevocation;
        this.classicMemberMetadata = classicMemberMetadata;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public String subscribedTopicRegex() {
        return this.subscribedTopicRegex;
    }

    public Optional<String> serverAssignorName() {
        return Optional.ofNullable(this.serverAssignorName);
    }

    public Map<Uuid, Set<Integer>> partitionsPendingRevocation() {
        return this.partitionsPendingRevocation;
    }

    public JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedJoinGroupRequestProtocols() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        this.supportedClassicProtocols().ifPresent(classicProtocols -> classicProtocols.forEach(protocol -> protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName(protocol.name()).setMetadata(protocol.metadata()))));
        return protocols;
    }

    public Optional<Integer> classicProtocolSessionTimeout() {
        if (this.useClassicProtocol()) {
            return Optional.ofNullable(this.classicMemberMetadata.sessionTimeoutMs());
        }
        return Optional.empty();
    }

    public Optional<ConsumerGroupMemberMetadataValue.ClassicMemberMetadata> classicMemberMetadata() {
        return Optional.ofNullable(this.classicMemberMetadata);
    }

    public Optional<List<ConsumerGroupMemberMetadataValue.ClassicProtocol>> supportedClassicProtocols() {
        if (this.useClassicProtocol()) {
            return Optional.ofNullable(this.classicMemberMetadata.supportedProtocols());
        }
        return Optional.empty();
    }

    public ConsumerGroupDescribeResponseData.Member asConsumerGroupDescribeMember(Assignment targetAssignment, TopicsImage topicsImage) {
        return new ConsumerGroupDescribeResponseData.Member().setMemberEpoch(this.memberEpoch).setMemberId(this.memberId).setAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(ConsumerGroupMember.topicPartitionsFromMap(this.assignedPartitions, topicsImage))).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(ConsumerGroupMember.topicPartitionsFromMap(targetAssignment != null ? targetAssignment.partitions() : Collections.emptyMap(), topicsImage))).setClientHost(this.clientHost).setClientId(this.clientId).setInstanceId(this.instanceId).setRackId(this.rackId).setSubscribedTopicNames((List)(this.subscribedTopicNames == null ? null : new ArrayList(this.subscribedTopicNames))).setSubscribedTopicRegex(this.subscribedTopicRegex);
    }

    private static List<ConsumerGroupDescribeResponseData.TopicPartitions> topicPartitionsFromMap(Map<Uuid, Set<Integer>> partitions, TopicsImage topicsImage) {
        ArrayList<ConsumerGroupDescribeResponseData.TopicPartitions> topicPartitions = new ArrayList<ConsumerGroupDescribeResponseData.TopicPartitions>();
        partitions.forEach((topicId, partitionSet) -> {
            TopicImage topicImage = topicsImage.getTopic(topicId);
            if (topicImage != null) {
                topicPartitions.add(new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName(topicImage.name()).setPartitions(new ArrayList(partitionSet)));
            }
        });
        return topicPartitions;
    }

    public static List<ConsumerGroupMemberMetadataValue.ClassicProtocol> classicProtocolListFromJoinRequestProtocolCollection(JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols) {
        ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol> newSupportedProtocols = new ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol>();
        protocols.forEach(protocol -> newSupportedProtocols.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName(protocol.name()).setMetadata(protocol.metadata())));
        return newSupportedProtocols;
    }

    public boolean useClassicProtocol() {
        return this.classicMemberMetadata != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupMember that = (ConsumerGroupMember)o;
        return this.memberEpoch == that.memberEpoch && this.previousMemberEpoch == that.previousMemberEpoch && this.state == that.state && this.rebalanceTimeoutMs == that.rebalanceTimeoutMs && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.rackId, that.rackId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientHost, that.clientHost) && Objects.equals(this.subscribedTopicNames, that.subscribedTopicNames) && Objects.equals(this.subscribedTopicRegex, that.subscribedTopicRegex) && Objects.equals(this.serverAssignorName, that.serverAssignorName) && Objects.equals(this.assignedPartitions, that.assignedPartitions) && Objects.equals(this.partitionsPendingRevocation, that.partitionsPendingRevocation) && Objects.equals(this.classicMemberMetadata, that.classicMemberMetadata);
    }

    public int hashCode() {
        int result = this.memberId != null ? this.memberId.hashCode() : 0;
        result = 31 * result + this.memberEpoch;
        result = 31 * result + this.previousMemberEpoch;
        result = 31 * result + Objects.hashCode((Object)this.state);
        result = 31 * result + Objects.hashCode(this.instanceId);
        result = 31 * result + Objects.hashCode(this.rackId);
        result = 31 * result + this.rebalanceTimeoutMs;
        result = 31 * result + Objects.hashCode(this.clientId);
        result = 31 * result + Objects.hashCode(this.clientHost);
        result = 31 * result + Objects.hashCode(this.subscribedTopicNames);
        result = 31 * result + Objects.hashCode(this.subscribedTopicRegex);
        result = 31 * result + Objects.hashCode(this.serverAssignorName);
        result = 31 * result + Objects.hashCode(this.assignedPartitions);
        result = 31 * result + Objects.hashCode(this.partitionsPendingRevocation);
        result = 31 * result + Objects.hashCode(this.classicMemberMetadata);
        return result;
    }

    public String toString() {
        return "ConsumerGroupMember(memberId='" + this.memberId + '\'' + ", memberEpoch=" + this.memberEpoch + ", previousMemberEpoch=" + this.previousMemberEpoch + ", state='" + (Object)((Object)this.state) + '\'' + ", instanceId='" + this.instanceId + '\'' + ", rackId='" + this.rackId + '\'' + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", clientId='" + this.clientId + '\'' + ", clientHost='" + this.clientHost + '\'' + ", subscribedTopicNames=" + this.subscribedTopicNames + ", subscribedTopicRegex='" + this.subscribedTopicRegex + '\'' + ", serverAssignorName='" + this.serverAssignorName + '\'' + ", assignedPartitions=" + this.assignedPartitions + ", partitionsPendingRevocation=" + this.partitionsPendingRevocation + ", classicMemberMetadata='" + this.classicMemberMetadata + '\'' + ')';
    }

    public static class Builder {
        private final String memberId;
        private int memberEpoch = 0;
        private int previousMemberEpoch = -1;
        private MemberState state = MemberState.STABLE;
        private String instanceId = null;
        private String rackId = null;
        private int rebalanceTimeoutMs = -1;
        private String clientId = "";
        private String clientHost = "";
        private Set<String> subscribedTopicNames = Collections.emptySet();
        private String subscribedTopicRegex = "";
        private String serverAssignorName = null;
        private Map<Uuid, Set<Integer>> assignedPartitions = Collections.emptyMap();
        private Map<Uuid, Set<Integer>> partitionsPendingRevocation = Collections.emptyMap();
        private ConsumerGroupMemberMetadataValue.ClassicMemberMetadata classicMemberMetadata = null;

        public Builder(String memberId) {
            this.memberId = Objects.requireNonNull(memberId);
        }

        public Builder(ConsumerGroupMember member) {
            this(Objects.requireNonNull(member), member.memberId);
        }

        public Builder(ConsumerGroupMember member, String newMemberId) {
            Objects.requireNonNull(member);
            this.memberId = Objects.requireNonNull(newMemberId);
            this.memberEpoch = member.memberEpoch;
            this.previousMemberEpoch = member.previousMemberEpoch;
            this.instanceId = member.instanceId;
            this.rackId = member.rackId;
            this.rebalanceTimeoutMs = member.rebalanceTimeoutMs;
            this.clientId = member.clientId;
            this.clientHost = member.clientHost;
            this.subscribedTopicNames = member.subscribedTopicNames;
            this.subscribedTopicRegex = member.subscribedTopicRegex;
            this.serverAssignorName = member.serverAssignorName;
            this.state = member.state;
            this.assignedPartitions = member.assignedPartitions;
            this.partitionsPendingRevocation = member.partitionsPendingRevocation;
            this.classicMemberMetadata = member.classicMemberMetadata;
        }

        public Builder updateMemberEpoch(int memberEpoch) {
            int currentMemberEpoch = this.memberEpoch;
            this.memberEpoch = memberEpoch;
            this.previousMemberEpoch = currentMemberEpoch;
            return this;
        }

        public Builder setMemberEpoch(int memberEpoch) {
            this.memberEpoch = memberEpoch;
            return this;
        }

        public Builder setPreviousMemberEpoch(int previousMemberEpoch) {
            this.previousMemberEpoch = previousMemberEpoch;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder maybeUpdateInstanceId(Optional<String> instanceId) {
            this.instanceId = instanceId.orElse(this.instanceId);
            return this;
        }

        public Builder setRackId(String rackId) {
            this.rackId = rackId;
            return this;
        }

        public Builder maybeUpdateRackId(Optional<String> rackId) {
            this.rackId = rackId.orElse(this.rackId);
            return this;
        }

        public Builder setRebalanceTimeoutMs(int rebalanceTimeoutMs) {
            this.rebalanceTimeoutMs = rebalanceTimeoutMs;
            return this;
        }

        public Builder maybeUpdateRebalanceTimeoutMs(OptionalInt rebalanceTimeoutMs) {
            this.rebalanceTimeoutMs = rebalanceTimeoutMs.orElse(this.rebalanceTimeoutMs);
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientHost(String clientHost) {
            this.clientHost = clientHost;
            return this;
        }

        public Builder setSubscribedTopicNames(List<String> subscribedTopicList) {
            if (this.subscribedTopicNames != null) {
                this.subscribedTopicNames = new HashSet<String>(subscribedTopicList);
            }
            return this;
        }

        public Builder maybeUpdateSubscribedTopicNames(Optional<List<String>> subscribedTopicList) {
            subscribedTopicList.ifPresent(list -> {
                this.subscribedTopicNames = new HashSet<String>((Collection<String>)list);
            });
            return this;
        }

        public Builder setSubscribedTopicRegex(String subscribedTopicRegex) {
            this.subscribedTopicRegex = subscribedTopicRegex;
            return this;
        }

        public Builder maybeUpdateSubscribedTopicRegex(Optional<String> subscribedTopicRegex) {
            this.subscribedTopicRegex = subscribedTopicRegex.orElse(this.subscribedTopicRegex);
            return this;
        }

        public Builder setServerAssignorName(String serverAssignorName) {
            this.serverAssignorName = serverAssignorName;
            return this;
        }

        public Builder maybeUpdateServerAssignorName(Optional<String> serverAssignorName) {
            this.serverAssignorName = serverAssignorName.orElse(this.serverAssignorName);
            return this;
        }

        public Builder setState(MemberState state) {
            this.state = state;
            return this;
        }

        public Builder setAssignedPartitions(Map<Uuid, Set<Integer>> assignedPartitions) {
            this.assignedPartitions = assignedPartitions;
            return this;
        }

        public Builder setPartitionsPendingRevocation(Map<Uuid, Set<Integer>> partitionsPendingRevocation) {
            this.partitionsPendingRevocation = partitionsPendingRevocation;
            return this;
        }

        public Builder setClassicMemberMetadata(ConsumerGroupMemberMetadataValue.ClassicMemberMetadata classicMemberMetadata) {
            this.classicMemberMetadata = classicMemberMetadata;
            return this;
        }

        public Builder updateWith(ConsumerGroupMemberMetadataValue record) {
            this.setInstanceId(record.instanceId());
            this.setRackId(record.rackId());
            this.setClientId(record.clientId());
            this.setClientHost(record.clientHost());
            this.setSubscribedTopicNames(record.subscribedTopicNames());
            this.setSubscribedTopicRegex(record.subscribedTopicRegex());
            this.setRebalanceTimeoutMs(record.rebalanceTimeoutMs());
            this.setServerAssignorName(record.serverAssignor());
            this.setClassicMemberMetadata(record.classicMemberMetadata());
            return this;
        }

        public Builder updateWith(ConsumerGroupCurrentMemberAssignmentValue record) {
            this.setMemberEpoch(record.memberEpoch());
            this.setPreviousMemberEpoch(record.previousMemberEpoch());
            this.setState(MemberState.fromValue(record.state()));
            this.setAssignedPartitions(Utils.assignmentFromTopicPartitions(record.assignedPartitions()));
            this.setPartitionsPendingRevocation(Utils.assignmentFromTopicPartitions(record.partitionsPendingRevocation()));
            return this;
        }

        public ConsumerGroupMember build() {
            return new ConsumerGroupMember(this.memberId, this.memberEpoch, this.previousMemberEpoch, this.instanceId, this.rackId, this.rebalanceTimeoutMs, this.clientId, this.clientHost, this.subscribedTopicNames, this.subscribedTopicRegex, this.serverAssignorName, this.state, this.assignedPartitions, this.partitionsPendingRevocation, this.classicMemberMetadata);
        }
    }
}

