/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaMetadataLog$FullTruncation$;
import kafka.raft.KafkaMetadataLog$UnknownReason$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.NotifyingRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011}e\u0001\u0002;v\u0005iD!\"a\n\u0001\u0005\u000b\u0007I\u0011AA\u0015\u0011)\t)\u0004\u0001B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003o\u0001!\u0011!Q\u0001\n\u0005e\u0002BCA$\u0001\t\u0005\t\u0015!\u0003\u0002J!Q\u0011\u0011\f\u0001\u0003\u0002\u0003\u0006I!a\u0017\t\u0015\u0005%\u0005A!A!\u0002\u0013\tY\t\u0003\u0006\u0002\u0014\u0002\u0011\t\u0011)A\u0005\u0003+Cq!!(\u0001\t\u0013\ty\nC\u0004\u00020\u0002!\t%!-\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\bbBA}\u0001\u0011%\u00111 \u0005\b\u0005#\u0001A\u0011\tB\n\u0011\u001d\u0011)\u0002\u0001C!\u0005/AqAa\u0007\u0001\t\u0003\u0012i\u0002C\u0004\u0002<\u0002!\tE!\n\t\u000f\t\u001d\u0002\u0001\"\u0011\u0003*!9!Q\u0007\u0001\u0005B\t]\u0002b\u0002B \u0001\u0011\u0005#\u0011\t\u0005\b\u0005\u000b\u0002A\u0011\tB$\u0011\u001d\u0011i\u0005\u0001C!\u0005;AqAa\u0014\u0001\t\u0003\u0012\t\u0006C\u0004\u0002\n\u0002!\tEa\u0016\t\u000f\te\u0003\u0001\"\u0011\u0003\\!9!1\r\u0001\u0005B\t\u0015\u0004b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u0003\u0003A\u0011\tBB\u0011\u001d\u0011y\t\u0001C!\u0005#CqAa%\u0001\t\u0003\u0012)\nC\u0004\u0003\u001a\u0002!\tE!&\t\u000f\tm\u0005\u0001\"\u0011\u0003\u001e\"9!\u0011\u0015\u0001\u0005B\t\r\u0006b\u0002BQ\u0001\u0011%!q\u0015\u0005\b\t\u001f\u0002A\u0011\u0002C)\u0011\u001d!Y\u0007\u0001C\u0005\t[Bq\u0001b\u001d\u0001\t\u0003\u00129\u0004C\u0004\u0005v\u0001!I\u0001b\u001e\t\u000f\u0011\u0015\u0005\u0001\"\u0003\u00038!9Aq\u0011\u0001\u0005\n\t]\u0002b\u0002CE\u0001\u0011%A1\u0012\u0005\b\t#\u0003A\u0011\u0002CJ\u0011\u001d!I\n\u0001C!\t7C\u0001\u0002\"(\u0001\t\u0003)(1C\u0004\b\u0005\u0003,\b\u0012\u0001Bb\r\u0019!X\u000f#\u0001\u0003F\"9\u0011QT\u0017\u0005\u0002\t5\u0007b\u0002Bh[\u0011\u0005!\u0011\u001b\u0005\b\u0005[lC\u0011\u0002Bx\u0011\u001d\u0011\u00190\fC\u0005\u0005k4\u0011ba\u0005.!\u0003\rJc!\u0006\t\u000f\t5&G\"\u0001\u0004\u0018\u001911QH\u0017G\u0007\u007fA!b!\u00145\u0005+\u0007I\u0011AB(\u0011)\u0019\t\u0006\u000eB\tB\u0003%\u0011Q\u0018\u0005\u000b\u0007'\"$Q3A\u0005\u0002\r=\u0003BCB+i\tE\t\u0015!\u0003\u0002>\"Q1q\u000b\u001b\u0003\u0016\u0004%\taa\u0014\t\u0015\reCG!E!\u0002\u0013\ti\fC\u0004\u0002\u001eR\"\taa\u0017\t\u000f\t5F\u0007\"\u0011\u0004f!I1\u0011\u000e\u001b\u0002\u0002\u0013\u000511\u000e\u0005\n\u0007g\"\u0014\u0013!C\u0001\u0007kB\u0011ba#5#\u0003%\ta!\u001e\t\u0013\r5E'%A\u0005\u0002\rU\u0004\"CBHi\u0005\u0005I\u0011IBI\u0011%\u00199\nNA\u0001\n\u0003\u0019I\nC\u0005\u0004\u001cR\n\t\u0011\"\u0001\u0004\u001e\"I1\u0011\u0016\u001b\u0002\u0002\u0013\u000531\u0016\u0005\n\u0007k#\u0014\u0011!C\u0001\u0007oC\u0011ba/5\u0003\u0003%\tEa\u0005\t\u0013\ruF'!A\u0005B\r}\u0006\"CBai\u0005\u0005I\u0011IBb\u000f%!)!LA\u0001\u0012\u0013!9AB\u0005\u0004>5\n\t\u0011#\u0003\u0005\n!9\u0011Q\u0014&\u0005\u0002\u0011]\u0001\"CB_\u0015\u0006\u0005IQIB`\u0011%\u0011yMSA\u0001\n\u0003#I\u0002C\u0005\u0005\")\u000b\t\u0011\"!\u0005$!IA\u0011\u0007&\u0002\u0002\u0013%A1\u0007\u0004\u0007\u0007\u000flci!3\t\u0015\r-\u0007K!f\u0001\n\u0003\u0019y\u0005\u0003\u0006\u0004NB\u0013\t\u0012)A\u0005\u0003{C!ba4Q\u0005+\u0007I\u0011AB(\u0011)\u0019\t\u000e\u0015B\tB\u0003%\u0011Q\u0018\u0005\u000b\u0007'\u0004&Q3A\u0005\u0002\r=\u0003BCBk!\nE\t\u0015!\u0003\u0002>\"9\u0011Q\u0014)\u0005\u0002\r]\u0007b\u0002BW!\u0012\u00053\u0011\u001d\u0005\n\u0007S\u0002\u0016\u0011!C\u0001\u0007KD\u0011ba\u001dQ#\u0003%\ta!\u001e\t\u0013\r-\u0005+%A\u0005\u0002\rU\u0004\"CBG!F\u0005I\u0011AB;\u0011%\u0019y\tUA\u0001\n\u0003\u001a\t\nC\u0005\u0004\u0018B\u000b\t\u0011\"\u0001\u0004\u001a\"I11\u0014)\u0002\u0002\u0013\u00051Q\u001e\u0005\n\u0007S\u0003\u0016\u0011!C!\u0007WC\u0011b!.Q\u0003\u0003%\ta!=\t\u0013\rm\u0006+!A\u0005B\tM\u0001\"CB_!\u0006\u0005I\u0011IB`\u0011%\u0019\t\rUA\u0001\n\u0003\u001a)pB\u0005\u000565\n\t\u0011#\u0003\u00058\u0019I1qY\u0017\u0002\u0002#%A\u0011\b\u0005\b\u0003;3G\u0011\u0001C\u001f\u0011%\u0019iLZA\u0001\n\u000b\u001ay\fC\u0005\u0003P\u001a\f\t\u0011\"!\u0005@!IA\u0011\u00054\u0002\u0002\u0013\u0005Eq\t\u0005\n\tc1\u0017\u0011!C\u0005\tg9q\u0001b\u0013.\u0011\u001b\u00199DB\u0004\u0004.5Biaa\f\t\u000f\u0005uU\u000e\"\u0001\u00046!9!QV7\u0005B\rera\u0002C'[!51q \u0004\b\u0007sl\u0003RBB~\u0011\u001d\ti*\u001dC\u0001\u0007{DqA!,r\t\u0003\"\tA\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pO*\u0011ao^\u0001\u0005e\u00064GOC\u0001y\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019b\u0001A>\u0002\b\u0005m\u0001c\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006!A.\u00198h\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003{\n1qJ\u00196fGR\u0004B!!\u0003\u0002\u00185\u0011\u00111\u0002\u0006\u0004m\u00065!b\u0001=\u0002\u0010)!\u0011\u0011CA\n\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QC\u0001\u0004_J<\u0017\u0002BA\r\u0003\u0017\u0011QBU3qY&\u001c\u0017\r^3e\u0019><\u0007\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005r/A\u0003vi&d7/\u0003\u0003\u0002&\u0005}!a\u0002'pO\u001eLgnZ\u0001\u0004Y><WCAA\u0016!\u0011\ti#!\r\u000e\u0005\u0005=\"bAA\u0014o&!\u00111GA\u0018\u0005))f.\u001b4jK\u0012dunZ\u0001\u0005Y><\u0007%\u0001\u0003uS6,\u0007\u0003BA\u001e\u0003\u0007j!!!\u0010\u000b\t\u0005\u0005\u0012q\b\u0006\u0005\u0003\u0003\ni!\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u000b\niD\u0001\u0003US6,\u0017!C:dQ\u0016$W\u000f\\3s!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA!\u001e;jY*!\u00111KA\u0007\u0003\u0019\u0019XM\u001d<fe&!\u0011qKA'\u0005%\u00196\r[3ek2,'/A\u0005t]\u0006\u00048\u000f[8ugBA\u0011QLA6\u0003_\n)(\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u001diW\u000f^1cY\u0016TA!!\u001a\u0002h\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005\u0005%\u0014!B:dC2\f\u0017\u0002BA7\u0003?\u0012q\u0001\u0016:fK6\u000b\u0007\u000f\u0005\u0003\u0002\n\u0005E\u0014\u0002BA:\u0003\u0017\u0011ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0005\u0004\u0002x\u0005e\u0014QP\u0007\u0003\u0003OJA!a\u001f\u0002h\t1q\n\u001d;j_:\u0004B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000bi!\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\u0011\t9)!!\u0003+\u0019KG.\u001a*boNs\u0017\r]:i_R\u0014V-\u00193fe\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BAG\u0003\u001fk!!a\u0010\n\t\u0005E\u0015q\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019\u0019wN\u001c4jOB!\u0011qSAM\u001b\u0005)\u0018bAANk\n\tR*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u0002\rqJg.\u001b;?)9\t\t+a)\u0002&\u0006\u001d\u0016\u0011VAV\u0003[\u00032!a&\u0001\u0011\u001d\t9\u0003\u0003a\u0001\u0003WAq!a\u000e\t\u0001\u0004\tI\u0004C\u0004\u0002H!\u0001\r!!\u0013\t\u000f\u0005e\u0003\u00021\u0001\u0002\\!9\u0011\u0011\u0012\u0005A\u0002\u0005-\u0005bBAJ\u0011\u0001\u0007\u0011QS\u0001\u0005e\u0016\fG\r\u0006\u0004\u00024\u0006e\u00161\u0019\t\u0005\u0003\u0013\t),\u0003\u0003\u00028\u0006-!\u0001\u0004'pO\u001a+Go\u00195J]\u001a|\u0007bBA^\u0013\u0001\u0007\u0011QX\u0001\fgR\f'\u000f^(gMN,G\u000f\u0005\u0003\u0002x\u0005}\u0016\u0002BAa\u0003O\u0012A\u0001T8oO\"9\u0011QY\u0005A\u0002\u0005\u001d\u0017!\u0004:fC\u0012L5o\u001c7bi&|g\u000e\u0005\u0003\u0002\n\u0005%\u0017\u0002BAf\u0003\u0017\u0011\u0011\"S:pY\u0006$\u0018n\u001c8\u0002\u001d\u0005\u0004\b/\u001a8e\u0003NdU-\u00193feR1\u0011\u0011[Al\u0003O\u0004B!!\u0003\u0002T&!\u0011Q[A\u0006\u00055aunZ!qa\u0016tG-\u00138g_\"9\u0011\u0011\u001c\u0006A\u0002\u0005m\u0017a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]A \u0003\u0019\u0011XmY8sI&!\u0011Q]Ap\u0005\u001d\u0011VmY8sINDq!!;\u000b\u0001\u0004\tY/A\u0003fa>\u001c\u0007\u000e\u0005\u0003\u0002x\u00055\u0018\u0002BAx\u0003O\u00121!\u00138u\u0003A\t\u0007\u000f]3oI\u0006\u001bhi\u001c7m_^,'\u000f\u0006\u0004\u0002R\u0006U\u0018q\u001f\u0005\b\u00033\\\u0001\u0019AAn\u0011\u001d\tIo\u0003a\u0001\u0003W\fQ\u0004[1oI2,\u0017I\u001c3D_:4XM\u001d;M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u000b\u0005\u0003#\fi\u0010C\u0004\u0002\u00002\u0001\rA!\u0001\u0002\u0015\u0005\u0004\b/\u001a8e\u0013:4w\u000e\u0005\u0003\u0003\u0004\t=QB\u0001B\u0003\u0015\u0011\t9Ca\u0002\u000b\t\t%!1B\u0001\nS:$XM\u001d8bYNTAA!\u0004\u0002\u000e\u000591\u000f^8sC\u001e,\u0017\u0002BAk\u0005\u000b\t\u0001\u0003\\1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195\u0015\u0005\u0005-\u0018!E3oI>3gm]3u\r>\u0014X\t]8dQR!\u0011q\u000eB\r\u0011\u001d\tIO\u0004a\u0001\u0003W\f\u0011\"\u001a8e\u001f\u001a47/\u001a;\u0015\u0005\t}\u0001\u0003BA\u0005\u0005CIAAa\t\u0002\f\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\u0005\u0005u\u0016A\u0003;sk:\u001c\u0017\r^3U_R!!1\u0006B\u0019!\u0011\t9H!\f\n\t\t=\u0012q\r\u0002\u0005+:LG\u000fC\u0004\u00034E\u0001\r!!0\u0002\r=4gm]3u\u0003a!(/\u001e8dCR,Gk\u001c'bi\u0016\u001cHo\u00158baNDw\u000e\u001e\u000b\u0003\u0005s\u0001B!a\u001e\u0003<%!!QHA4\u0005\u001d\u0011un\u001c7fC:\fQ#\u001b8ji&\fG.\u001b>f\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0003,\t\r\u0003bBAu'\u0001\u0007\u00111^\u0001\u0014kB$\u0017\r^3IS\u001eDw+\u0019;fe6\f'o\u001b\u000b\u0005\u0005W\u0011I\u0005C\u0004\u0003LQ\u0001\rAa\b\u0002\u001d=4gm]3u\u001b\u0016$\u0018\rZ1uC\u0006i\u0001.[4i/\u0006$XM]7be.\fQA\u001a7vg\"$BAa\u000b\u0003T!9!Q\u000b\fA\u0002\te\u0012a\u00064pe\u000e,g\t\\;tQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u)\t\tY)A\u0004u_BL7-\u00133\u0015\u0005\tu\u0003\u0003BAG\u0005?JAA!\u0019\u0002@\t!Q+^5e\u0003E\u0019'/Z1uK:+wo\u00158baNDw\u000e\u001e\u000b\u0005\u0005O\u00129\b\u0005\u0004\u0003j\t5$\u0011O\u0007\u0003\u0005WR1!a\u0014\u0000\u0013\u0011\u0011yGa\u001b\u0003\u0011=\u0003H/[8oC2\u0004B!a \u0003t%!!QOAA\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;Xe&$XM\u001d\u0005\b\u0005sJ\u0002\u0019AA8\u0003)\u0019h.\u00199tQ>$\u0018\nZ\u0001\u001bGJ,\u0017\r^3OK^\u001cf.\u00199tQ>$XK\\2iK\u000e\\W\r\u001a\u000b\u0005\u0005O\u0012y\bC\u0004\u0003zi\u0001\r!a\u001c\u0002\u0019I,\u0017\rZ*oCB\u001c\bn\u001c;\u0015\t\t\u0015%Q\u0012\t\u0007\u0005S\u0012iGa\"\u0011\t\u0005}$\u0011R\u0005\u0005\u0005\u0017\u000b\tIA\tSC^\u001cf.\u00199tQ>$(+Z1eKJDqA!\u001f\u001c\u0001\u0004\ty'\u0001\bmCR,7\u000f^*oCB\u001c\bn\u001c;\u0015\u0005\t\u0015\u0015\u0001\u00057bi\u0016\u001cHo\u00158baNDw\u000e^%e)\t\u00119\n\u0005\u0004\u0003j\t5\u0014qN\u0001\u0013K\u0006\u0014H.[3tiNs\u0017\r]:i_RLE-\u0001\tp]Ns\u0017\r]:i_R4%o\u001c>f]R!!1\u0006BP\u0011\u001d\u0011Ih\ba\u0001\u0003_\nA\u0003Z3mKR,')\u001a4pe\u0016\u001cf.\u00199tQ>$H\u0003\u0002B\u001d\u0005KCqA!\u001f!\u0001\u0004\ty\u0007\u0006\u0004\u0003:\t%&1\u0016\u0005\b\u0005s\n\u0003\u0019AA8\u0011\u001d\u0011i+\ta\u0001\u0005_\u000baA]3bg>t\u0007c\u0001BYe9\u0019!1\u0017\u0017\u000f\t\tU&q\u0018\b\u0005\u0005o\u0013i,\u0004\u0002\u0003:*\u0019!1X=\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0018B\u0001<x\u0003AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rE\u0002\u0002\u00186\u001aR!\fBd\u00037\u0001B!a\u001e\u0003J&!!1ZA4\u0005\u0019\te.\u001f*fMR\u0011!1Y\u0001\u0006CB\u0004H.\u001f\u000b\u000f\u0003C\u0013\u0019N!6\u0003X\n\u001d(\u0011\u001eBv\u0011\u001d\tIi\fa\u0001\u0003\u0017CqA!\u00170\u0001\u0004\u0011i\u0006C\u0004\u0003Z>\u0002\rAa7\u0002\u000f\u0011\fG/\u0019#jeB!!Q\u001cBr\u001b\t\u0011yNC\u0002\u0003b~\f!![8\n\t\t\u0015(q\u001c\u0002\u0005\r&dW\rC\u0004\u00028=\u0002\r!!\u000f\t\u000f\u0005\u001ds\u00061\u0001\u0002J!9\u00111S\u0018A\u0002\u0005U\u0015\u0001\u0005:fG>4XM]*oCB\u001c\bn\u001c;t)\u0011\tYF!=\t\u000f\u0005\u001d\u0002\u00071\u0001\u0002,\u0005\u0019B-\u001a7fi\u0016\u001cf.\u00199tQ>$h)\u001b7fgRA!1\u0006B|\u0007\u0017\u0019y\u0001C\u0004\u0003zF\u0002\rAa?\u0002\r1|w\rR5s!\u0011\u0011ipa\u0002\u000e\u0005\t}(\u0002BB\u0001\u0007\u0007\tAAZ5mK*\u00191QA@\u0002\u00079Lw.\u0003\u0003\u0004\n\t}(\u0001\u0002)bi\"Dqa!\u00042\u0001\u0004\tY&\u0001\tfqBL'/\u001a3T]\u0006\u00048\u000f[8ug\"91\u0011C\u0019A\u0002\u0005m\u0011a\u00027pO\u001eLgn\u001a\u0002\u0017':\f\u0007o\u001d5pi\u0012+G.\u001a;j_:\u0014V-Y:p]N\u0019!Ga2\u0015\t\re1\u0011\u0006\t\u0005\u00077\u0019\u0019C\u0004\u0003\u0004\u001e\r}\u0001\u0003\u0002B\\\u0003OJAa!\t\u0002h\u00051\u0001K]3eK\u001aLAa!\n\u0004(\t11\u000b\u001e:j]\u001eTAa!\t\u0002h!9!\u0011P\u001aA\u0002\u0005=\u0014&\u0002\u001aniA\u000b(A\u0004$vY2$&/\u001e8dCRLwN\\\n\u0006[\n\u001d7\u0011\u0007\t\u0004\u0007g\u0011T\"A\u0017\u0015\u0005\r]\u0002cAB\u001a[R!1\u0011DB\u001e\u0011\u001d\u0011Ih\u001ca\u0001\u0003_\u0012\u0011CU3uK:$\u0018n\u001c8Ng\n\u0013X-Y2i'%!$qYB\u0019\u0007\u0003\u001a9\u0005\u0005\u0003\u0002x\r\r\u0013\u0002BB#\u0003O\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002x\r%\u0013\u0002BB&\u0003O\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f1A\\8x+\t\ti,\u0001\u0003o_^\u0004\u0013!\u0003;j[\u0016\u001cH/Y7q\u0003)!\u0018.\\3ti\u0006l\u0007\u000fI\u0001\u0010e\u0016$XM\u001c;j_:l\u0015\u000e\u001c7jg\u0006\u0001\"/\u001a;f]RLwN\\'jY2L7\u000f\t\u000b\t\u0007;\u001ayf!\u0019\u0004dA\u001911\u0007\u001b\t\u000f\r53\b1\u0001\u0002>\"911K\u001eA\u0002\u0005u\u0006bBB,w\u0001\u0007\u0011Q\u0018\u000b\u0005\u00073\u00199\u0007C\u0004\u0003zq\u0002\r!a\u001c\u0002\t\r|\u0007/\u001f\u000b\t\u0007;\u001aiga\u001c\u0004r!I1QJ\u001f\u0011\u0002\u0003\u0007\u0011Q\u0018\u0005\n\u0007'j\u0004\u0013!a\u0001\u0003{C\u0011ba\u0016>!\u0003\u0005\r!!0\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\u000f\u0016\u0005\u0003{\u001bIh\u000b\u0002\u0004|A!1QPBD\u001b\t\u0019yH\u0003\u0003\u0004\u0002\u000e\r\u0015!C;oG\",7m[3e\u0015\u0011\u0019))a\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\n\u000e}$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\rM\u0005c\u0001?\u0004\u0016&\u00191QE?\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007?\u001b)\u000b\u0005\u0003\u0002x\r\u0005\u0016\u0002BBR\u0003O\u00121!\u00118z\u0011%\u00199kQA\u0001\u0002\u0004\tY/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007[\u0003baa,\u00042\u000e}UBAA2\u0013\u0011\u0019\u0019,a\u0019\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005s\u0019I\fC\u0005\u0004(\u0016\u000b\t\u00111\u0001\u0004 \u0006A\u0001.Y:i\u0007>$W-\u0001\u0005u_N#(/\u001b8h)\t\u0019\u0019*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005s\u0019)\rC\u0005\u0004(\"\u000b\t\u00111\u0001\u0004 \n\u0019\"+\u001a;f]RLwN\\*ju\u0016\u0014%/Z1dQNI\u0001Ka2\u00042\r\u00053qI\u0001\bY><7+\u001b>f\u0003!awnZ*ju\u0016\u0004\u0013!D:oCB\u001c\bn\u001c;t'&TX-\u0001\bt]\u0006\u00048\u000f[8ugNK'0\u001a\u0011\u0002#I,G/\u001a8uS>tW*\u0019=CsR,7/\u0001\nsKR,g\u000e^5p]6\u000b\u0007PQ=uKN\u0004C\u0003CBm\u00077\u001cina8\u0011\u0007\rM\u0002\u000bC\u0004\u0004L^\u0003\r!!0\t\u000f\r=w\u000b1\u0001\u0002>\"911[,A\u0002\u0005uF\u0003BB\r\u0007GDqA!\u001fY\u0001\u0004\ty\u0007\u0006\u0005\u0004Z\u000e\u001d8\u0011^Bv\u0011%\u0019Y-\u0017I\u0001\u0002\u0004\ti\fC\u0005\u0004Pf\u0003\n\u00111\u0001\u0002>\"I11[-\u0011\u0002\u0003\u0007\u0011Q\u0018\u000b\u0005\u0007?\u001by\u000fC\u0005\u0004(~\u000b\t\u00111\u0001\u0002lR!!\u0011HBz\u0011%\u00199+YA\u0001\u0002\u0004\u0019y\n\u0006\u0003\u0003:\r]\b\"CBTI\u0006\u0005\t\u0019ABP\u00055)fn\u001b8po:\u0014V-Y:p]N)\u0011Oa2\u00042Q\u00111q \t\u0004\u0007g\tH\u0003BB\r\t\u0007AqA!\u001ft\u0001\u0004\ty'A\tSKR,g\u000e^5p]6\u001b(I]3bG\"\u00042aa\rK'\u0015QE1BB$!1!i\u0001b\u0005\u0002>\u0006u\u0016QXB/\u001b\t!yA\u0003\u0003\u0005\u0012\u0005\u001d\u0014a\u0002:v]RLW.Z\u0005\u0005\t+!yAA\tBEN$(/Y2u\rVt7\r^5p]N\"\"\u0001b\u0002\u0015\u0011\ruC1\u0004C\u000f\t?Aqa!\u0014N\u0001\u0004\ti\fC\u0004\u0004T5\u0003\r!!0\t\u000f\r]S\n1\u0001\u0002>\u00069QO\\1qa2LH\u0003\u0002C\u0013\t[\u0001b!a\u001e\u0002z\u0011\u001d\u0002CCA<\tS\ti,!0\u0002>&!A1FA4\u0005\u0019!V\u000f\u001d7fg!IAq\u0006(\u0002\u0002\u0003\u00071QL\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012a_\u0001\u0014%\u0016$XM\u001c;j_:\u001c\u0016N_3Ce\u0016\f7\r\u001b\t\u0004\u0007g17#\u00024\u0005<\r\u001d\u0003\u0003\u0004C\u0007\t'\ti,!0\u0002>\u000eeGC\u0001C\u001c)!\u0019I\u000e\"\u0011\u0005D\u0011\u0015\u0003bBBfS\u0002\u0007\u0011Q\u0018\u0005\b\u0007\u001fL\u0007\u0019AA_\u0011\u001d\u0019\u0019.\u001ba\u0001\u0003{#B\u0001\"\n\u0005J!IAq\u00066\u0002\u0002\u0003\u00071\u0011\\\u0001\u000f\rVdG\u000e\u0016:v]\u000e\fG/[8o\u00035)fn\u001b8po:\u0014V-Y:p]\u0006\tBn\\1e':\f\u0007o\u001d5piNK'0Z:\u0015\u0005\u0011M\u0003C\u0002C+\t?\")G\u0004\u0003\u0005X\u0011mc\u0002\u0002B\\\t3J!!!\u001b\n\t\u0011u\u0013qM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011!\t\u0007b\u0019\u0003\u0007M+\u0017O\u0003\u0003\u0005^\u0005\u001d\u0004\u0003CA<\tO\ny'!0\n\t\u0011%\u0014q\r\u0002\u0007)V\u0004H.\u001a\u001a\u0002+I,\u0017\rZ*oCB\u001c\bn\u001c;US6,7\u000f^1naR!Aq\u000eC9!\u0019\t9(!\u001f\u0002>\"9!\u0011P\u0012A\u0002\u0005=\u0014AC7bs\n,7\t\\3b]\u0006q1\r\\3b]Ns\u0017\r]:i_R\u001cH\u0003\u0002B\u001d\tsBq\u0001b\u001f&\u0001\u0004!i(A\u0005qe\u0016$\u0017nY1uKBA\u0011q\u000fC@\u0003_\"\u0019)\u0003\u0003\u0005\u0002\u0006\u001d$!\u0003$v]\u000e$\u0018n\u001c82!\u0019\t9(!\u001f\u00030\u0006I2\r\\3b]Ns\u0017\r]:i_R\u001c(+\u001a;f]RLwN\\'t\u0003m\u0019G.Z1o':\f\u0007o\u001d5piN\u0014V\r^3oi&|gnU5{K\u0006)bm\u001c:hKR\u001cf.\u00199tQ>$8OQ3g_J,G\u0003BA.\t\u001bCq\u0001b$)\u0001\u0004\ty'\u0001\nm_\u001e\u001cF/\u0019:u':\f\u0007o\u001d5pi&#\u0017a\u0004:f[>4Xm\u00158baNDw\u000e^:\u0015\r\t-BQ\u0013CL\u0011\u001d\u0019i!\u000ba\u0001\u00037BqA!,*\u0001\u0004\u0011y+A\u0003dY>\u001cX\r\u0006\u0002\u0003,\u0005i1O\\1qg\"|GoQ8v]R\u0004")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid uuid, File file, Time time, Scheduler scheduler, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, uuid, file, time, scheduler, metadataLogConfig);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchIsolation isolation = fetchIsolation;
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true);
        return new LogFetchInfo(fetchInfo.records, new LogOffsetMetadata(fetchInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata.segmentBaseOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        AppendOrigin x$3 = AppendOrigin.RAFT_LEADER;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        VerificationGuard x$6 = this.log().appendAsLeader$default$6();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, x$3, x$5, x$4, x$6));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records, epoch));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset() == UnifiedLog$.MODULE$.UnknownOffset()) {
            throw new CorruptRecordException(new StringBuilder(27).append("Append failed unexpectedly ").append(appendInfo).toString());
        }
        return new org.apache.kafka.raft.LogAppendInfo(appendInfo.firstOffset(), appendInfo.lastOffset());
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<org.apache.kafka.server.common.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset(), this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset()) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Attempt to truncate to offset ").append(offset).append(", which is below ").append("the current high watermark ").append(this.highWatermark().offset()).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > latestEpoch || snapshotId.epoch() == latestEpoch && snapshotId.offset() > this.endOffset().offset())) {
            this.log().truncateFullyAndStartAt(snapshotId.offset(), this.log().truncateFullyAndStartAt$default$2());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4, KafkaMetadataLog$FullTruncation$.MODULE$);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        long logHighWatermark;
        long l;
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata()));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            l = this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset(), segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
        } else {
            l = logHighWatermark = this.log().updateHighWatermark(offsetMetadata.offset());
        }
        if (logHighWatermark != offsetMetadata.offset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$updateHighWatermark$1(logHighWatermark, offsetMetadata)));
                return;
            }
            return;
        }
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = !hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId)));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset();
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.createNewSnapshotUnchecked(snapshotId);
    }

    public Optional<RawSnapshotWriter> createNewSnapshotUnchecked(OffsetAndEpoch snapshotId2) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId2);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(new NotifyingRawSnapshotWriter((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId2), snapshotId -> this.onSnapshotFrozen((OffsetAndEpoch)snapshotId)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        return this.deleteBeforeSnapshot(snapshotId, KafkaMetadataLog$UnknownReason$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId, SnapshotDeletionReason reason) {
        var3_3 = this.snapshots;
        synchronized (var3_3) {
            var4_4 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var4_4).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                deletedSegments = this.log().deleteOldSegments();
                forgottenSnapshots = this.forgetSnapshotsBefore(snapshotId);
                v0 = deletedSegments != 0 || forgottenSnapshots.nonEmpty() != false;
                v1 = forgottenSnapshots;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            }
            var9_8 = v1;
            var8_9 = v0;
        }
        this.removeSnapshots(var9_8, reason);
        return var8_9;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable & scala.Serializable)snapshotId -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable & scala.Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes())))), Seq$.MODULE$.canBuildFrom());
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).map((Function1 & Serializable & scala.Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Option<SnapshotDeletionReason>> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some = Seq$.MODULE$.unapplySeq(x0$1);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                    OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                    if (snapshot != null && nextSnapshot != null) {
                        Option option = (Option)predicate.apply((Object)snapshot);
                        if (option instanceof Some) {
                            SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                            if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                            }
                        } else {
                            if (None$.MODULE$.equals(option)) {
                                throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                            }
                            throw new MatchError((Object)option);
                        }
                        didClean$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                }
                return BoxesRunTime.boxToBoolean((boolean)false);
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable & scala.Serializable cleanSnapshots_predicate = (Function1 & Serializable & scala.Serializable)snapshotId -> this.shouldClean$1((OffsetAndEpoch)snapshotId);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some = Seq$.MODULE$.unapplySeq(x0$1);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                        if (snapshot != null && nextSnapshot != null) {
                            Option option = (Option)predicate.apply((Object)snapshot);
                            if (option instanceof Some) {
                                SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                            } else {
                                if (None$.MODULE$.equals(option)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                                throw new MatchError((Object)option);
                            }
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap(Predef$.MODULE$.$conforms());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable & scala.Serializable cleanSnapshots_predicate = (Function1 & Serializable & scala.Serializable)snapshotId -> this.shouldClean$2((OffsetAndEpoch)snapshotId, snapshotSizes, snapshotTotalSize);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some = Seq$.MODULE$.unapplySeq(x0$1);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                        if (snapshot != null && nextSnapshot != null) {
                            Option option = (Option)predicate.apply((Object)snapshot);
                            if (option instanceof Some) {
                                SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                            } else {
                                if (None$.MODULE$.equals(option)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                                throw new MatchError((Object)option);
                            }
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapLike)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((TraversableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, SnapshotDeletionReason reason) {
        expiredSnapshots.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(reason.reason(snapshotId)));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableLike)this.snapshots.values().flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset();
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ String $anonfun$updateHighWatermark$1(long logHighWatermark$1, LogOffsetMetadata offsetMetadata$1) {
        return new StringBuilder(79).append("Log's high watermark (").append(logHighWatermark$1).append(") is different from the local replica's high watermark (").append(offsetMetadata$1).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path)));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(RawSnapshotReader reader) {
        return Snapshots.lastContainedLogTimestamp((RawSnapshotReader)reader);
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionMs$1(KafkaMetadataLog $this, long timestamp) {
        long now = $this.time.milliseconds();
        if (now - timestamp > $this.config.retentionMillis()) {
            return new Some((Object)new RetentionMsBreach(now, timestamp, $this.config.retentionMillis()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$1(OffsetAndEpoch snapshotId) {
        return this.readSnapshotTimestamp(snapshotId).flatMap((Function1 & Serializable & scala.Serializable)timestamp -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionMs$1(this, BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionSize$1(KafkaMetadataLog $this, LongRef snapshotTotalSize$1, long snapshotSize) {
        if ($this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
            long oldSnapshotTotalSize = snapshotTotalSize$1.elem;
            snapshotTotalSize$1.elem -= snapshotSize;
            return new Some((Object)new RetentionSizeBreach($this.log().size(), oldSnapshotTotalSize, $this.config.retentionMaxBytes()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).flatMap((Function1 & Serializable & scala.Serializable)snapshotSize -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionSize$1(this, snapshotTotalSize$1, BoxesRunTime.unboxToLong((Object)snapshotSize)));
    }

    public KafkaMetadataLog(UnifiedLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }

    private static final class RetentionMsBreach
    implements SnapshotDeletionReason,
    Product,
    scala.Serializable {
        private final long now;
        private final long timestamp;
        private final long retentionMillis;

        public long now() {
            return this.now;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long retentionMillis() {
            return this.retentionMillis;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("Marking snapshot ").append(snapshotId).append(" for deletion because its timestamp (").append(this.timestamp()).append(") is now (").append(this.now()).append(") older than the\n          |retention (").append(this.retentionMillis()).append(")").toString())).stripMargin();
        }

        public RetentionMsBreach copy(long now, long timestamp, long retentionMillis) {
            return new RetentionMsBreach(now, timestamp, retentionMillis);
        }

        public long copy$default$1() {
            return this.now();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.retentionMillis();
        }

        public String productPrefix() {
            return "RetentionMsBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.now());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.timestamp());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMillis());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionMsBreach;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.now())), (int)Statics.longHash((long)this.timestamp())), (int)Statics.longHash((long)this.retentionMillis())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionMsBreach)) break block3;
                    RetentionMsBreach retentionMsBreach = (RetentionMsBreach)x$1;
                    if (this.now() != retentionMsBreach.now() || this.timestamp() != retentionMsBreach.timestamp() || this.retentionMillis() != retentionMsBreach.retentionMillis()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionMsBreach(long now, long timestamp, long retentionMillis) {
            this.now = now;
            this.timestamp = timestamp;
            this.retentionMillis = retentionMillis;
            Product.$init$((Product)this);
        }
    }

    private static final class RetentionSizeBreach
    implements SnapshotDeletionReason,
    Product,
    scala.Serializable {
        private final long logSize;
        private final long snapshotsSize;
        private final long retentionMaxBytes;

        public long logSize() {
            return this.logSize;
        }

        public long snapshotsSize() {
            return this.snapshotsSize;
        }

        public long retentionMaxBytes() {
            return this.retentionMaxBytes;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("Marking snapshot ").append(snapshotId).append(" for deletion because the log size (").append(this.logSize()).append(") and snapshots size (").append(this.snapshotsSize()).append(")\n          |is greater than ").append(this.retentionMaxBytes()).toString())).stripMargin();
        }

        public RetentionSizeBreach copy(long logSize, long snapshotsSize, long retentionMaxBytes) {
            return new RetentionSizeBreach(logSize, snapshotsSize, retentionMaxBytes);
        }

        public long copy$default$1() {
            return this.logSize();
        }

        public long copy$default$2() {
            return this.snapshotsSize();
        }

        public long copy$default$3() {
            return this.retentionMaxBytes();
        }

        public String productPrefix() {
            return "RetentionSizeBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.logSize());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.snapshotsSize());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMaxBytes());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionSizeBreach;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.logSize())), (int)Statics.longHash((long)this.snapshotsSize())), (int)Statics.longHash((long)this.retentionMaxBytes())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionSizeBreach)) break block3;
                    RetentionSizeBreach retentionSizeBreach = (RetentionSizeBreach)x$1;
                    if (this.logSize() != retentionSizeBreach.logSize() || this.snapshotsSize() != retentionSizeBreach.snapshotsSize() || this.retentionMaxBytes() != retentionSizeBreach.retentionMaxBytes()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionSizeBreach(long logSize, long snapshotsSize, long retentionMaxBytes) {
            this.logSize = logSize;
            this.snapshotsSize = snapshotsSize;
            this.retentionMaxBytes = retentionMaxBytes;
            Product.$init$((Product)this);
        }
    }

    private static interface SnapshotDeletionReason {
        public String reason(OffsetAndEpoch var1);
    }
}

