/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.internals.LogicalKeyValueSegment;
import org.apache.kafka.streams.state.internals.RocksDBVersionedStore;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBVersionedStoreRestoreWriteBuffer {
    private static final Logger log = LoggerFactory.getLogger(RocksDBVersionedStoreRestoreWriteBuffer.class);
    private final Map<Bytes, Optional<byte[]>> latestValueWriteBuffer;
    private final TreeMap<Long, WriteBufferSegmentWithDbFallback> segmentsWriteBuffer;
    private final RocksDBVersionedStore.RocksDBVersionedStoreClient dbClient;
    private final RocksDBVersionedStoreRestoreClient restoreClient;

    RocksDBVersionedStoreRestoreWriteBuffer(RocksDBVersionedStore.RocksDBVersionedStoreClient dbClient) {
        this.dbClient = Objects.requireNonNull(dbClient);
        this.latestValueWriteBuffer = new HashMap<Bytes, Optional<byte[]>>();
        this.segmentsWriteBuffer = new TreeMap((x, y) -> Long.compare(y, x));
        this.restoreClient = new RocksDBVersionedStoreRestoreClient();
    }

    RocksDBVersionedStore.VersionedStoreClient<?> getClient() {
        return this.restoreClient;
    }

    void flush() throws RocksDBException {
        Throwable throwable;
        try {
            throwable = null;
            try (WriteBatch segmentsBatch = new WriteBatch();){
                List<WriteBufferSegmentWithDbFallback> allSegments = this.restoreClient.getReverseSegments(Long.MIN_VALUE);
                if (allSegments.size() > 0) {
                    for (WriteBufferSegmentWithDbFallback bufferSegment : allSegments) {
                        LogicalKeyValueSegment dbSegment = bufferSegment.dbSegment();
                        for (Map.Entry<Bytes, byte[]> segmentEntry : bufferSegment.getAll().entrySet()) {
                            dbSegment.addToBatch(new KeyValue<byte[], byte[]>(segmentEntry.getKey().get(), segmentEntry.getValue()), (WriteBatchInterface)segmentsBatch);
                        }
                    }
                    allSegments.get(0).dbSegment().write((WriteBatchInterface)segmentsBatch);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (RocksDBException e) {
            log.error("Error restoring batch to RocksDBVersionedStore segments store.");
            throw e;
        }
        this.segmentsWriteBuffer.clear();
        try {
            throwable = null;
            try (WriteBatch latestValueBatch = new WriteBatch();){
                for (Map.Entry<Bytes, Optional<byte[]>> latestValueEntry : this.latestValueWriteBuffer.entrySet()) {
                    byte[] value = latestValueEntry.getValue().orElse(null);
                    this.dbClient.addToLatestValueBatch(new KeyValue<byte[], byte[]>(latestValueEntry.getKey().get(), value), latestValueBatch);
                }
                this.dbClient.writeLatestValues(latestValueBatch);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (RocksDBException e) {
            log.error("Error restoring batch to RocksDBVersionedStore latest value store.");
            throw e;
        }
        this.latestValueWriteBuffer.clear();
    }

    private class RocksDBVersionedStoreRestoreClient
    implements RocksDBVersionedStore.VersionedStoreClient<WriteBufferSegmentWithDbFallback> {
        private RocksDBVersionedStoreRestoreClient() {
        }

        @Override
        public byte[] getLatestValue(Bytes key) {
            Optional bufferValue = (Optional)RocksDBVersionedStoreRestoreWriteBuffer.this.latestValueWriteBuffer.get(key);
            if (bufferValue != null) {
                return bufferValue.orElse(null);
            }
            return RocksDBVersionedStoreRestoreWriteBuffer.this.dbClient.getLatestValue(key);
        }

        @Override
        public void putLatestValue(Bytes key, byte[] value) {
            RocksDBVersionedStoreRestoreWriteBuffer.this.latestValueWriteBuffer.put(key, Optional.ofNullable(value));
        }

        @Override
        public void deleteLatestValue(Bytes key) {
            this.putLatestValue(key, null);
        }

        @Override
        public WriteBufferSegmentWithDbFallback getOrCreateSegmentIfLive(long segmentId, ProcessorContext context, long streamTime) {
            if (RocksDBVersionedStoreRestoreWriteBuffer.this.segmentsWriteBuffer.containsKey(segmentId)) {
                return (WriteBufferSegmentWithDbFallback)RocksDBVersionedStoreRestoreWriteBuffer.this.segmentsWriteBuffer.get(segmentId);
            }
            LogicalKeyValueSegment dbSegment = RocksDBVersionedStoreRestoreWriteBuffer.this.dbClient.getOrCreateSegmentIfLive(segmentId, context, streamTime);
            if (dbSegment == null) {
                return null;
            }
            return new WriteBufferSegmentWithDbFallback(dbSegment);
        }

        @Override
        public List<WriteBufferSegmentWithDbFallback> getReverseSegments(long timestampFrom) {
            long segmentFrom = this.segmentIdForTimestamp(timestampFrom);
            ArrayList bufferSegments = new ArrayList(RocksDBVersionedStoreRestoreWriteBuffer.this.segmentsWriteBuffer.headMap(segmentFrom, true).values());
            List<LogicalKeyValueSegment> dbSegments = RocksDBVersionedStoreRestoreWriteBuffer.this.dbClient.getReverseSegments(timestampFrom);
            ArrayList<WriteBufferSegmentWithDbFallback> allSegments = new ArrayList<WriteBufferSegmentWithDbFallback>();
            int dbIndex = 0;
            int bufferIndex = 0;
            while (dbIndex < dbSegments.size() && bufferIndex < bufferSegments.size()) {
                long bufferSegmentId;
                LogicalKeyValueSegment dbSegment = dbSegments.get(dbIndex);
                WriteBufferSegmentWithDbFallback bufferSegment = (WriteBufferSegmentWithDbFallback)bufferSegments.get(bufferIndex);
                long dbSegmentId = dbSegment.id();
                if (dbSegmentId > (bufferSegmentId = bufferSegment.id())) {
                    allSegments.add(new WriteBufferSegmentWithDbFallback(dbSegment));
                    ++dbIndex;
                    continue;
                }
                if (dbSegmentId < bufferSegmentId) {
                    allSegments.add(bufferSegment);
                    ++bufferIndex;
                    continue;
                }
                allSegments.add(bufferSegment);
                ++dbIndex;
                ++bufferIndex;
            }
            while (dbIndex < dbSegments.size()) {
                allSegments.add(new WriteBufferSegmentWithDbFallback(dbSegments.get(dbIndex)));
                ++dbIndex;
            }
            while (bufferIndex < bufferSegments.size()) {
                allSegments.add((WriteBufferSegmentWithDbFallback)bufferSegments.get(bufferIndex));
                ++bufferIndex;
            }
            return allSegments;
        }

        @Override
        public long segmentIdForTimestamp(long timestamp) {
            return RocksDBVersionedStoreRestoreWriteBuffer.this.dbClient.segmentIdForTimestamp(timestamp);
        }
    }

    private class WriteBufferSegmentWithDbFallback
    implements RocksDBVersionedStore.VersionedStoreSegment {
        private final long id;
        private final Map<Bytes, byte[]> data;
        private final LogicalKeyValueSegment dbSegment;

        WriteBufferSegmentWithDbFallback(LogicalKeyValueSegment dbSegment) {
            this.dbSegment = Objects.requireNonNull(dbSegment);
            this.id = dbSegment.id();
            this.data = new HashMap<Bytes, byte[]>();
            RocksDBVersionedStoreRestoreWriteBuffer.this.segmentsWriteBuffer.put(this.id, this);
        }

        LogicalKeyValueSegment dbSegment() {
            return this.dbSegment;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void put(Bytes key, byte[] value) {
            this.data.put(key, value);
        }

        @Override
        public byte[] get(Bytes key) {
            byte[] bufferValue = this.data.get(key);
            if (bufferValue != null) {
                return bufferValue;
            }
            return this.dbSegment.get(key);
        }

        Map<Bytes, byte[]> getAll() {
            return Collections.unmodifiableMap(this.data);
        }
    }
}

