/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.juneau.commons.reflect.AccessibleInfo;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassArrayFormat;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassNameFormat;
import org.apache.juneau.commons.reflect.ElementFlag;
import org.apache.juneau.commons.reflect.PackageInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AnnotationUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public abstract class ExecutableInfo
extends AccessibleInfo {
    protected final ClassInfo declaringClass;
    private final Executable inner;
    private final boolean isConstructor;
    private final Supplier<List<ParameterInfo>> parameters;
    private final Supplier<List<ClassInfo>> parameterTypes;
    private final Supplier<List<ClassInfo>> exceptions;
    private final Supplier<List<AnnotationInfo<Annotation>>> declaredAnnotations;
    private final Supplier<String> shortName;
    private final Supplier<String> fullName;

    protected ExecutableInfo(ClassInfo declaringClass, Executable inner) {
        super(inner, AssertionUtils.assertArgNotNull("inner", inner).getModifiers());
        this.declaringClass = declaringClass;
        this.inner = inner;
        this.isConstructor = inner instanceof Constructor;
        this.parameters = Utils.mem(this::findParameters);
        this.parameterTypes = Utils.mem(() -> this.getParameters().stream().map(ParameterInfo::getParameterType).toList());
        this.exceptions = Utils.mem(() -> CollectionUtils.stream(inner.getExceptionTypes()).map(ClassInfo::of).map(ClassInfo.class::cast).toList());
        this.declaredAnnotations = Utils.mem(() -> CollectionUtils.stream(inner.getDeclaredAnnotations()).flatMap(a -> AnnotationUtils.streamRepeated(a)).map(a -> this.ai((Annotatable)((Object)this), a)).toList());
        this.shortName = Utils.mem(() -> Utils.f("{0}({1})", this.getSimpleName(), this.getParameters().stream().map(p -> p.getParameterType().getNameSimple()).collect(Collectors.joining(","))));
        this.fullName = Utils.mem(this::findFullName);
    }

    public ExecutableInfo accessible() {
        this.setAccessible();
        return this;
    }

    public final boolean canAccept(Object ... args) {
        Class<?>[] pt = this.inner.getParameterTypes();
        if (pt.length != args.length) {
            return false;
        }
        for (int i = 0; i < pt.length; ++i) {
            if (pt[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    public final AnnotatedType[] getAnnotatedExceptionTypes() {
        return this.inner.getAnnotatedExceptionTypes();
    }

    public final AnnotatedType[] getAnnotatedParameterTypes() {
        return this.inner.getAnnotatedParameterTypes();
    }

    public final AnnotatedType getAnnotatedReceiverType() {
        return this.inner.getAnnotatedReceiverType();
    }

    public final List<AnnotationInfo<Annotation>> getDeclaredAnnotations() {
        return this.declaredAnnotations.get();
    }

    public final <A extends Annotation> Stream<AnnotationInfo<A>> getDeclaredAnnotations(Class<A> type) {
        AssertionUtils.assertArgNotNull("type", type);
        return this.declaredAnnotations.get().stream().filter(x -> type.isInstance(x.inner())).map(x -> x);
    }

    public final ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public final List<ClassInfo> getExceptionTypes() {
        return this.exceptions.get();
    }

    public final String getFullName() {
        return this.fullName.get();
    }

    public final ParameterInfo getParameter(int index) {
        this.checkIndex(index);
        return this.getParameters().get(index);
    }

    public final int getParameterCount() {
        return this.inner.getParameterCount();
    }

    public final List<ParameterInfo> getParameters() {
        return this.parameters.get();
    }

    public final List<ClassInfo> getParameterTypes() {
        return this.parameterTypes.get();
    }

    public final String getShortName() {
        return this.shortName.get();
    }

    public final String getSimpleName() {
        return this.isConstructor ? Utils.cns(this.inner.getDeclaringClass()) : this.inner.getName();
    }

    public final TypeVariable<?>[] getTypeParameters() {
        return this.inner.getTypeParameters();
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.getDeclaredAnnotations(type).findFirst().isPresent();
    }

    public final boolean hasAnyName(Collection<String> names) {
        return names.contains(this.getSimpleName());
    }

    public final boolean hasAnyName(String ... names) {
        return CollectionUtils.stream(names).anyMatch(n -> Utils.eq(n, this.getSimpleName()));
    }

    public final boolean hasMatchingParameters(List<ParameterInfo> params) {
        List<ParameterInfo> myParams = this.getParameters();
        return myParams.size() == params.size() && IntStream.range(0, params.size()).allMatch(i -> ((ParameterInfo)myParams.get(i)).getParameterType().is(((ParameterInfo)params.get(i)).getParameterType()));
    }

    public final boolean hasName(String name) {
        return this.getSimpleName().equals(name);
    }

    public final boolean hasNumParameters(int number) {
        return this.getParameterCount() == number;
    }

    public final boolean hasParameters() {
        return this.getParameterCount() != 0;
    }

    public final boolean hasParameterTypeParents(Class<?> ... args) {
        List<ParameterInfo> params = this.getParameters();
        return params.size() == args.length && params.stream().allMatch(p -> CollectionUtils.stream(args).anyMatch(a -> p.getParameterType().isParentOfLenient((Class<?>)a)));
    }

    public final boolean hasParameterTypeParents(ClassInfo ... args) {
        List<ParameterInfo> params = this.getParameters();
        return params.size() == args.length && params.stream().allMatch(p -> CollectionUtils.stream(args).anyMatch(a -> p.getParameterType().isParentOfLenient((ClassInfo)a)));
    }

    public final boolean hasParameterTypes(Class<?> ... args) {
        List<ParameterInfo> params = this.getParameters();
        return params.size() == args.length && IntStream.range(0, args.length).allMatch(i -> ((ParameterInfo)params.get(i)).getParameterType().is(args[i]));
    }

    public final boolean hasParameterTypes(ClassInfo ... args) {
        List<ParameterInfo> params = this.getParameters();
        return params.size() == args.length && IntStream.range(0, args.length).allMatch(i -> ((ParameterInfo)params.get(i)).getParameterType().is(args[i]));
    }

    public final boolean hasParameterTypesLenient(Class<?> ... args) {
        return this.parameterMatchesLenientCount(args) != -1;
    }

    public final boolean hasParameterTypesLenient(ClassInfo ... args) {
        return this.parameterMatchesLenientCount(args) != -1;
    }

    @Override
    public boolean is(ElementFlag flag) {
        return switch (flag) {
            case ElementFlag.CONSTRUCTOR -> this.isConstructor();
            case ElementFlag.NOT_CONSTRUCTOR -> {
                if (!this.isConstructor()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.DEPRECATED -> this.isDeprecated();
            case ElementFlag.NOT_DEPRECATED -> this.isNotDeprecated();
            case ElementFlag.HAS_PARAMS -> this.hasParameters();
            case ElementFlag.HAS_NO_PARAMS -> {
                if (this.getParameterCount() == 0) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.SYNTHETIC -> this.isSynthetic();
            case ElementFlag.NOT_SYNTHETIC -> {
                if (!this.isSynthetic()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.VARARGS -> this.isVarArgs();
            case ElementFlag.NOT_VARARGS -> {
                if (!this.isVarArgs()) {
                    yield true;
                }
                yield false;
            }
            default -> super.is(flag);
        };
    }

    public final boolean isConstructor() {
        return this.isConstructor;
    }

    public final boolean isDeprecated() {
        return this.inner.isAnnotationPresent(Deprecated.class);
    }

    public final boolean isNotDeprecated() {
        return !this.inner.isAnnotationPresent(Deprecated.class);
    }

    public final boolean isSynthetic() {
        return this.inner.isSynthetic();
    }

    public final boolean isVarArgs() {
        return this.inner.isVarArgs();
    }

    public final boolean isVisible(Visibility v) {
        return v.isVisible(this.inner);
    }

    public final int parameterMatchesLenientCount(Class<?> ... argTypes) {
        int matches = 0;
        block0: for (ParameterInfo param : this.getParameters()) {
            for (Class<?> a : argTypes) {
                if (!param.getParameterType().isParentOfLenient(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public final int parameterMatchesLenientCount(ClassInfo ... argTypes) {
        int matches = 0;
        block0: for (ParameterInfo param : this.getParameters()) {
            for (ClassInfo a : argTypes) {
                if (!param.getParameterType().isParentOfLenient(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public final int parameterMatchesLenientCount(Object ... argTypes) {
        int matches = 0;
        block0: for (ParameterInfo param : this.getParameters()) {
            for (Object a : argTypes) {
                if (!param.getParameterType().canAcceptArg(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    @Override
    public final boolean setAccessible() {
        return Utils.safeOpt(() -> {
            this.inner.setAccessible(true);
            return true;
        }).orElse(false);
    }

    public final String toGenericString() {
        return this.inner.toGenericString();
    }

    public String toString() {
        return this.getShortName();
    }

    private void checkIndex(int index) {
        int pc = this.getParameterCount();
        if (pc == 0) {
            throw new IndexOutOfBoundsException(Utils.f("Invalid index ''{0}''.  No parameters.", index));
        }
        if (index < 0 || index >= pc) {
            throw new IndexOutOfBoundsException(Utils.f("Invalid index ''{0}''.  Parameter count: {1}", index, pc));
        }
    }

    private String findFullName() {
        StringBuilder sb = new StringBuilder(128);
        ClassInfo dc = this.declaringClass;
        PackageInfo pi = dc.getPackage();
        if (Utils.nn(pi)) {
            sb.append(pi.getName()).append('.');
        }
        dc.appendNameFormatted(sb, ClassNameFormat.SHORT, true, '$', ClassArrayFormat.BRACKETS);
        if (!this.isConstructor) {
            sb.append('.').append(this.getSimpleName());
        }
        sb.append('(');
        sb.append(this.getParameters().stream().map(p -> p.getParameterType().getNameFormatted(ClassNameFormat.FULL, true, '$', ClassArrayFormat.BRACKETS)).collect(Collectors.joining(",")));
        sb.append(')');
        return sb.toString();
    }

    private List<ParameterInfo> findParameters() {
        Type[] genericTypes;
        Parameter[] rp = this.inner.getParameters();
        Class[] ptc = this.inner.getParameterTypes();
        Type[] ptt = this.inner.getGenericParameterTypes();
        if (ptt.length == ptc.length) {
            genericTypes = ptt;
        } else {
            Type[] ptt2 = new Type[ptc.length];
            ptt2[0] = ptc[0];
            for (int i2 = 0; i2 < ptt.length; ++i2) {
                ptt2[i2 + 1] = ptt[i2];
            }
            genericTypes = ptt2;
        }
        return IntStream.range(0, rp.length).mapToObj(i -> new ParameterInfo(this, rp[i], i, ClassInfo.of(ptc[i], genericTypes[i]))).toList();
    }
}

