/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.io.LocalDir;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BasicFileFinder;
import org.apache.juneau.cp.BeanStore;

public interface FileFinder {
    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public Optional<InputStream> getStream(String var1, Locale var2) throws IOException;

    public Optional<String> getString(String var1, Locale var2) throws IOException;

    public static class Builder
    extends BeanBuilder<FileFinder> {
        final Set<LocalDir> roots = CollectionUtils.set(new LocalDir[0]);
        long cachingLimit = -1L;
        Pattern[] include = CollectionUtils.a(Pattern.compile(".*"));
        Pattern[] exclude = CollectionUtils.a(new Pattern[0]);

        protected Builder(BeanStore beanStore) {
            super(BasicFileFinder.class, beanStore);
        }

        public Builder caching(long cachingLimit) {
            this.cachingLimit = cachingLimit;
            return this;
        }

        public Builder cp(Class<?> c, String path, boolean recursive) {
            AssertionUtils.assertArgNotNull("c", c);
            while (Utils.nn(c)) {
                this.roots.add(new LocalDir(c, path));
                c = recursive ? c.getSuperclass() : null;
            }
            return this;
        }

        public Builder dir(String value) {
            AssertionUtils.assertArgNotNull("value", value);
            return this.path(Paths.get(".", new String[0]).resolve(value));
        }

        public Builder exclude(String ... patterns) {
            this.exclude = (Pattern[])CollectionUtils.l(patterns).stream().map(Pattern::compile).toArray(Pattern[]::new);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder include(String ... patterns) {
            this.include = (Pattern[])CollectionUtils.l(patterns).stream().map(Pattern::compile).toArray(Pattern[]::new);
            return this;
        }

        public Builder path(Path value) {
            this.roots.add(new LocalDir(value));
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected FileFinder buildDefault() {
            return new BasicFileFinder(this);
        }
    }

    public static abstract class Void
    implements FileFinder {
    }
}

