/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class MultiMap<K, V>
extends AbstractMap<K, V> {
    final Map<K, V>[] m;

    @SafeVarargs
    public MultiMap(Map<K, V> ... maps) {
        AssertionUtils.assertArgNotNull("maps", maps);
        for (Map<K, V> map : maps) {
            AssertionUtils.assertArgNotNull("maps", map);
        }
        this.m = maps;
    }

    @Override
    public V get(Object key) {
        for (Map<K, V> map : this.m) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map<K, V> map : this.m) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<K, V> map : this.m) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    int mapIndex = 0;
                    Iterator<Map.Entry<K, V>> currentIterator;
                    Set<K> seenKeys = new HashSet();
                    Map.Entry<K, V> nextEntry;
                    Iterator<Map.Entry<K, V>> lastIterator;
                    boolean canRemove = false;
                    {
                        if (MultiMap.this.m.length > 0) {
                            this.currentIterator = MultiMap.this.m[0].entrySet().iterator();
                            this.advance();
                        }
                    }

                    private void advance() {
                        this.nextEntry = null;
                        while (this.currentIterator != null) {
                            while (this.currentIterator.hasNext()) {
                                Map.Entry entry = this.currentIterator.next();
                                if (this.seenKeys.contains(entry.getKey())) continue;
                                this.seenKeys.add(entry.getKey());
                                this.nextEntry = entry;
                                return;
                            }
                            ++this.mapIndex;
                            if (this.mapIndex < MultiMap.this.m.length) {
                                this.currentIterator = MultiMap.this.m[this.mapIndex].entrySet().iterator();
                                continue;
                            }
                            this.currentIterator = null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextEntry != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.nextEntry == null) {
                            throw new NoSuchElementException();
                        }
                        Map.Entry result = this.nextEntry;
                        this.lastIterator = this.currentIterator;
                        this.canRemove = true;
                        this.advance();
                        return result;
                    }

                    @Override
                    public void remove() {
                        if (!this.canRemove || this.lastIterator == null) {
                            throw new IllegalStateException();
                        }
                        this.lastIterator.remove();
                        this.canRemove = false;
                    }
                };
            }

            @Override
            public int size() {
                return MultiMap.this.size();
            }
        };
    }

    @Override
    public int size() {
        HashSet<K> seenKeys = new HashSet<K>();
        for (Map<K, V> map : this.m) {
            seenKeys.addAll(map.keySet());
        }
        return seenKeys.size();
    }

    @Override
    public boolean isEmpty() {
        for (Map<K, V> map : this.m) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<Map.Entry<K, V>> entryIterator;
                    {
                        this.entryIterator = MultiMap.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entryIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.entryIterator.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.entryIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return MultiMap.this.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        throw ThrowableUtils.unsupportedOp("put() not supported on MultiMap. Use underlying maps directly.", new Object[0]);
    }

    @Override
    public V remove(Object key) {
        throw ThrowableUtils.unsupportedOp("remove() not supported on MultiMap. Use underlying maps directly.", new Object[0]);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw ThrowableUtils.unsupportedOp("putAll() not supported on MultiMap. Use underlying maps directly.", new Object[0]);
    }

    @Override
    public void clear() {
        throw ThrowableUtils.unsupportedOp("clear() not supported on MultiMap. Use underlying maps directly.", new Object[0]);
    }

    @Override
    public String toString() {
        return Arrays.stream(this.m).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean equals(Object o) {
        Map o2;
        return o instanceof Map && Utils.eq(this, o2 = (Map)o, (x, y) -> x.entrySet().equals(y.entrySet()));
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }
}

