/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.great_circle;

import org.apache.jena.geosparql.implementation.great_circle.LatLonPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

public class GreatCircleDistance {
    public static final double vincentyFormula(LatLonPoint point1, LatLonPoint point2) {
        double lat1 = point1.getLat();
        double lon1 = point1.getLon();
        double lat2 = point2.getLat();
        double lon2 = point2.getLon();
        return GreatCircleDistance.vincentyFormula(lat1, lon1, lat2, lon2);
    }

    public static final double vincentyFormula(Point point1, Point point2) {
        double lat1 = point1.getY();
        double lon1 = point1.getX();
        double lat2 = point2.getY();
        double lon2 = point2.getX();
        return GreatCircleDistance.vincentyFormula(lat1, lon1, lat2, lon2);
    }

    public static final double vincentyFormula(Coordinate coord1, Coordinate coord2) {
        double lat1 = coord1.getY();
        double lon1 = coord1.getX();
        double lat2 = coord2.getY();
        double lon2 = coord2.getX();
        return GreatCircleDistance.vincentyFormula(lat1, lon1, lat2, lon2);
    }

    public static final double vincentyFormula(double lat1, double lon1, double lat2, double lon2) {
        double lat1Rad = Math.toRadians(lat1);
        double lat2Rad = Math.toRadians(lat2);
        double diffLonRad = Math.toRadians(lon2 - lon1);
        double a = Math.pow(Math.cos(lat2Rad) * Math.sin(diffLonRad), 2.0);
        double b = Math.pow(Math.cos(lat1Rad) * Math.sin(lat2Rad) - Math.sin(lat1Rad) * Math.cos(lat2Rad) * Math.cos(diffLonRad), 2.0);
        double c = Math.sqrt(a + b);
        double d = Math.abs(Math.sin(lat1Rad) * Math.sin(lat2Rad) + Math.cos(lat1Rad) * Math.cos(lat2Rad) * Math.cos(diffLonRad));
        double e2 = Math.atan(c / d);
        double distance = 6371008.7714 * e2;
        return distance;
    }

    public static final double haversineFormula(LatLonPoint point1, LatLonPoint point2) {
        double lat1 = point1.getLat();
        double lon1 = point1.getLon();
        double lat2 = point2.getLat();
        double lon2 = point2.getLon();
        return GreatCircleDistance.haversineFormula(lat1, lon1, lat2, lon2);
    }

    public static final double haversineFormula(Point point1, Point point2) {
        double lat1 = point1.getY();
        double lon1 = point1.getX();
        double lat2 = point2.getY();
        double lon2 = point2.getX();
        return GreatCircleDistance.vincentyFormula(lat1, lon1, lat2, lon2);
    }

    public static final double haversineFormula(Coordinate coord1, Coordinate coord2) {
        double lat1 = coord1.getY();
        double lon1 = coord1.getX();
        double lat2 = coord2.getY();
        double lon2 = coord2.getX();
        return GreatCircleDistance.vincentyFormula(lat1, lon1, lat2, lon2);
    }

    public static final double haversineFormula(double lat1, double lon1, double lat2, double lon2) {
        double lat1Rad = Math.toRadians(lat1);
        double lat2Rad = Math.toRadians(lat2);
        double diffLatRad = Math.toRadians(lat2 - lat1);
        double diffLonRad = Math.toRadians(lon2 - lon1);
        double a = Math.pow(Math.sin(diffLatRad / 2.0), 2.0) + Math.cos(lat1Rad) * Math.cos(lat2Rad) * Math.pow(Math.sin(diffLonRad / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371008.7714 * c;
        return distance;
    }
}

