/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.DefaultLocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

@XmlType(name="MemberName_Type")
@XmlRootElement(name="MemberName")
public class DefaultMemberName
extends DefaultLocalName
implements MemberName {
    private static final long serialVersionUID = 7307683415489715298L;
    @XmlElement(required=true)
    private final TypeName attributeType;

    protected DefaultMemberName(NameSpace scope, CharSequence name, TypeName attributeType) {
        super(scope, name);
        ArgumentChecks.ensureNonNull("attributeType", attributeType);
        this.attributeType = attributeType;
    }

    public static DefaultMemberName castOrCopy(MemberName object) {
        if (object == null || object instanceof DefaultMemberName) {
            return (DefaultMemberName)object;
        }
        return new DefaultMemberName(object.scope(), object.toInternationalString(), object.getAttributeType());
    }

    @Override
    public TypeName getAttributeType() {
        return this.attributeType;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals(this.attributeType, ((DefaultMemberName)object).attributeType);
    }

    @Override
    final int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.attributeType);
    }

    private DefaultMemberName() {
        this.attributeType = null;
    }
}

