/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.graph.impl.TransactionHandlerBase;
import org.apache.jena.sparql.JenaTransactionException;

public class TransactionHandlerNull
extends TransactionHandlerBase {
    private ThreadLocal<Boolean> inTransaction = ThreadLocal.withInitial(() -> Boolean.FALSE);

    @Override
    public boolean transactionsSupported() {
        return true;
    }

    @Override
    public void begin() {
        if (this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Already in transaction");
        }
        this.inTransaction.set(true);
    }

    @Override
    public void commit() {
        if (!this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Not in transaction");
        }
        this.inTransaction.set(false);
    }

    @Override
    public void abort() {
        if (!this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Not in transaction");
        }
        this.inTransaction.set(false);
    }

    public void remove() {
        this.inTransaction.remove();
    }
}

