/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.rdfxml.rrx_stax_ev;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.rdfxml.RDFXMLParseException;
import org.apache.jena.riot.lang.rdfxml.rrx_stax_ev.ReaderRDFXML_StAX_EV;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.XML11Char;
import org.apache.jena.vocabulary.RDF;

class ParserRRX_StAX_EV {
    private static int IRI_CACHE_SIZE = 8192;
    private static boolean EVENTS = false;
    private final IndentedWriter trace;
    private final XMLEventReader xmlEventReader;
    private Cache<String, IRIx> iriCacheForBaseNull = null;
    private Cache<String, IRIx> currentIriCache = null;
    private final Map<IRIx, Cache<String, IRIx>> mapBaseIriToCache = new HashMap<IRIx, Cache<String, IRIx>>();
    private static final String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String xmlNS = "http://www.w3.org/XML/1998/namespace";
    private boolean hasRDF = false;
    private final ParserProfile parserProfile;
    private final ErrorHandler errorHandler;
    private final StreamRDF destination;
    private Deque<BaseLang> stack = new ArrayDeque<BaseLang>();
    private int countTrackingIDs = 0;
    private Map<IRIx, Map<String, Location>> trackUsedIDs = new HashMap<IRIx, Map<String, Location>>();
    private StringBuilder accCharacters = new StringBuilder(100);
    private IRIx currentBase = null;
    private String currentLang = null;
    private static final QName rdfRDF = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
    private static final QName rdfDescription = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
    private static final QName rdfID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
    private static final QName rdfNodeID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
    private static final QName rdfAbout = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
    private static final QName rdfType = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
    private static final QName rdfContainerItem = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li");
    private static final QName rdfDatatype = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
    private static final QName rdfParseType = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
    private static final QName rdfResource = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
    private static final QName rdfAboutEach = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEach");
    private static final QName rdfAboutEachPrefix = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEachPrefix");
    private static final QName rdfBagID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "bagID");
    private static final QName xmlQNameBase = new QName("http://www.w3.org/XML/1998/namespace", "base");
    private static final QName xmlQNameLang = new QName("http://www.w3.org/XML/1998/namespace", "lang");
    private static final QName xmlQNameSpace = new QName("http://www.w3.org/XML/1998/namespace", "space");
    private static final String parseTypeCollection = "Collection";
    private static final String parseTypeLiteral = "Literal";
    private static final String parseTypeLiteralAlt = "literal";
    private static final String parseTypeLiteralStmts = "Statements";
    private static final String parseTypeResource = "Resource";
    private static final String parseTypePlain = "$$";
    private static Set<QName> $coreSyntaxTerms = Set.of(rdfRDF, rdfID, rdfAbout, rdfParseType, rdfResource, rdfNodeID, rdfDatatype);
    private static Set<QName> $oldTerms = Set.of(rdfAboutEach, rdfAboutEachPrefix, rdfBagID);
    private static Set<String> $allowedUnqualified = Set.of(rdfAbout.getLocalPart(), rdfID.getLocalPart(), rdfResource.getLocalPart(), rdfParseType.getLocalPart(), rdfType.getLocalPart());
    private static Set<QName> $rdfSyntaxAttributes = Set.of(rdfRDF, rdfAbout, rdfNodeID, rdfID, rdfParseType, rdfDatatype, rdfResource);
    private static Set<QName> $xmlReservedTerms = Set.of(xmlQNameBase, xmlQNameLang, xmlQNameSpace);
    private static final String openStartTag = "<";
    private static final String closeStartTag = ">";
    private static final String openEndTag = "</";
    private static final String closeEndTag = ">";
    private static final Set<String> knownRDF = Set.of("Bag", "Seq", "Alt", "List", "XMLLiteral", "Property", "Statement", "type", "li", "subject", "predicate", "object", "value", "first", "rest", "nil");
    private static final Set<String> knownRDFProperties = knownRDF;
    private static final Set<String> knownRDFTypes = knownRDF;

    private void updateCurrentIriCacheForCurrentBase() {
        if (this.currentBase != null) {
            this.currentIriCache = this.mapBaseIriToCache.computeIfAbsent(this.currentBase, b -> CacheFactory.createSimpleCache(IRI_CACHE_SIZE));
        } else {
            if (this.iriCacheForBaseNull == null) {
                this.iriCacheForBaseNull = CacheFactory.createSimpleCache(IRI_CACHE_SIZE);
            }
            this.currentIriCache = this.iriCacheForBaseNull;
        }
    }

    private boolean isDifferentFromCurrentBase(IRIx base) {
        if (this.currentBase != null) {
            return !this.currentBase.equals(base);
        }
        return base != null;
    }

    private void pushFrame(IRIx base, String lang) {
        BaseLang frame = new BaseLang(this.currentBase, this.currentLang, this.currentIriCache);
        this.stack.push(frame);
        this.currentLang = lang;
        if (this.isDifferentFromCurrentBase(base)) {
            this.currentBase = base;
            this.updateCurrentIriCacheForCurrentBase();
        }
    }

    private void popFrame() {
        BaseLang frame = this.stack.pop();
        this.currentLang = frame.lang;
        if (this.isDifferentFromCurrentBase(frame.base)) {
            this.currentBase = frame.base;
            this.currentIriCache = frame.iriCache;
        }
    }

    private RiotException RDFXMLparseError(String message, XMLEvent event) {
        Location location = event != null ? event.getLocation() : null;
        return this.RDFXMLparseError(message, location);
    }

    private void RDFXMLparseWarning(String message, XMLEvent event) {
        Location location = event != null ? event.getLocation() : null;
        this.RDFXMLparseWarning(message, location);
    }

    private RiotException RDFXMLparseError(String message, Location location) {
        if (location != null) {
            this.errorHandler.error(message, location.getLineNumber(), location.getColumnNumber());
        } else {
            this.errorHandler.error(message, -1L, -1L);
        }
        return new RiotException(SysRIOT.fmtMessage(message, location.getLineNumber(), location.getColumnNumber()));
    }

    private void RDFXMLparseWarning(String message, Location location) {
        if (location != null) {
            this.errorHandler.warning(message, location.getLineNumber(), location.getColumnNumber());
        } else {
            this.errorHandler.warning(message, -1L, -1L);
        }
    }

    private Location previousUseOfID(String idStr, Location location) {
        Map scope = this.trackUsedIDs.computeIfAbsent(this.currentBase, k -> new HashMap());
        Location prev = (Location)scope.get(idStr);
        if (prev != null) {
            return prev;
        }
        if (this.countTrackingIDs > 10000) {
            return null;
        }
        scope.put(idStr, location);
        ++this.countTrackingIDs;
        return null;
    }

    ParserRRX_StAX_EV(XMLEventReader reader, String xmlBase, ParserProfile parserProfile, StreamRDF destination, Context context2) {
        IndentedWriter out = IndentedWriter.stdout.clone();
        out.setFlushOnNewline(true);
        out.setUnitIndent(4);
        out.setLinePrefix("# ");
        this.trace = out;
        EVENTS = ReaderRDFXML_StAX_EV.TRACE;
        this.xmlEventReader = reader;
        this.parserProfile = parserProfile;
        this.errorHandler = parserProfile.getErrorHandler();
        if (xmlBase != null) {
            this.currentBase = IRIx.create(xmlBase);
            parserProfile.setBaseIRI(this.currentBase.str());
        } else {
            this.currentBase = null;
        }
        this.updateCurrentIriCacheForCurrentBase();
        this.currentLang = "";
        this.destination = destination;
    }

    private boolean coreSyntaxTerm(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return false;
        }
        return $coreSyntaxTerms.contains(qName);
    }

    private static boolean allowedNodeElementURIs(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return true;
        }
        if ($coreSyntaxTerms.contains(qName)) {
            return false;
        }
        if (rdfContainerItem.equals(qName)) {
            return false;
        }
        return !$oldTerms.contains(qName);
    }

    private static boolean allowedPropertyElementURIs(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return true;
        }
        if ($coreSyntaxTerms.contains(qName)) {
            return false;
        }
        if (rdfDescription.equals(qName)) {
            return false;
        }
        return !$oldTerms.contains(qName);
    }

    private static boolean allowedPropertyAttributeURIs(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return true;
        }
        if ($coreSyntaxTerms.contains(qName)) {
            return false;
        }
        if (rdfDescription.equals(qName)) {
            return false;
        }
        if (rdfContainerItem.equals(qName)) {
            return false;
        }
        return !$oldTerms.contains(qName);
    }

    private static boolean allowedUnqualifiedTerm(String localName) {
        return $allowedUnqualified.contains(localName);
    }

    private static boolean isSyntaxAttribute(QName qName) {
        return $rdfSyntaxAttributes.contains(qName);
    }

    private static boolean isXMLQName(QName qName) {
        return $xmlReservedTerms.contains(qName);
    }

    private static boolean isXMLNamespace(QName qName) {
        return xmlNS.equals(qName.getNamespaceURI());
    }

    void parse() {
        boolean hasDocument = false;
        XMLEvent event = this.nextEventAny();
        if (event.isStartDocument()) {
            if (ReaderRDFXML_StAX_EV.TRACE) {
                this.trace.println("Start document");
            }
            hasDocument = true;
            event = this.nextEventTag();
        }
        if (event.isEndDocument()) {
            throw this.RDFXMLparseError("Empty document", event);
        }
        if (!event.isStartElement()) {
            throw this.RDFXMLparseError("Not a start element", event);
        }
        StartElement rdfStartElt = event.asStartElement();
        boolean hasFrame = false;
        if (this.qNameMatches(rdfRDF, rdfStartElt.getName())) {
            if (ReaderRDFXML_StAX_EV.TRACE) {
                this.trace.println("rdf:RDF");
            }
            hasFrame = this.startElement(rdfStartElt);
            this.emitInitialBaseAndNamespaces(rdfStartElt);
            this.hasRDF = true;
            event = this.nextEventTag();
        }
        this.incIndent();
        event = this.hasRDF ? this.nodeElementLoop(event) : this.nodeElementSingle(event);
        this.decIndent();
        if (this.hasRDF) {
            if (!this.qNameMatches(rdfRDF, event.asEndElement().getName())) {
                throw this.RDFXMLparseError("Expected </" + rdfStartElt.getName().getPrefix() + ":RDF>  got " + ParserRRX_StAX_EV.str(event), event);
            }
            this.endElement(hasFrame);
            if (ReaderRDFXML_StAX_EV.TRACE) {
                this.trace.println("/rdf:RDF");
            }
            event = this.nextEventAny();
        }
        while (ParserRRX_StAX_EV.isWhitespace(event)) {
            event = this.nextEventAny();
        }
        if (hasDocument) {
            if (!event.isEndDocument()) {
                throw this.RDFXMLparseError("Expected end of document: got " + ParserRRX_StAX_EV.str(event), event);
            }
            if (ReaderRDFXML_StAX_EV.TRACE) {
                this.trace.println("End document");
            }
        }
    }

    private XMLEvent nodeElementLoop(XMLEvent event) {
        while (event != null && event.isStartElement()) {
            StartElement startElt = event.asStartElement();
            this.nodeElement(startElt);
            event = this.nextEventTag();
        }
        return event;
    }

    private XMLEvent nodeElementSingle(XMLEvent event) {
        if (!event.isStartElement()) {
            return event;
        }
        StartElement startElt = event.asStartElement();
        this.nodeElement(startElt);
        return this.peekEvent();
    }

    private void nodeElement(StartElement startElt) {
        this.nodeElement(null, startElt);
    }

    private void nodeElement(Node subject, StartElement startElt) {
        if (ReaderRDFXML_StAX_EV.TRACE) {
            this.trace.println(">> nodeElement: " + ParserRRX_StAX_EV.str(startElt.getLocation()) + " " + ParserRRX_StAX_EV.str(startElt));
        }
        if (!ParserRRX_StAX_EV.allowedNodeElementURIs(startElt.getName())) {
            throw this.RDFXMLparseError("Not allowed as a node element tag: '" + ParserRRX_StAX_EV.str(startElt.getName()) + "'", startElt);
        }
        Attribute attrRdfResource = startElt.getAttributeByName(rdfResource);
        if (attrRdfResource != null) {
            throw this.RDFXMLparseError("rdf:resource not allowed as attribute here: " + ParserRRX_StAX_EV.str(startElt.getName()), startElt);
        }
        this.incIndent();
        boolean hasFrame = this.startElement(startElt);
        if (subject == null) {
            subject = this.attributesToSubjectNode(startElt);
        }
        EndElement endElt = this.nodeElementProcess(subject, startElt);
        this.endElement(hasFrame);
        this.decIndent();
        if (ReaderRDFXML_StAX_EV.TRACE) {
            this.trace.println("<< nodeElement: " + ParserRRX_StAX_EV.str(endElt.getLocation()) + " " + ParserRRX_StAX_EV.str(endElt));
        }
    }

    private EndElement nodeElementProcess(Node subject, StartElement startElt) {
        Location location = startElt.getLocation();
        QName qName = startElt.getName();
        if (!this.qNameMatches(qName, rdfDescription)) {
            if (ParserRRX_StAX_EV.isMemberProperty(qName)) {
                this.RDFXMLparseWarning(ParserRRX_StAX_EV.str(qName) + " is being used on a typed node", location);
            } else if (this.isNotRecognizedRDFtype(qName)) {
                this.RDFXMLparseWarning(ParserRRX_StAX_EV.str(qName) + " is not a recognized RDF term for a type", location);
            }
            Node object = this.qNameToIRI(qName, QNameUsage.TypedNodeElement, location);
            this.emit(subject, NodeConst.nodeRDFType, object, location);
        }
        this.processPropertyAttributes(subject, startElt, true, location);
        XMLEvent event = this.nextEventTag();
        event = this.propertyElementLoop(subject, event);
        if (event == null) {
            throw this.RDFXMLparseError("Expected end element for " + String.valueOf(startElt.getName()), event);
        }
        if (!event.isEndElement()) {
            throw this.RDFXMLparseError("Expected end element " + ParserRRX_StAX_EV.str(startElt) + " but found " + ParserRRX_StAX_EV.str(event), event);
        }
        return event.asEndElement();
    }

    private XMLEvent propertyElementLoop(Node subject, XMLEvent event) {
        Counter listElementCounter = new Counter();
        while (event != null && event.isStartElement()) {
            this.propertyElement(subject, event.asStartElement(), listElementCounter);
            event = this.nextEventTag();
        }
        return event;
    }

    private void propertyElement(Node subject, StartElement startElt, Counter listElementCounter) {
        if (ReaderRDFXML_StAX_EV.TRACE) {
            this.trace.println(">> propertyElement: " + ParserRRX_StAX_EV.str(startElt.getLocation()) + " " + ParserRRX_StAX_EV.str(startElt));
        }
        this.incIndent();
        boolean hasFrame = this.startElement(startElt);
        QName qName = startElt.getName();
        if (!ParserRRX_StAX_EV.allowedPropertyElementURIs(startElt.getName())) {
            throw this.RDFXMLparseError("QName not allowed for property: " + ParserRRX_StAX_EV.str(qName), startElt);
        }
        if (this.isNotRecognizedRDFproperty(qName)) {
            this.RDFXMLparseWarning(ParserRRX_StAX_EV.str(qName) + " is not a recognized RDF property", startElt);
        }
        XMLEvent event = this.propertyElementProcess(subject, startElt, listElementCounter);
        this.endElement(hasFrame);
        this.decIndent();
        if (ReaderRDFXML_StAX_EV.TRACE) {
            this.trace.println("<< propertyElement: " + ParserRRX_StAX_EV.str(event.getLocation()) + " " + ParserRRX_StAX_EV.str(event));
        }
    }

    private XMLEvent propertyElementProcess(Node subject, StartElement startElt, Counter listElementCounter) {
        Location location = startElt.getLocation();
        Node property = this.qNameMatches(rdfContainerItem, startElt.getName()) ? this.iriDirect("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + Integer.toString(listElementCounter.value++), location) : this.qNameToIRI(startElt.getName(), QNameUsage.PropertyElement, location);
        Node reify = this.reifyStatement(startElt);
        Emitter emitter = reify == null ? this::emit : (s, p, o, loc) -> this.emitReify(reify, s, p, o, loc);
        String objBlankNodeLabel = this.attribute(startElt, rdfNodeID);
        String rdfResourceStr = this.attribute(startElt, rdfResource);
        String datatype = this.attribute(startElt, rdfDatatype);
        String parseType = this.objectParseType(startElt);
        if (datatype != null) {
            if (parseType != null && parseType != parseTypePlain) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:parseType.", startElt);
            }
            if (rdfResourceStr != null) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:resource.", startElt);
            }
            if (objBlankNodeLabel != null) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:NodeId.", startElt);
            }
        }
        if (rdfResourceStr != null && objBlankNodeLabel != null) {
            throw this.RDFXMLparseError("Can't have both rdf:nodeId and rdf:resource on a property element", startElt);
        }
        if (rdfResourceStr != null && parseType != parseTypePlain) {
            throw this.RDFXMLparseError("Both rdf:resource and rdf:ParseType on a property element. Only one allowed", startElt);
        }
        if (objBlankNodeLabel != null && parseType != parseTypePlain) {
            throw this.RDFXMLparseError("Both rdf:NodeId and rdf:ParseType on a property element. Only one allowed", startElt);
        }
        Node resourceObj = null;
        if (rdfResourceStr != null) {
            resourceObj = this.iriResolve(rdfResourceStr, location);
        }
        if (objBlankNodeLabel != null) {
            resourceObj = this.blankNode(objBlankNodeLabel, location);
        }
        Node innerSubject = this.processPropertyAttributes(resourceObj, startElt, true, location);
        if (resourceObj == null && innerSubject != null) {
            emitter.emit(subject, property, innerSubject, location);
            XMLEvent event = this.nextEventAny();
            if (!event.isEndElement()) {
                throw this.RDFXMLparseError("Expecting end element tag when using property attributes on a property element", startElt);
            }
            return event;
        }
        if (resourceObj != null) {
            emitter.emit(subject, property, resourceObj, location);
            XMLEvent event = this.nextEventAny();
            if (!event.isEndElement()) {
                throw this.RDFXMLparseError("Expecting end element tag when using rdf:resource or rdf:NodeId on a proeprty.", startElt);
            }
            return event;
        }
        switch (switch (parseTypeName = parseType) {
            case parseTypeLiteralAlt -> {
                this.RDFXMLparseWarning("Encountered rdf:parseType='literal'. Treated as rdf:parseType='Literal'", location);
                yield parseTypeLiteral;
            }
            case parseTypeLiteralStmts -> {
                this.RDFXMLparseWarning("Encountered rdf:parseType='Statements'. Treated as rdf:parseType='Literal'", location);
                yield parseTypeLiteral;
            }
        }) {
            case "Resource": {
                if (ReaderRDFXML_StAX_EV.TRACE) {
                    this.trace.println("rdfParseType=Resource");
                }
                XMLEvent event = this.parseTypeResource(subject, property, emitter, startElt);
                return event;
            }
            case "Literal": {
                if (ReaderRDFXML_StAX_EV.TRACE) {
                    this.trace.println("rdfParseType=Literal");
                }
                XMLEvent event = this.parseTypeLiteral(subject, property, emitter, startElt);
                return event;
            }
            case "Collection": {
                if (ReaderRDFXML_StAX_EV.TRACE) {
                    this.trace.println("rdfParseType=Collection");
                }
                XMLEvent event = this.parseTypeCollection(subject, property, emitter, startElt);
                return event;
            }
            case "$$": {
                break;
            }
            default: {
                throw this.RDFXMLparseError("Not a legal defined rdf:parseType: " + parseType, startElt);
            }
        }
        XMLEvent event = this.nextEventAny();
        if (event.isCharacters()) {
            this.accCharacters.setLength(0);
            StringBuilder sBuff = this.accCharacters;
            while (event.isCharacters()) {
                Characters initialChars = event.asCharacters();
                sBuff.append(initialChars.getData());
                event = this.nextEventAny();
            }
            if (event.isStartElement()) {
                if (!ParserRRX_StAX_EV.isWhitespace(sBuff)) {
                    String msg = ParserRRX_StAX_EV.nonWhitespaceMsg(sBuff.toString());
                    throw this.RDFXMLparseError("Content before node element. '" + msg + "'", event);
                }
                event = this.processNestedNodeElement(event, subject, property, emitter);
                return event;
            }
            if (event.isEndElement()) {
                String lexicalForm = sBuff.toString();
                this.accCharacters.setLength(0);
                Location loc2 = event.getLocation();
                Node obj = datatype != null ? this.literalDatatype(lexicalForm, datatype, loc2) : (this.currentLang() != null ? this.literal(lexicalForm, this.currentLang, loc2) : this.literal(lexicalForm, loc2));
                emitter.emit(subject, property, obj, loc2);
                return event;
            }
            throw this.RDFXMLparseError("Unexpected element: " + ParserRRX_StAX_EV.str(event), event);
        }
        if (event.isStartElement()) {
            event = this.processNestedNodeElement(event, subject, property, emitter);
            return event;
        }
        if (!event.isEndElement()) {
            throw this.RDFXMLparseError("Malformed property. " + ParserRRX_StAX_EV.str(event), event);
        }
        emitter.emit(subject, property, NodeConst.emptyString, event.getLocation());
        return event;
    }

    private Node processPropertyAttributes(Node resourceObj, StartElement startElt, boolean isPropertyElement, Location location) {
        String parseTypeStr;
        List<Attribute> propertyAttributes = this.gatherPropertyAttributes(startElt, location);
        if (propertyAttributes.isEmpty()) {
            return null;
        }
        if (isPropertyElement && (parseTypeStr = this.objectParseType(startElt)) != parseTypePlain) {
            throw this.RDFXMLparseError("The attribute rdf:parseType is not permitted with property attributes on a property element: " + ParserRRX_StAX_EV.str(startElt.getName()), location);
        }
        Node innerSubject = resourceObj == null ? this.blankNode(location) : resourceObj;
        this.outputPropertyAttributes(innerSubject, propertyAttributes, location);
        return innerSubject;
    }

    private List<Attribute> gatherPropertyAttributes(StartElement startElt, Location location) {
        Iterator<Attribute> x = startElt.getAttributes();
        if (!x.hasNext()) {
            return List.of();
        }
        ArrayList<Attribute> propertyAttributes = new ArrayList<Attribute>();
        while (x.hasNext()) {
            Attribute attribute = x.next();
            boolean isPropertyAttribute = this.checkPropertyAttribute(attribute.getName(), location);
            if (!isPropertyAttribute) continue;
            propertyAttributes.add(attribute);
        }
        return propertyAttributes;
    }

    private void outputPropertyAttributes(Node subject, List<Attribute> propertyAttributes, Location location) {
        for (Attribute attribute : propertyAttributes) {
            QName qName = attribute.getName();
            if (rdfType.equals(qName)) {
                String iriStr = attribute.getValue();
                Node type = this.iriResolve(iriStr, location);
                this.emit(subject, RDF.Nodes.type, type, location);
                return;
            }
            Node property = this.attributeToIRI(qName, location);
            String lexicalForm = attribute.getValue();
            Node object = this.literal(lexicalForm, this.currentLang, location);
            this.emit(subject, property, object, location);
        }
    }

    private boolean checkPropertyAttribute(QName qName, Location location) {
        if (ParserRRX_StAX_EV.isSyntaxAttribute(qName)) {
            return false;
        }
        if (this.coreSyntaxTerm(qName)) {
            return false;
        }
        if (!ParserRRX_StAX_EV.allowedPropertyAttributeURIs(qName)) {
            throw this.RDFXMLparseError("Not allowed as a property attribute: '" + ParserRRX_StAX_EV.str(qName) + "'", location);
        }
        if (this.isNotRecognizedRDFproperty(qName)) {
            this.RDFXMLparseWarning(ParserRRX_StAX_EV.str(qName) + " is not a recognized RDF term for a property attribute", location);
        }
        if (ParserRRX_StAX_EV.isXMLQName(qName)) {
            return false;
        }
        if (ParserRRX_StAX_EV.isXMLNamespace(qName)) {
            this.RDFXMLparseWarning("Unrecognized XML attribute: '" + ParserRRX_StAX_EV.str(qName) + "'", location);
            return false;
        }
        if (StringUtils.isBlank(qName.getNamespaceURI())) {
            String localName = qName.getLocalPart();
            boolean valid = this.checkPropertyAttributeUnqualifiedTerm(localName, location);
            return valid;
        }
        return true;
    }

    private boolean checkPropertyAttributeUnqualifiedTerm(String localName, Location location) {
        String chars3;
        if (ParserRRX_StAX_EV.allowedUnqualifiedTerm(localName)) {
            return true;
        }
        if (localName.length() >= 3 && (chars3 = localName.substring(0, 3)).equalsIgnoreCase("xml")) {
            this.RDFXMLparseWarning("Unrecognized XML non-namespaced attribute '" + localName + "' - ignored", location);
            return false;
        }
        throw this.RDFXMLparseError("Non-namespaced attribute not allowed as a property attribute: '" + localName + "'", location);
    }

    private String objectParseType(StartElement startElt) {
        String parseTypeStr = this.attribute(startElt, rdfParseType);
        return parseTypeStr != null ? parseTypeStr : parseTypePlain;
    }

    private String accumulateLexicalForm(XMLEvent initialEvent, StringBuilder sBuff) {
        XMLEvent event = initialEvent;
        while (event != null && !event.isEndElement()) {
            if (!event.isCharacters()) {
                throw this.RDFXMLparseError("Unexpected element in text element: " + ParserRRX_StAX_EV.str(event), initialEvent);
            }
            sBuff.append(event.asCharacters().getData());
            event = this.nextEventAny();
        }
        String lexicalForm = sBuff.toString();
        return lexicalForm;
    }

    private XMLEvent parseTypeResource(Node subject, Node property, Emitter emitter, StartElement startElt) {
        Node innerSubject = this.blankNode(startElt.getLocation());
        emitter.emit(subject, property, innerSubject, startElt.getLocation());
        XMLEvent event = this.nextEventTag();
        event = this.propertyElementLoop(innerSubject, event);
        return event;
    }

    private XMLEvent parseTypeLiteral(Node subject, Node property, Emitter emitter, StartElement startElt) {
        String text = this.xmlLiteralAccumulateText(startElt);
        Node object = this.literalDatatype(text, XMLLiteralType.rdfXMLLiteral, startElt.getLocation());
        emitter.emit(subject, property, object, startElt.getLocation());
        XMLEvent event = this.peekEvent();
        return event;
    }

    private String xmlLiteralAccumulateText(StartElement startElt) {
        Object x;
        HashMap<String, String> namespaces = Map.of();
        ArrayDeque<HashMap<String, String>> stackNamespaces = new ArrayDeque<HashMap<String, String>>();
        this.accCharacters.setLength(0);
        StringBuilder sBuff = new StringBuilder();
        XMLEvent event = startElt;
        int depth = 0;
        while (event != null) {
            event = this.nextEventRaw();
            if (event.isStartElement()) {
                StartElement evStartElt = event.asStartElement();
                ++depth;
                this.incIndent();
                stackNamespaces.push(namespaces);
                namespaces = new HashMap<String, String>(namespaces);
                sBuff.append(openStartTag);
                QName qname = evStartElt.getName();
                if (qname.getPrefix() != null && !"".equals(qname.getPrefix())) {
                    sBuff.append(qname.getPrefix());
                    sBuff.append(":");
                }
                sBuff.append(qname.getLocalPart());
                this.xmlLiteralNamespaces(namespaces, sBuff, evStartElt);
                this.xmlLiteralAttributes(sBuff, evStartElt);
                sBuff.append(">");
                continue;
            }
            if (event.isEndElement()) {
                this.decIndent();
                if (--depth < 0) break;
                namespaces = (HashMap<String, String>)stackNamespaces.pop();
                sBuff.append(openEndTag);
                QName qname = event.asEndElement().getName();
                if (qname.getPrefix() != null && !"".equals(qname.getPrefix())) {
                    sBuff.append(qname.getPrefix());
                    sBuff.append(":");
                }
                sBuff.append(qname.getLocalPart());
                sBuff.append(">");
                continue;
            }
            if (event.isCharacters()) {
                String s = event.asCharacters().getData();
                s = this.xmlLiteralEscapeText(s);
                sBuff.append(s);
                continue;
            }
            if (event.getEventType() == 5) {
                x = (Comment)event;
                sBuff.append("<!--");
                sBuff.append(x.getText());
                sBuff.append("-->");
                continue;
            }
            if (event.isProcessingInstruction()) {
                ProcessingInstruction procInst = (ProcessingInstruction)event;
                String target = procInst.getTarget();
                String data = procInst.getData();
                sBuff.append("<?");
                sBuff.append(target);
                sBuff.append(' ');
                sBuff.append(data);
                sBuff.append("?>");
                continue;
            }
            throw this.RDFXMLparseError("Unexpected event in rdf:XMLLiteral: " + event.toString(), event);
        }
        x = sBuff.toString();
        this.accCharacters.setLength(0);
        return x;
    }

    private void xmlLiteralAttributes(StringBuilder sBuff, StartElement evStartElt) {
        Iterator<Attribute> iterAttr0 = evStartElt.getAttributes();
        TreeMap<String, Attribute> attrs = new TreeMap<String, Attribute>();
        while (iterAttr0.hasNext()) {
            Attribute attr = iterAttr0.next();
            String k = ParserRRX_StAX_EV.str(attr.getName());
            attrs.put(k, attr);
        }
        for (Attribute attr : attrs.values()) {
            sBuff.append(" ");
            sBuff.append(ParserRRX_StAX_EV.str(attr.getName()));
            sBuff.append("=\"");
            sBuff.append(this.xmlLiteralEscapeAttr(attr.getValue()));
            sBuff.append("\"");
        }
    }

    private void xmlLiteralNamespaces(Map<String, String> namespaces, StringBuilder sBuff, StartElement startElt) {
        NamespaceContext nsCxt = startElt.getNamespaceContext();
        TreeMap<String, String> outputNS = new TreeMap<String, String>();
        this.xmlLiteralNamespaceQName(outputNS, namespaces, nsCxt, startElt.getName());
        Iterator<Attribute> iterAttr = startElt.getAttributes();
        while (iterAttr.hasNext()) {
            Attribute attr = iterAttr.next();
            this.xmlLiteralNamespaceQName(outputNS, namespaces, nsCxt, attr.getName());
        }
        for (String prefix : outputNS.keySet()) {
            String uri = (String)outputNS.get(prefix);
            if (uri == null) continue;
            sBuff.append(" ");
            if (prefix.isEmpty()) {
                sBuff.append("xmlns=\"");
                sBuff.append(uri);
                sBuff.append("\"");
                continue;
            }
            sBuff.append("xmlns:");
            sBuff.append(prefix);
            sBuff.append("=\"");
            sBuff.append(uri);
            sBuff.append("\"");
        }
    }

    private void xmlLiteralNamespaceQName(Map<String, String> outputNS, Map<String, String> namespaces, NamespaceContext nsCxt, QName qName) {
        String prefix = qName.getPrefix();
        String namespaceURI = nsCxt.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            // empty if block
        }
        if (namespaceURI != "" && (!namespaces.containsKey(prefix) || namespaceURI != null && !namespaces.get(prefix).equals(namespaceURI))) {
            outputNS.put(prefix, namespaceURI);
            namespaces.put(prefix, namespaceURI);
        }
    }

    private String xmlLiteralEscapeText(CharSequence stringAcc) {
        StringBuilder sBuff = new StringBuilder();
        int len = stringAcc.length();
        for (int i = 0; i < len; ++i) {
            String replace;
            char c = stringAcc.charAt(i);
            switch (c) {
                case '&': {
                    String string = "&amp;";
                    break;
                }
                case '<': {
                    String string = "&lt;";
                    break;
                }
                case '>': {
                    String string = "&gt;";
                    break;
                }
                default: {
                    String string = replace = null;
                }
            }
            if (replace == null) {
                sBuff.append(c);
                continue;
            }
            sBuff.append(replace);
        }
        return sBuff.toString();
    }

    private String xmlLiteralEscapeAttr(CharSequence stringAcc) {
        StringBuilder sBuff = new StringBuilder();
        int len = stringAcc.length();
        for (int i = 0; i < len; ++i) {
            String replace;
            char c = stringAcc.charAt(i);
            switch (c) {
                case '&': {
                    String string = "&amp;";
                    break;
                }
                case '<': {
                    String string = "&lt;";
                    break;
                }
                case '\"': {
                    String string = "&quot;";
                    break;
                }
                default: {
                    String string = replace = null;
                }
            }
            if (replace == null) {
                sBuff.append(c);
                continue;
            }
            sBuff.append(replace);
        }
        return sBuff.toString();
    }

    private XMLEvent parseTypeCollection(Node subject, Node property, Emitter emitter, StartElement startElt) {
        XMLEvent event = startElt;
        Node lastCell = null;
        Location location = startElt.getLocation();
        while ((event = this.nextEventTag()).isStartElement()) {
            location = event.getLocation();
            Node thisCell = this.blankNode(event.getLocation());
            if (lastCell == null) {
                lastCell = thisCell;
                emitter.emit(subject, property, thisCell, location);
            } else {
                this.emit(lastCell, NodeConst.nodeRest, thisCell, location);
            }
            StartElement itemStart = event.asStartElement();
            Node itemSubject = this.attributesToSubjectNode(itemStart);
            this.emit(thisCell, RDF.Nodes.first, itemSubject, itemStart.getLocation());
            this.nodeElement(itemSubject, itemStart);
            lastCell = thisCell;
        }
        if (lastCell != null) {
            this.emit(lastCell, NodeConst.nodeRest, NodeConst.nodeNil, location);
        } else {
            emitter.emit(subject, property, NodeConst.nodeNil, location);
        }
        return event;
    }

    private Node reifyStatement(StartElement startElt) {
        String reifyId = this.attribute(startElt, rdfID);
        if (reifyId == null) {
            return null;
        }
        Node reify = this.iriFromID(reifyId, startElt.getLocation());
        return reify;
    }

    private String currentLang() {
        if (this.currentLang == null || this.currentLang.isEmpty()) {
            return null;
        }
        return this.currentLang;
    }

    private XMLEvent processNestedNodeElement(XMLEvent event, Node subject, Node property, Emitter emitter) {
        StartElement startEltInner = event.asStartElement();
        boolean hasFrame = this.startElement(startEltInner);
        Node subjectInner = this.attributesToSubjectNode(startEltInner);
        emitter.emit(subject, property, subjectInner, startEltInner.getLocation());
        this.nodeElement(subjectInner, startEltInner);
        event = this.nextEventTag();
        if (event.isStartElement()) {
            throw this.RDFXMLparseError("Start tag after inner node element (only one node element permitted): got " + ParserRRX_StAX_EV.str(event), event);
        }
        if (!event.isEndElement()) {
            throw this.RDFXMLparseError("Expected an end element: got " + ParserRRX_StAX_EV.str(event), event);
        }
        this.endElement(hasFrame);
        return event;
    }

    private Node attributesToSubjectNode(StartElement startElt) {
        Location location = startElt.getLocation();
        String iriStr = this.attribute(startElt, rdfAbout);
        String idStr = this.attribute(startElt, rdfID);
        String nodeId = this.attribute(startElt, rdfNodeID);
        if (nodeId != null && iriStr != null && nodeId != null) {
            throw this.RDFXMLparseError("All of rdf:about, rdf:NodeId and rdf:ID found. Must be only one.", startElt);
        }
        if (iriStr != null && idStr != null) {
            throw this.RDFXMLparseError("Both rdf:about and rdf:ID found. Must be only one.", startElt);
        }
        if (nodeId != null && iriStr != null) {
            throw this.RDFXMLparseError("Both rdf:about and rdf:NodeID found. Must be only one.", startElt);
        }
        if (nodeId != null && idStr != null) {
            throw this.RDFXMLparseError("Both rdf:NodeID rdf:ID found. Must be only one.", startElt);
        }
        if (iriStr != null) {
            return this.iriResolve(iriStr, location);
        }
        if (idStr != null) {
            return this.iriFromID(idStr, location);
        }
        if (nodeId != null) {
            return this.blankNode(nodeId, location);
        }
        return this.blankNode(location);
    }

    private String attribute(StartElement startElt, QName attrName) {
        Attribute attr = startElt.getAttributeByName(attrName);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    private Node qNameToIRI(QName qName, QNameUsage usage, Location location) {
        if (StringUtils.isBlank(qName.getNamespaceURI())) {
            throw this.RDFXMLparseError("Unqualified " + usage.msg + " not allowed: <" + qName.getLocalPart() + ">", location);
        }
        String uriStr = this.strQNameToIRI(qName);
        return this.iriDirect(uriStr, location);
    }

    private String strQNameToIRI(QName qName) {
        return qName.getNamespaceURI() + qName.getLocalPart();
    }

    private Node attributeToIRI(QName qName, Location location) {
        String namespaceURI = qName.getNamespaceURI();
        String localName = qName.getLocalPart();
        if (StringUtils.isBlank(namespaceURI)) {
            if (ParserRRX_StAX_EV.allowedUnqualifiedTerm(localName)) {
                namespaceURI = rdfNS;
            } else {
                throw this.RDFXMLparseError("Unqualified property attribute not allowed: '" + localName + "'", location);
            }
        }
        String uriStr = namespaceURI + localName;
        return this.iriDirect(uriStr, location);
    }

    private RiotException handleXMLStreamException(XMLStreamException ex) {
        String msg = this.xmlStreamExceptionMessage(ex);
        if (ex.getLocation() != null) {
            int line = ex.getLocation().getLineNumber();
            int col = ex.getLocation().getColumnNumber();
            this.errorHandler.fatal(msg, line, col);
        } else {
            this.errorHandler.fatal(msg, -1L, -1L);
        }
        return new RiotException(ex.getMessage(), ex);
    }

    private String xmlStreamExceptionMessage(XMLStreamException ex) {
        String marker;
        int i;
        String msg = ex.getMessage();
        if (ex.getLocation() != null && (i = msg.indexOf(marker = "\nMessage: ")) > 0) {
            msg = msg.substring(i + marker.length());
        }
        return msg;
    }

    private XMLEvent peekEvent() {
        if (!this.xmlEventReader.hasNext()) {
            return null;
        }
        try {
            return this.xmlEventReader.peek();
        }
        catch (XMLStreamException ex) {
            throw this.handleXMLStreamException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XMLEvent nextEventTag() {
        try {
            block7: while (true) {
                if (!this.xmlEventReader.hasNext()) {
                    return null;
                }
                XMLEvent ev = this.xmlEventReader.nextEvent();
                int evType = ev.getEventType();
                switch (evType) {
                    case 1: 
                    case 2: {
                        if (EVENTS) {
                            System.out.println("-- Tag: " + ParserRRX_StAX_EV.str(ev));
                        }
                        return ev;
                    }
                    case 4: 
                    case 12: {
                        Characters chars = ev.asCharacters();
                        if (ParserRRX_StAX_EV.isWhitespace(ev)) continue block7;
                        String str2 = ev.asCharacters().getData();
                        String text = ParserRRX_StAX_EV.nonWhitespaceMsg(str2);
                        throw this.RDFXMLparseError("Expecting a start or end element. Got characters '" + text + "'", ev);
                    }
                    case 5: 
                    case 11: {
                        continue block7;
                    }
                }
                throw this.RDFXMLparseError("Unexpected  event " + ParserRRX_StAX_EV.str(ev), ev);
            }
        }
        catch (XMLStreamException ex) {
            throw this.handleXMLStreamException(ex);
        }
    }

    private XMLEvent nextEventAny() {
        try {
            XMLEvent ev = null;
            while (this.xmlEventReader.hasNext()) {
                ev = this.xmlEventReader.nextEvent();
                if (ParserRRX_StAX_EV.isComment(ev)) continue;
                if (!ev.isProcessingInstruction()) break;
                this.RDFXMLparseWarning("XML Processing instruction - ignored", ev);
            }
            if (EVENTS) {
                if (ev == null) {
                    System.out.println("-- Read: end of events");
                } else {
                    System.out.println("-- Event: " + ParserRRX_StAX_EV.str(ev));
                }
            }
            return ev;
        }
        catch (XMLStreamException ex) {
            throw this.handleXMLStreamException(ex);
        }
    }

    private XMLEvent nextEventRaw() {
        try {
            XMLEvent ev = null;
            if (this.xmlEventReader.hasNext()) {
                ev = this.xmlEventReader.nextEvent();
            }
            if (EVENTS) {
                if (ev == null) {
                    System.out.println("-- Read: end of events");
                } else {
                    System.out.println("-- Event: " + ParserRRX_StAX_EV.str(ev));
                }
            }
            return ev;
        }
        catch (XMLStreamException ex) {
            throw this.handleXMLStreamException(ex);
        }
    }

    private boolean processNamespaces(StartElement startElt) {
        Iterator<Namespace> iter = startElt.getNamespaces();
        boolean result = iter.hasNext();
        if (ReaderRDFXML_StAX_EV.TRACE) {
            iter.forEachRemaining(namespace2 -> {
                String prefix = namespace2.getPrefix();
                String iriStr = namespace2.getValue();
                this.trace.printf("+ PREFIX %s: <%s>\n", prefix, iriStr);
            });
        }
        return result;
    }

    private boolean startElement(StartElement startElt) {
        this.processNamespaces(startElt);
        boolean hasFrame = this.processBaseAndLang(startElt);
        return hasFrame;
    }

    private boolean processBaseAndLang(StartElement startElt) {
        boolean hasFrame;
        IRIx xmlBase = this.xmlBase(startElt);
        String xmlLang = this.xmlLang(startElt);
        if (ReaderRDFXML_StAX_EV.TRACE) {
            if (xmlBase != null) {
                this.trace.printf("+ BASE <%s>\n", xmlBase);
            }
            if (xmlLang != null) {
                this.trace.printf("+ LANG @%s\n", xmlLang);
            }
        }
        boolean bl = hasFrame = xmlBase != null || xmlLang != null;
        if (hasFrame) {
            this.pushFrame(xmlBase != null ? xmlBase : this.currentBase, xmlLang != null ? xmlLang : this.currentLang);
        }
        return hasFrame;
    }

    private void endElement(boolean hasFrame) {
        if (hasFrame) {
            this.popFrame();
        }
    }

    private void emitInitialBaseAndNamespaces(StartElement startElt) {
        String xmlBase = this.attribute(startElt, xmlQNameBase);
        if (xmlBase != null) {
            this.emitBase(xmlBase, startElt.getLocation());
        }
        startElt.getNamespaces().forEachRemaining(namespace2 -> {
            String prefix = namespace2.getPrefix();
            String iriStr = namespace2.getValue();
            this.emitPrefix(prefix, iriStr, startElt.getLocation());
        });
    }

    private void emit(Node subject, Node property, Node object, Location location) {
        Objects.requireNonNull(subject);
        Objects.requireNonNull(property);
        Objects.requireNonNull(object);
        Objects.requireNonNull(location);
        this.destination.triple(Triple.create(subject, property, object));
    }

    private void emitReify(Node reify, Node subject, Node property, Node object, Location location) {
        this.emit(subject, property, object, location);
        if (reify != null) {
            this.emit(reify, NodeConst.nodeRDFType, RDF.Nodes.Statement, location);
            this.emit(reify, RDF.Nodes.subject, subject, location);
            this.emit(reify, RDF.Nodes.predicate, property, location);
            this.emit(reify, RDF.Nodes.object, object, location);
        }
    }

    private void emitBase(String base, Location location) {
        this.destination.base(base);
    }

    private void emitPrefix(String prefix, String iriStr, Location location) {
        this.destination.prefix(prefix, iriStr);
    }

    private IRIx xmlBase(StartElement startElt) {
        String baseStr = this.attribute(startElt, xmlQNameBase);
        if (baseStr == null) {
            return null;
        }
        Location location = startElt.getLocation();
        IRIx irix = this.resolveIRIxNoWarning(baseStr, location);
        if (irix.isRelative()) {
            this.RDFXMLparseWarning("Relative URI for base: <" + baseStr + ">", location);
        }
        return irix;
    }

    private String xmlLang(StartElement startElt) {
        return this.attribute(startElt, xmlQNameLang);
    }

    private Node iriFromID(String idStr, Location location) {
        this.checkValidNCName(idStr, location);
        Location prev = this.previousUseOfID(idStr, location);
        if (prev != null) {
            this.RDFXMLparseWarning("Reuse of rdf:ID '" + idStr + "' at " + ParserRRX_StAX_EV.str(prev), location);
        }
        Node uri = this.iriResolve("#" + idStr, location);
        return uri;
    }

    private Node iriDirect(String uriStr, Location location) {
        Objects.requireNonNull(uriStr);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createURI(uriStr, (long)line, (long)col);
    }

    private Node iriResolve(String uriStr, Location location) {
        Objects.requireNonNull(uriStr);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return uriStr.startsWith("_:") ? this.parserProfile.createURI(uriStr, (long)line, (long)col) : this.parserProfile.createURI(this.resolveIRIx(uriStr, location), (long)line, (long)col);
    }

    private IRIx resolveIRIx(String uriStr, Location location) {
        try {
            IRIx iri2 = this.resolveIRIxNoWarning(uriStr, location);
            if (iri2.isRelative()) {
                throw this.RDFXMLparseError("Relative URI encountered: <" + iri2.str() + ">", location);
            }
            return iri2;
        }
        catch (IRIException ex) {
            throw this.RDFXMLparseError(ex.getMessage(), location);
        }
    }

    private IRIx resolveIRIxNoWarning(String uriStr, Location location) {
        try {
            return this.currentIriCache.get(uriStr, uri -> {
                if (this.currentBase != null) {
                    return this.currentBase.resolve((String)uri);
                }
                return IRIx.create(uriStr);
            });
        }
        catch (IRIException ex) {
            throw this.RDFXMLparseError(ex.getMessage(), location);
        }
    }

    private Node blankNode(Location location) {
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createBlankNode(null, line, col);
    }

    private Node blankNode(String label, Location location) {
        Objects.requireNonNull(label);
        Objects.requireNonNull(location);
        this.checkValidNCName(label, location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createBlankNode(null, label, line, col);
    }

    private Node literal(String lexical, Location location) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createStringLiteral(lexical, line, col);
    }

    private Node literal(String lexical, String lang, Location location) {
        if (lang == null) {
            return this.literal(lexical, location);
        }
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createLangLiteral(lexical, lang, line, col);
    }

    private Node literalDatatype(String lexical, String datatype, Location location) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(datatype);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        RDFDatatype dt = NodeFactory.getType(datatype);
        return this.parserProfile.createTypedLiteral(lexical, dt, line, col);
    }

    private Node literalDatatype(String lexical, RDFDatatype datatype, Location location) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(datatype);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createTypedLiteral(lexical, datatype, line, col);
    }

    private boolean qNameMatches(QName qName1, QName qName2) {
        return Objects.equals(qName1.getNamespaceURI(), qName2.getNamespaceURI()) && Objects.equals(qName1.getLocalPart(), qName2.getLocalPart());
    }

    private void checkValidNCName(String string, Location location) {
        boolean isValid = XML11Char.isXML11ValidNCName(string);
        if (!isValid) {
            this.RDFXMLparseWarning("Not a valid XML NCName: '" + string + "'", location);
        }
    }

    private void noContentAllowed(XMLEvent event) {
        if (event.isCharacters()) {
            String content = event.asCharacters().getData();
            content = ParserRRX_StAX_EV.nonWhitespaceMsg(content);
            throw this.RDFXMLparseError("Expected XML start tag or end tag. Found text content (possible striping error): \"" + content + "\"", event);
        }
    }

    private static boolean isRDF(QName qName) {
        return rdfNS.equals(qName.getNamespaceURI());
    }

    private static boolean isMemberProperty(QName qName) {
        if (!ParserRRX_StAX_EV.isRDF(qName)) {
            return false;
        }
        return ParserRRX_StAX_EV.isMemberPropertyLocalName(qName.getLocalPart());
    }

    private static boolean isMemberPropertyLocalName(String localName) {
        if (!localName.startsWith("_")) {
            return false;
        }
        String number = localName.substring(1);
        if (number.startsWith("-") || number.startsWith("0")) {
            return false;
        }
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException e2) {
            try {
                BigInteger i = new BigInteger(number);
                return true;
            }
            catch (NumberFormatException ee) {
                return false;
            }
        }
    }

    private boolean isNotRecognizedRDFtype(QName qName) {
        if (!ParserRRX_StAX_EV.isRDF(qName)) {
            return false;
        }
        String ln2 = qName.getLocalPart();
        return !knownRDFTypes.contains(ln2);
    }

    private boolean isNotRecognizedRDFproperty(QName qName) {
        if (!ParserRRX_StAX_EV.isRDF(qName)) {
            return false;
        }
        String ln2 = qName.getLocalPart();
        if (ParserRRX_StAX_EV.isMemberPropertyLocalName(ln2)) {
            return false;
        }
        return !knownRDFProperties.contains(ln2);
    }

    private void incIndent() {
        if (ReaderRDFXML_StAX_EV.TRACE) {
            this.trace.incIndent();
        }
    }

    private void decIndent() {
        if (ReaderRDFXML_StAX_EV.TRACE) {
            this.trace.decIndent();
        }
    }

    private static boolean isComment(XMLEvent event) {
        if (event == null) {
            return false;
        }
        return event.getEventType() == 5;
    }

    private static boolean isWhitespace(XMLEvent event) {
        if (event == null) {
            return false;
        }
        if (event.isCharacters()) {
            String x = event.asCharacters().getData();
            return ParserRRX_StAX_EV.isWhitespace(x);
        }
        return false;
    }

    private static boolean isWhitespace(CharSequence x) {
        return StringUtils.isWhitespace(x);
    }

    private static String str(Location location) {
        if (location == null) {
            return "[-,-]";
        }
        if (location.getLineNumber() < 0 && location.getColumnNumber() < 0) {
            return "[?,?]";
        }
        if (location.getLineNumber() < 0) {
            return String.format("[-, Col: %d]", location.getColumnNumber());
        }
        if (location.getColumnNumber() < 0) {
            return String.format("[Line: %d, -]", location.getLineNumber());
        }
        return String.format("[Line: %d, Col: %d]", location.getLineNumber(), location.getColumnNumber());
    }

    private static String str(QName qName) {
        String prefix = qName.getPrefix();
        if (prefix == null || prefix.isEmpty()) {
            return String.format("%s", qName.getLocalPart());
        }
        return String.format("%s:%s", qName.getPrefix(), qName.getLocalPart());
    }

    private static String str(XMLEvent event) {
        return switch (event.getEventType()) {
            case 1 -> ParserRRX_StAX_EV.str(event.asStartElement().getName());
            case 2 -> "/" + ParserRRX_StAX_EV.str(event.asEndElement().getName());
            case 4 -> "Event Characters";
            case 5 -> "Event Comment";
            case 7 -> "Event StartDocument";
            case 8 -> "Event EndDocument";
            case 11 -> "DTD";
            case 15 -> "DTD Entity Decl";
            case 9 -> "DTD Entity Ref";
            default -> "" + event.getEventType();
        };
    }

    private static String nonWhitespaceMsg(String string) {
        int MaxLen = 10;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            int len = Math.min(10, length - i);
            Object x = string.substring(i, i + len);
            if (length > 10) {
                x = (String)x + "...";
            }
            x = EscapeStr.stringEsc((String)x);
            x = ((String)x).stripTrailing();
            return x;
        }
        throw new RDFXMLParseException("Failed to find any non-whitespace characters");
    }

    private record BaseLang(IRIx base, String lang, Cache<String, IRIx> iriCache) {
    }

    private static enum QNameUsage {
        TypedNodeElement("typed node element"),
        PropertyElement("property element");

        final String msg;

        private QNameUsage(String msg) {
            this.msg = msg;
        }
    }

    private static class Counter {
        int value = 1;

        private Counter() {
        }
    }

    static interface Emitter {
        public void emit(Node var1, Node var2, Node var3, Location var4);
    }
}

