/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import java.util.function.Predicate;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.ctl.ActionAsyncTask;
import org.apache.jena.fuseki.ctl.TaskBase;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.slf4j.Logger;

public class ActionCompact
extends ActionAsyncTask {
    private static Predicate<DatasetGraph> notTDB2 = dsg -> org.apache.jena.tdb1.sys.TDBInternal.isTDB1(dsg);

    public ActionCompact() {
        super("Compact");
    }

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    protected Runnable createRunnable(HttpAction action) {
        String name = ActionCompact.getItemName(action);
        if (name == null) {
            action.log.error("Null for dataset name in item request");
            ServletOps.errorOccurred("Null for dataset name in item request");
            return null;
        }
        action.log.info(String.format("[%d] Compact dataset %s", action.id, name));
        CompactTask task = new CompactTask(action);
        if (task.dataset == null) {
            ServletOps.errorBadRequest("Dataset not found");
            return null;
        }
        DatasetGraph dsg = ActionCompact.getTDB2(task.dataset);
        if (dsg == null) {
            ServletOps.errorBadRequest("Not a TDB2 dataset: Compact only applies to TDB2");
            return null;
        }
        return task;
    }

    private static DatasetGraph getTDB2(DatasetGraph dsg) {
        return ActionCompact.unwrap(dsg, x -> TDBInternal.isTDB2(x), notTDB2);
    }

    private static DatasetGraph unwrap(DatasetGraph dsg, Predicate<DatasetGraph> predicate, Predicate<DatasetGraph> failPredicate) {
        while (!failPredicate.test(dsg)) {
            if (predicate.test(dsg)) {
                return dsg;
            }
            if (!(dsg instanceof DatasetGraphWrapper)) {
                return null;
            }
            DatasetGraphWrapper dsgw = (DatasetGraphWrapper)dsg;
            dsg = dsgw.getWrapped();
        }
        return null;
    }

    static class CompactTask
    extends TaskBase {
        private static final Logger log = Fuseki.compactLog;
        private final boolean shouldDeleteOld;

        public CompactTask(HttpAction action) {
            super(action);
            String deleteOldParam = action.getRequestParameter("deleteOld");
            this.shouldDeleteOld = deleteOldParam != null && (deleteOldParam.isEmpty() || deleteOldParam.equalsIgnoreCase("true"));
        }

        @Override
        public void run() {
            try {
                DatasetGraph dsg = ActionCompact.getTDB2(this.dataset);
                log.info(String.format("[%d] >>>> Start compact %s", this.actionId, this.datasetName));
                DatabaseMgr.compact(dsg, this.shouldDeleteOld);
                log.info(String.format("[%d] <<<< Finish compact %s", this.actionId, this.datasetName));
            }
            catch (Throwable ex) {
                log.warn(String.format("[%d] **** Exception in compact", this.actionId), ex);
                throw ex;
            }
        }
    }
}

