/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.authz;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;

public abstract class AuthorizationFilter403
extends AuthorizationFilter {
    private String message;

    protected AuthorizationFilter403(String text) {
        this.setMessage(text);
    }

    protected AuthorizationFilter403() {
        this(null);
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletResponse httpResponse;
        try {
            httpResponse = WebUtils.toHttp(response);
        }
        catch (ClassCastException ex) {
            return super.onAccessDenied(request, response);
        }
        if (this.message == null) {
            httpResponse.sendError(403);
        } else {
            httpResponse.sendError(403, this.message);
        }
        return false;
    }
}

