/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.store.legacy;

import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class FieldFilter {
    public static final FieldFilter EMPTY = new FieldFilter();
    private final Predicate<Triple> filter;
    private final boolean hasFilter;

    private FieldFilter(Predicate<Triple> filter) {
        this.filter = filter;
        this.hasFilter = true;
    }

    private FieldFilter() {
        this.filter = null;
        this.hasFilter = false;
    }

    public static FieldFilter filterOn(Triple.Field f1, Node n1, Triple.Field f2, Node n2) {
        if (n1.isConcrete()) {
            if (n2.isConcrete()) {
                return new FieldFilter(t -> n1.equals(f1.getField((Triple)t)) && n2.equals(f2.getField((Triple)t)));
            }
            return new FieldFilter(t -> n1.equals(f1.getField((Triple)t)));
        }
        if (n2.isConcrete()) {
            return new FieldFilter(t -> n2.equals(f2.getField((Triple)t)));
        }
        return EMPTY;
    }

    public boolean hasFilter() {
        return this.hasFilter;
    }

    public Predicate<Triple> getFilter() {
        return this.filter;
    }
}

